/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class CommandCommandHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue profile;
    private final ArgumentWithValue action = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)new SimpleTabCompleter(new String[]{"add", "list", "remove"}), 0, "--action");
    private final ArgumentWithValue nodePath;
    private final ArgumentWithValue idProperty;
    private final ArgumentWithValue commandName;
    private final CommandRegistry cmdRegistry;

    public CommandCommandHandler(CommandRegistry cmdRegistry) {
        super("command", true);
        this.cmdRegistry = cmdRegistry;
        this.action.addCantAppearAfter(this.helpArg);
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                String actionName = CommandCommandHandler.this.action.getValue(ctx.getParsedArguments());
                if (actionName == null || !"add".equals(actionName)) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.profile.addCantAppearAfter(this.helpArg);
        this.nodePath = new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int offset = 0;
                if (ctx.isDomainMode()) {
                    String profileName = CommandCommandHandler.this.profile.getValue(ctx.getParsedArguments());
                    if (profileName == null) {
                        return -1;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append("profile=").append(profileName).append('/');
                    offset = buf.length();
                    buf.append(buffer);
                    buffer = buf.toString();
                }
                return OperationRequestCompleter.INSTANCE.complete(ctx, buffer, cursor + offset, candidates) - offset;
            }
        }, "--node-type"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !CommandCommandHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                    return false;
                }
                return "add".equals(CommandCommandHandler.this.action.getValue(ctx.getParsedArguments())) && super.canAppearNext(ctx);
            }
        };
        this.idProperty = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                List<Property> props = CommandCommandHandler.this.getNodeProperties(ctx);
                if (props.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<String> candidates = new ArrayList<String>();
                for (Property prop : props) {
                    ModelNode value = prop.getValue();
                    if (!value.has("access-type") || !"read-only".equals(value.get("access-type").asString())) continue;
                    candidates.add(prop.getName());
                }
                return candidates;
            }
        }), "--property-id");
        this.idProperty.addRequiredPreceding(this.nodePath);
        this.commandName = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                String actionName = CommandCommandHandler.this.action.getValue(ctx.getParsedArguments());
                if (actionName == null) {
                    return Collections.emptyList();
                }
                if (actionName.equals("add")) {
                    String thePath = CommandCommandHandler.this.nodePath.getValue(ctx.getParsedArguments());
                    if (thePath == null) {
                        return Collections.emptyList();
                    }
                    DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler();
                    try {
                        DefaultOperationRequestParser.INSTANCE.parse(thePath, handler);
                    }
                    catch (CommandFormatException e) {
                        return Collections.emptyList();
                    }
                    OperationRequestAddress typeAddress = handler.getAddress();
                    if (!typeAddress.endsOnType()) {
                        return Collections.emptyList();
                    }
                    return Collections.singletonList(typeAddress.getNodeType());
                }
                if (actionName.equals("remove")) {
                    return CommandCommandHandler.this.getExistingCommands();
                }
                return Collections.emptyList();
            }
        }), "--command-name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                ParsedArguments args = ctx.getParsedArguments();
                if (this.isPresent(args)) {
                    return false;
                }
                String actionStr = CommandCommandHandler.this.action.getValue(args);
                if (actionStr == null) {
                    return false;
                }
                if ("add".equals(actionStr)) {
                    return CommandCommandHandler.this.idProperty.isPresent(args);
                }
                return "remove".equals(actionStr);
            }
        };
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ParsedArguments args = ctx.getParsedArguments();
        String action = this.action.getValue(args);
        if (action == null) {
            ctx.printLine("Command is missing.");
            return;
        }
        if (action.equals("list")) {
            ctx.printColumns(this.getExistingCommands());
            return;
        }
        if (action.equals("add")) {
            String nodePath = this.nodePath.getValue(args, true);
            String propName = this.idProperty.getValue(args, true);
            String cmdName = this.commandName.getValue(args, true);
            if (!this.validateInput(ctx, this.profile.getValue(args), nodePath, propName)) {
                return;
            }
            if (this.cmdRegistry.getCommandHandler(cmdName) != null) {
                ctx.printLine("Command '" + cmdName + "' already registered.");
                return;
            }
            this.cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler(nodePath, this.idProperty.getValue(args)), cmdName);
            return;
        }
        if (action.equals("remove")) {
            String cmdName = this.commandName.getValue(args, true);
            CommandHandler handler = this.cmdRegistry.getCommandHandler(cmdName);
            if (!(handler instanceof GenericTypeOperationHandler)) {
                ctx.printLine("Command '" + cmdName + "' is not a generic type command.");
                return;
            }
            this.cmdRegistry.remove(cmdName);
            return;
        }
        ctx.printLine("Unexpected action: " + action);
    }

    protected List<String> getExistingCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
            if (!(this.cmdRegistry.getCommandHandler(cmd) instanceof GenericTypeOperationHandler)) continue;
            commands.add(cmd);
        }
        return commands;
    }

    protected List<Property> getNodeProperties(CommandContext ctx) {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return Collections.emptyList();
        }
        request.get("operation").set("read-resource-description");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (!result.hasDefined("result")) {
            return Collections.emptyList();
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            return Collections.emptyList();
        }
        return result.get("attributes").asPropertyList();
    }

    protected ModelNode initRequest(CommandContext ctx) {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (ctx.isDomainMode()) {
            String profileName = this.profile.getValue(ctx.getParsedArguments());
            if (this.profile == null) {
                ctx.printLine("--profile argument is required to get the node description.");
                return null;
            }
            address.add("profile", profileName);
        }
        String type = this.nodePath.getValue(ctx.getParsedArguments());
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler();
        try {
            DefaultOperationRequestParser.INSTANCE.parse(type, handler);
        }
        catch (CommandFormatException e) {
            throw new IllegalArgumentException("Failed to parse nodeType: " + e.getMessage());
        }
        OperationRequestAddress typeAddress = handler.getAddress();
        if (!typeAddress.endsOnType()) {
            return null;
        }
        String typeName = typeAddress.toParentNode().getType();
        for (OperationRequestAddress.Node node : typeAddress) {
            address.add(node.getType(), node.getName());
        }
        address.add(typeName, "?");
        return request;
    }

    protected boolean validateInput(CommandContext ctx, String profileName, String typePath, String propertyName) {
        ModelNode result;
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (profileName != null) {
            address.add("profile", profileName);
        }
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler();
        try {
            DefaultOperationRequestParser.INSTANCE.parse(typePath, handler);
        }
        catch (CommandFormatException e) {
            ctx.printLine("Failed to validate input: " + e.getLocalizedMessage());
            return false;
        }
        OperationRequestAddress typeAddress = handler.getAddress();
        if (!typeAddress.endsOnType()) {
            ctx.printLine("Node path '" + typePath + "' doesn't appear to end on a type.");
            return false;
        }
        String typeName = typeAddress.toParentNode().getType();
        for (OperationRequestAddress.Node node : typeAddress) {
            address.add(node.getType(), node.getName());
        }
        request.get("operation").set("read-children-types");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            ctx.printLine("Failed to validate input: " + e.getLocalizedMessage());
            return false;
        }
        if (!result.hasDefined("result")) {
            ctx.printLine("Failed to validate input: operation response doesn't contain result info.");
            return false;
        }
        boolean pathValid = false;
        for (ModelNode typeNode : result.get("result").asList()) {
            if (!typeNode.asString().equals(typeName)) continue;
            pathValid = true;
            break;
        }
        if (!pathValid) {
            ctx.printLine("Type '" + typeName + "' not found amoung child types of '" + ctx.getPrefixFormatter().format(typeAddress) + "'");
            return false;
        }
        address.add(typeName, "?");
        request.get("operation").set("read-resource-description");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            ctx.printLine(e.getLocalizedMessage());
            return false;
        }
        if (!result.hasDefined("result")) {
            ctx.printLine("Failed to validate input: operation response doesn't contain result info.");
            return false;
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            ctx.printLine("Failed to validate input: description of attributes is missing for " + typePath);
            return false;
        }
        for (Property prop : result.get("attributes").asPropertyList()) {
            if (!prop.getName().equals(propertyName)) continue;
            ModelNode value = prop.getValue();
            if (value.has("access-type") && "read-only".equals(value.get("access-type").asString())) {
                return true;
            }
            ctx.printLine("Property " + propertyName + " is not read-only.");
            return false;
        }
        ctx.printLine("Property '" + propertyName + "' wasn't found among the properties of " + typePath);
        return false;
    }
}

