/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class GenericTypeOperationHandler
extends BatchModeCommandHandler {
    protected final String commandName;
    protected final String type;
    protected final String idProperty;
    protected final OperationRequestAddress nodePath;
    protected final ArgumentWithValue profile;
    protected final ArgumentWithValue name;
    protected final ArgumentWithValue operation;
    protected final List<String> excludeOps;
    protected final ArgumentWithoutValue helpProperties;
    protected final ArgumentWithoutValue helpCommands;
    private final List<CommandArgument> staticArgs = new ArrayList<CommandArgument>();
    private List<CommandArgument> nodeProps;
    private Map<String, List<CommandArgument>> propsByOp;

    public GenericTypeOperationHandler(String nodeType, String idProperty) {
        this(nodeType, idProperty, Arrays.asList("read-attribute", "read-children-names", "read-children-resources", "read-children-types", "read-operation-description", "read-operation-names", "read-resource", "read-resource-description", "validate-address", "write-attribute"));
    }

    public GenericTypeOperationHandler(String nodeType, String idProperty, List<String> excludeOperations) {
        super("generic-type-operation", true);
        this.helpArg = new ArgumentWithoutValue(this, "--help", "-h"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.nodePath = new DefaultOperationRequestAddress();
        DefaultCallbackHandler handler = new DefaultCallbackHandler(this.nodePath);
        try {
            ParserUtil.parseOperationRequest(nodeType, handler);
        }
        catch (CommandFormatException e) {
            throw new IllegalArgumentException("Failed to parse nodeType: " + e.getMessage());
        }
        if (!this.nodePath.endsOnType()) {
            throw new IllegalArgumentException("The node path doesn't end on a type: '" + nodeType + "'");
        }
        this.type = this.nodePath.getNodeType();
        this.nodePath.toParentNode();
        this.addRequiredPath(this.nodePath);
        this.commandName = this.type;
        this.idProperty = idProperty;
        this.excludeOps = excludeOperations;
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (profileName == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.nodePath) {
                    address.toNode(node.getType(), node.getName());
                }
                address.toNode(GenericTypeOperationHandler.this.type, "?");
                List<String> ops = ctx.getOperationCandidatesProvider().getOperationNames(ctx, address);
                ops.removeAll(GenericTypeOperationHandler.this.excludeOps);
                return ops;
            }
        }), 0, "--operation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation.addCantAppearAfter(this.helpArg);
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public List<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (GenericTypeOperationHandler.this.profile == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.nodePath) {
                    address.toNode(node.getType(), node.getName());
                }
                return Util.getNodeNames(ctx.getModelControllerClient(), address, GenericTypeOperationHandler.this.type);
            }
        }), "--" + idProperty){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name.addCantAppearAfter(this.helpArg);
        this.helpArg.addCantAppearAfter(this.name);
        this.helpProperties = new ArgumentWithoutValue(this, "--properties");
        this.helpProperties.addRequiredPreceding(this.helpArg);
        this.helpProperties.addCantAppearAfter(this.operation);
        this.helpCommands = new ArgumentWithoutValue(this, "--commands");
        this.helpCommands.addRequiredPreceding(this.helpArg);
        this.helpCommands.addCantAppearAfter(this.operation);
        this.helpCommands.addCantAppearAfter(this.helpProperties);
        this.helpProperties.addCantAppearAfter(this.helpCommands);
        this.staticArgs.add(this.helpArg);
        this.staticArgs.add(this.helpCommands);
        this.staticArgs.add(this.helpProperties);
        this.staticArgs.add(this.profile);
        this.staticArgs.add(this.name);
        this.staticArgs.add(this.operation);
    }

    @Override
    public List<CommandArgument> getArguments(CommandContext ctx) {
        List<CommandArgument> opProps;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs;
            }
        }
        catch (CommandFormatException e) {
            return Collections.emptyList();
        }
        String op = this.operation.getValue(args);
        if (op == null) {
            if (this.nodeProps == null) {
                this.nodeProps = new ArrayList<CommandArgument>();
                for (Property prop : this.getNodeProperties(ctx)) {
                    ModelNode propDescr = prop.getValue();
                    if (!propDescr.has("access-type") || !"read-write".equals(propDescr.get("access-type").asString())) continue;
                    if (propDescr.has("type") && ModelType.BOOLEAN == propDescr.get("type").asType()) {
                        this.nodeProps.add(new ArgumentWithValue((CommandHandlerWithArguments)this, SimpleTabCompleter.BOOLEAN, "--" + prop.getName()));
                        continue;
                    }
                    this.nodeProps.add(new ArgumentWithValue(this, "--" + prop.getName()));
                }
            }
            return this.nodeProps;
        }
        if (this.propsByOp == null) {
            this.propsByOp = new HashMap<String, List<CommandArgument>>();
        }
        if ((opProps = this.propsByOp.get(op)) == null) {
            ModelNode descr;
            try {
                descr = this.getOperationDescription(ctx, op);
            }
            catch (IOException e1) {
                return Collections.emptyList();
            }
            if (descr == null || !descr.has("request-properties")) {
                opProps = Collections.emptyList();
            } else {
                opProps = new ArrayList<CommandArgument>();
                for (Property prop : descr.get("request-properties").asPropertyList()) {
                    ModelNode propDescr = prop.getValue();
                    if (propDescr.has("type") && ModelType.BOOLEAN == propDescr.get("type").asType()) {
                        opProps.add(new ArgumentWithValue((CommandHandlerWithArguments)this, SimpleTabCompleter.BOOLEAN, "--" + prop.getName()));
                        continue;
                    }
                    opProps.add(new ArgumentWithValue(this, "--" + prop.getName()));
                }
            }
            this.propsByOp.put(op, opProps);
        }
        return opProps;
    }

    @Override
    public boolean hasArgument(String name) {
        return true;
    }

    @Override
    public boolean hasArgument(int index) {
        return true;
    }

    @Override
    public void addArgument(CommandArgument arg) {
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        String operation = this.operation.getValue(ctx.getParsedCommandLine());
        if (operation == null) {
            return this.buildWritePropertyRequest(ctx);
        }
        return this.buildOperationRequest(ctx, operation);
    }

    protected ModelNode buildWritePropertyRequest(CommandContext ctx) throws CommandFormatException {
        String profile;
        String name = this.name.getValue(ctx.getParsedCommandLine(), true);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.isDomainMode()) {
            profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
        } else {
            profile = null;
        }
        for (String argName : args.getPropertyNames()) {
            String valueString;
            if (argName.equals("--profile") || this.name.getFullName().equals(argName) || (valueString = args.getPropertyValue(argName)) == null) continue;
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
            if (profile != null) {
                builder.addNode("profile", profile);
            }
            for (OperationRequestAddress.Node node : this.nodePath) {
                builder.addNode(node.getType(), node.getName());
            }
            builder.addNode(this.type, name);
            builder.setOperationName("write-attribute");
            argName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
            builder.addProperty("name", argName);
            if (argName.endsWith("properties")) {
                String[] props;
                ModelNode nodeValue = new ModelNode();
                for (String prop : props = valueString.split(",")) {
                    int equals = prop.indexOf(61);
                    if (equals == -1) {
                        throw new CommandFormatException("Property '" + prop + "' in '" + valueString + "' is missing the equals sign.");
                    }
                    String propName = prop.substring(0, equals);
                    if (propName.isEmpty()) {
                        throw new CommandFormatException("Property name is missing for '" + prop + "' in '" + valueString + "'");
                    }
                    nodeValue.add(propName, prop.substring(equals + 1));
                }
                builder.getModelNode().get("value").set(nodeValue);
            } else {
                builder.addProperty("value", valueString);
            }
            steps.add(builder.buildRequest());
        }
        return composite;
    }

    protected ModelNode buildOperationRequest(CommandContext ctx, String operation) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            builder.addNode("profile", profile);
        }
        String name = this.name.getValue(ctx.getParsedCommandLine(), true);
        for (OperationRequestAddress.Node node : this.nodePath) {
            builder.addNode(node.getType(), node.getName());
        }
        builder.addNode(this.type, name);
        builder.setOperationName(operation);
        for (String argName : args.getPropertyNames()) {
            String valueString;
            if (argName.equals("--profile") || (valueString = args.getPropertyValue(argName)) == null) continue;
            if ((argName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1)).endsWith("properties")) {
                String[] props;
                ModelNode nodeValue = new ModelNode();
                for (String prop : props = valueString.split(",")) {
                    int equals = prop.indexOf(61);
                    if (equals == -1) {
                        throw new CommandFormatException("Property '" + prop + "' in '" + valueString + "' is missing the equals sign.");
                    }
                    String propName = prop.substring(0, equals);
                    if (propName.isEmpty()) {
                        throw new CommandFormatException("Property name is missing for '" + prop + "' in '" + valueString + "'");
                    }
                    nodeValue.add(propName, prop.substring(equals + 1));
                }
                builder.getModelNode().get(argName).set(nodeValue);
                continue;
            }
            builder.addProperty(argName, valueString);
        }
        return builder.buildRequest();
    }

    @Override
    protected void printHelp(CommandContext ctx) {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (this.helpProperties.isPresent(args)) {
                this.printAttributes(ctx);
                return;
            }
        }
        catch (CommandFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
            return;
        }
        try {
            if (this.helpCommands.isPresent(args)) {
                this.printCommands(ctx);
                return;
            }
        }
        catch (CommandFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
            return;
        }
        String operationName = this.operation.getValue(args);
        if (operationName == null) {
            this.printNodeDescription(ctx);
            return;
        }
        try {
            ModelNode result = this.getOperationDescription(ctx, operationName);
            if (!result.hasDefined("description")) {
                ctx.printLine("Operation description is not available.");
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Operation description:\n\n\t");
            buf.append(result.get("description").asString());
            buf.append("\n\nProperties:");
            ctx.printLine(buf.toString());
            boolean idPropListed = false;
            if (result.has("request-properties")) {
                result = result.get("request-properties");
                for (Property attr : result.asPropertyList()) {
                    ModelNode value;
                    if (!idPropListed) {
                        idPropListed = this.idProperty.equals(attr.getName());
                    }
                    boolean required = (value = attr.getValue()).has("required") ? value.get("required").asBoolean() : false;
                    String type = value.has("type") ? value.get("type").asString() : "no type info";
                    StringBuilder descr = new StringBuilder();
                    descr.append("\n --");
                    descr.append(attr.getName());
                    int length = descr.length();
                    int newLength = Math.max(24, (length + 4) / 4 * 4);
                    descr.setLength(newLength);
                    for (int i = length; i < newLength; ++i) {
                        descr.setCharAt(i, ' ');
                    }
                    descr.append("- ");
                    if (value.has("description")) {
                        descr.append('(');
                        descr.append(type).append(',');
                        if (required) {
                            descr.append("required");
                        } else {
                            descr.append("optional");
                        }
                        descr.append(") ");
                        descr.append(value.get("description").asString());
                    } else {
                        descr.append("no description");
                    }
                    ctx.printLine(descr.toString());
                }
            }
            if (!idPropListed) {
                StringBuilder descr = new StringBuilder();
                descr.append("\n --");
                descr.append(this.idProperty);
                int length = descr.length();
                int newLength = Math.max(24, (length + 4) / 4 * 4);
                descr.setLength(newLength);
                for (int i = length; i < newLength; ++i) {
                    descr.setCharAt(i, ' ');
                }
                descr.append("- identifies the instance to perform the operation on.");
                ctx.printLine(descr.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void printNodeDescription(CommandContext ctx) {
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return;
        }
        request.get("operation").set("read-resource-description");
        try {
            ModelNode result = ctx.getModelControllerClient().execute(request);
            if (!result.hasDefined("result")) {
                ctx.printLine("Node description is not available.");
                return;
            }
            if (!(result = result.get("result")).hasDefined("description")) {
                ctx.printLine("Node description is not available.");
                return;
            }
            ctx.printLine(result.get("description").asString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void printAttributes(CommandContext ctx) {
        List<Property> props;
        try {
            props = this.getNodeProperties(ctx);
        }
        catch (Exception e) {
            ctx.printLine("Failed to obtain the list or properties: " + e.getLocalizedMessage());
            return;
        }
        for (Property attr : props) {
            ModelNode value = attr.getValue();
            if (value.has("access-type") && "metric".equals(value.get("access-type").asString())) continue;
            boolean required = value.has("required") ? value.get("required").asBoolean() : false;
            StringBuilder descr = new StringBuilder();
            descr.append("\n ");
            descr.append(attr.getName());
            int length = descr.length();
            int newLength = Math.max(24, (length + 4) / 4 * 4);
            descr.setLength(newLength);
            for (int i = length; i < newLength; ++i) {
                descr.setCharAt(i, ' ');
            }
            descr.append("- ");
            if (value.has("description")) {
                descr.append('(');
                if (required) {
                    descr.append("required");
                } else {
                    descr.append("optional");
                }
                descr.append(") ");
                descr.append(value.get("description").asString());
            } else {
                descr.append("no description");
            }
            ctx.printLine(descr.toString());
        }
    }

    protected void printCommands(CommandContext ctx) {
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return;
        }
        request.get("operation").set("read-operation-names");
        try {
            ModelNode result = ctx.getModelControllerClient().execute(request);
            if (!result.hasDefined("result")) {
                ctx.printLine("Operation names aren't available.");
                return;
            }
            List<String> list = Util.getList(result);
            list.removeAll(this.excludeOps);
            list.add("To read the description of a specific command execute '" + this.commandName + " command_name --help'.");
            for (String name : list) {
                ctx.printLine(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<Property> getNodeProperties(CommandContext ctx) {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return Collections.emptyList();
        }
        request.get("operation").set("read-resource-description");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (!result.hasDefined("result")) {
            return Collections.emptyList();
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            return Collections.emptyList();
        }
        return result.get("attributes").asPropertyList();
    }

    protected ModelNode getOperationDescription(CommandContext ctx, String operationName) throws IOException {
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return null;
        }
        request.get("operation").set("read-operation-description");
        request.get("name").set(operationName);
        ModelNode result = ctx.getModelControllerClient().execute(request);
        if (!result.hasDefined("result")) {
            return null;
        }
        return result.get("result");
    }

    protected ModelNode initRequest(CommandContext ctx) {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (ctx.isDomainMode()) {
            String profileName = this.profile.getValue(ctx.getParsedCommandLine());
            if (this.profile == null) {
                ctx.printLine("--profile argument is required to get the node description.");
                return null;
            }
            address.add("profile", profileName);
        }
        for (OperationRequestAddress.Node node : this.nodePath) {
            address.add(node.getType(), node.getName());
        }
        address.add(this.type, "?");
        return request;
    }
}

