/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.CharacterHandlerMap;
import org.jboss.as.cli.parsing.DefaultStateWithEndCharacter;
import org.jboss.as.cli.parsing.EnterStateCharacterHandler;
import org.jboss.as.cli.parsing.EscapeCharacterState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingState;
import org.jboss.as.cli.parsing.QuotesState;

public class GlobalCharacterHandlers {
    private static final Map<Character, CharacterHandler> handlers = new HashMap<Character, CharacterHandler>();
    static final CharacterHandlerMap GLOBAL_ENTER_STATE_HANDLERS = new CharacterHandlerMap(){

        @Override
        public CharacterHandler getHandler(char ch) {
            return GlobalCharacterHandlers.getHandler(ch, null);
        }

        @Override
        public void putHandler(char ch, CharacterHandler handler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeHandler(char ch) {
            throw new UnsupportedOperationException();
        }
    };
    static final CharacterHandler NOOP_CHARACTER_HANDLER = new CharacterHandler(){

        @Override
        public void handle(ParsingContext ctx) throws OperationFormatException {
        }
    };
    public static final CharacterHandler CONTENT_CHARACTER_HANDLER = new CharacterHandler(){

        @Override
        public void handle(ParsingContext ctx) throws CommandFormatException {
            ctx.getCallbackHandler().character(ctx);
        }
    };
    public static final CharacterHandler LEAVE_STATE_HANDLER = new CharacterHandler(){

        @Override
        public void handle(ParsingContext ctx) throws CommandFormatException {
            ctx.leaveState();
        }
    };

    static CharacterHandler getHandler(char ch, CharacterHandler defaultHandler) {
        CharacterHandler handler = handlers.get(Character.valueOf(ch));
        if (handler == null) {
            return defaultHandler;
        }
        return handler;
    }

    static CharacterHandler getHandler(char ch) {
        return GlobalCharacterHandlers.getHandler(ch, CONTENT_CHARACTER_HANDLER);
    }

    private static void addHandler(String id, char start, char end) {
        GlobalCharacterHandlers.addHandler(start, new DefaultStateWithEndCharacter(id, end, true, false, GLOBAL_ENTER_STATE_HANDLERS));
    }

    private static void addHandler(char start, ParsingState state) {
        handlers.put(Character.valueOf(start), new EnterStateCharacterHandler(state));
    }

    static {
        GlobalCharacterHandlers.addHandler("STRING_IN_PARANTHESIS", '(', ')');
        GlobalCharacterHandlers.addHandler("STRING_IN_BRACKETS", '[', ']');
        GlobalCharacterHandlers.addHandler("STRING_IN_BRACES", '{', '}');
        GlobalCharacterHandlers.addHandler('\\', EscapeCharacterState.INSTANCE);
        GlobalCharacterHandlers.addHandler('\"', QuotesState.QUOTES_EXCLUDED);
    }
}

