/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LsHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue nodePath;
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l");

    public LsHandler() {
        this("ls");
    }

    public LsHandler(String command) {
        super(command, true);
        this.nodePath = new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, 0, "--node-path");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestAddress address;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String nodePath = this.nodePath.getValue(parsedCmd);
        if (nodePath != null) {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
            DefaultCallbackHandler handler = new DefaultCallbackHandler(address);
            nodePath = ctx.getArgumentsString();
            if (this.l.isPresent(parsedCmd)) {
                nodePath = (nodePath = nodePath.trim()).startsWith("-l ") ? nodePath.substring(3) : nodePath.substring(0, nodePath.length() - 3);
            }
            try {
                ctx.getCommandLineParser().parse(nodePath, handler);
            }
            catch (CommandFormatException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        } else {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
        }
        List<String> names = null;
        if (address.endsOnType()) {
            String type = address.getNodeType();
            address.toParentNode();
            names = Util.getNodeNames(ctx.getModelControllerClient(), address, type);
        } else {
            OperationRequestAddress.Node node;
            Iterator iterator;
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            ModelNode typesRequest = new ModelNode();
            typesRequest.get("operation").set("read-children-types");
            ModelNode addressNode = typesRequest.get("address");
            if (address.isEmpty()) {
                addressNode.setEmptyList();
            } else {
                iterator = address.iterator();
                while (iterator.hasNext()) {
                    node = (OperationRequestAddress.Node)iterator.next();
                    if (node.getName() != null) {
                        addressNode.add(node.getType(), node.getName());
                        continue;
                    }
                    if (!iterator.hasNext()) continue;
                    throw new OperationFormatException("Expected a node name for type '" + node.getType() + "' in path '" + ctx.getPrefixFormatter().format(address) + "'");
                }
            }
            steps.add(typesRequest);
            ModelNode resourceRequest = new ModelNode();
            resourceRequest.get("operation").set("read-resource");
            addressNode = resourceRequest.get("address");
            if (address.isEmpty()) {
                addressNode.setEmptyList();
            } else {
                iterator = address.iterator();
                while (iterator.hasNext()) {
                    node = (OperationRequestAddress.Node)iterator.next();
                    if (node.getName() != null) {
                        addressNode.add(node.getType(), node.getName());
                        continue;
                    }
                    if (!iterator.hasNext()) continue;
                    throw new OperationFormatException("Expected a node name for type '" + node.getType() + "' in path '" + ctx.getPrefixFormatter().format(address) + "'");
                }
            }
            resourceRequest.get("include-runtime").set("true");
            steps.add(resourceRequest);
            if (this.l.isPresent(parsedCmd)) {
                ModelNode request = new ModelNode();
                request.get("operation").set("read-resource-description");
                addressNode = request.get("address");
                if (address.isEmpty()) {
                    addressNode.setEmptyList();
                } else {
                    iterator = address.iterator();
                    while (iterator.hasNext()) {
                        node = (OperationRequestAddress.Node)iterator.next();
                        if (node.getName() != null) {
                            addressNode.add(node.getType(), node.getName());
                            continue;
                        }
                        if (!iterator.hasNext()) continue;
                        throw new OperationFormatException("Expected a node name for type '" + node.getType() + "' in path '" + ctx.getPrefixFormatter().format(address) + "'");
                    }
                }
                steps.add(request);
            }
            try {
                ModelNode outcome = ctx.getModelControllerClient().execute(composite);
                if (Util.isSuccess(outcome)) {
                    if (outcome.hasDefined("result")) {
                        ModelNode resourceResult;
                        ModelNode resultNode = outcome.get("result");
                        ModelNode attrDescriptions = null;
                        ModelNode childDescriptions = null;
                        if (resultNode.hasDefined("step-3")) {
                            ModelNode stepOutcome = resultNode.get("step-3");
                            if (Util.isSuccess(stepOutcome)) {
                                if (stepOutcome.hasDefined("result")) {
                                    ModelNode descrResult = stepOutcome.get("result");
                                    if (descrResult.hasDefined("attributes")) {
                                        attrDescriptions = descrResult.get("attributes");
                                    }
                                    if (descrResult.hasDefined("children")) {
                                        childDescriptions = descrResult.get("children");
                                    }
                                } else {
                                    ctx.printLine("Result is not available for read-resource-description request: " + outcome);
                                }
                            } else {
                                ctx.printLine("Failed to get resource description: " + outcome);
                            }
                        }
                        ArrayList<String> typeNames = null;
                        if (resultNode.hasDefined("step-1")) {
                            ModelNode typesOutcome = resultNode.get("step-1");
                            if (Util.isSuccess(typesOutcome)) {
                                if (typesOutcome.hasDefined("result")) {
                                    resourceResult = typesOutcome.get("result");
                                    List types = resourceResult.asList();
                                    if (!types.isEmpty()) {
                                        typeNames = new ArrayList<String>();
                                        for (ModelNode type : types) {
                                            typeNames.add(type.asString());
                                        }
                                        if (childDescriptions == null && attrDescriptions == null) {
                                            names = typeNames;
                                        }
                                    }
                                } else {
                                    ctx.printLine("Result is not available for read-children-types request: " + outcome);
                                }
                            } else {
                                ctx.printLine("Failed to fetch type names: " + outcome);
                            }
                        } else {
                            ctx.printLine("The result for children type names is not available: " + outcome);
                        }
                        if (resultNode.hasDefined("step-2")) {
                            ModelNode resourceOutcome = resultNode.get("step-2");
                            if (Util.isSuccess(resourceOutcome)) {
                                if (resourceOutcome.hasDefined("result")) {
                                    resourceResult = resourceOutcome.get("result");
                                    List props = resourceResult.asPropertyList();
                                    if (!props.isEmpty()) {
                                        StrictSizeTable childrenTable;
                                        StrictSizeTable attrTable = attrDescriptions == null ? null : new StrictSizeTable(attrDescriptions.keys().size());
                                        StrictSizeTable strictSizeTable = childrenTable = childDescriptions == null ? null : new StrictSizeTable(childDescriptions.keys().size());
                                        if (typeNames == null && attrTable == null && childrenTable == null) {
                                            typeNames = new ArrayList();
                                        }
                                        for (Property prop : props) {
                                            StringBuilder buf = new StringBuilder();
                                            if (typeNames == null || !typeNames.contains(prop.getName())) {
                                                if (attrDescriptions == null) {
                                                    buf.append(prop.getName());
                                                    buf.append('=');
                                                    buf.append(prop.getValue().asString());
                                                    typeNames.add(buf.toString());
                                                    buf.setLength(0);
                                                    continue;
                                                }
                                                if (attrDescriptions.hasDefined(prop.getName())) {
                                                    ModelNode attrDescr = attrDescriptions.get(prop.getName());
                                                    attrTable.addCell("ATTRIBUTE", prop.getName());
                                                    attrTable.addCell("value", prop.getValue().asString());
                                                    for (String name : attrDescr.keys()) {
                                                        if ("description".equals(name) || "head-comment-allowed".equals(name) || "tail-comment-allowed".equals(name)) continue;
                                                        attrTable.addCell(name, attrDescr.get(name).asString());
                                                    }
                                                } else {
                                                    attrTable.addCell("ATTRIBUTE", prop.getName());
                                                    attrTable.addCell("value", prop.getValue().asString());
                                                }
                                                if (attrTable.isAtLastRow()) continue;
                                                attrTable.nextRow();
                                                continue;
                                            }
                                            if (childDescriptions == null) continue;
                                            if (childDescriptions.hasDefined(prop.getName())) {
                                                ModelNode childDescr = childDescriptions.get(prop.getName());
                                                childrenTable.addCell("CHILD", prop.getName());
                                                for (String name : childDescr.keys()) {
                                                    if ("description".equals(name) || "head-comment-allowed".equals(name) || "tail-comment-allowed".equals(name)) continue;
                                                    childrenTable.addCell(name, childDescr.get(name).asString());
                                                }
                                            } else {
                                                childrenTable.addCell("CHILD", prop.getName());
                                            }
                                            if (childrenTable.isAtLastRow()) continue;
                                            childrenTable.nextRow();
                                        }
                                        if (childrenTable != null && !childrenTable.isEmpty()) {
                                            ctx.printLine(childrenTable.toString());
                                        }
                                        if (attrTable != null && !attrTable.isEmpty()) {
                                            ctx.printLine(attrTable.toString());
                                        }
                                    }
                                } else {
                                    ctx.printLine("Result is not available for read-resource request: " + outcome);
                                }
                            } else {
                                ctx.printLine("Failed to fetch attributes: " + outcome);
                            }
                        } else {
                            ctx.printLine("The result for attributes is not available: " + outcome);
                        }
                    }
                } else {
                    ctx.printLine("Failed to fetch the list of children: " + outcome);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (names != null) {
            this.printList(ctx, names, this.l.isPresent(parsedCmd));
        }
    }

    protected String getAsString(ModelNode attrDescr, String name) {
        if (attrDescr == null) {
            return "n/a";
        }
        return attrDescr.has(name) ? attrDescr.get(name).asString() : "n/a";
    }

    public static void main(String[] args) throws Exception {
        SimpleTable t = new SimpleTable(new String[]{"NAME", "TYPE", "REQUIRED", "ACCESS-TYPE", "VALUE"});
        t.addLine(new String[]{"name1", "big_integer", "true", "read-write", "12"});
        t.addLine(new String[]{"some name", "int", "false", "read-only", null});
        System.out.println(t.toString());
    }
}

