/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl.SecurityActions;
import org.jboss.as.protocol.StreamUtils;

public class CliLauncher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            CommandContextImpl cmdCtx;
            String argError = null;
            String[] commands = null;
            File file = null;
            boolean connect = false;
            String defaultControllerHost = null;
            int defaultControllerPort = -1;
            boolean version = false;
            String username = null;
            char[] password = null;
            for (String arg : args) {
                String value;
                if (arg.startsWith("--controller=") || arg.startsWith("controller=")) {
                    value = arg.startsWith("--") ? arg.substring(13) : arg.substring(11);
                    String portStr = null;
                    int colonIndex = value.indexOf(58);
                    if (colonIndex < 0) {
                        defaultControllerHost = value;
                    } else if (colonIndex == 0) {
                        portStr = value.substring(1);
                    } else {
                        defaultControllerHost = value.substring(0, colonIndex);
                        portStr = value.substring(colonIndex + 1);
                    }
                    if (portStr == null) continue;
                    int port = -1;
                    try {
                        port = Integer.parseInt(portStr);
                        if (port < 0) {
                            argError = "The port must be a valid non-negative integer: '" + args + "'";
                            continue;
                        }
                        defaultControllerPort = port;
                    }
                    catch (NumberFormatException e) {
                        argError = "The port must be a valid non-negative integer: '" + arg + "'";
                    }
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if (arg.startsWith("--file=") || arg.startsWith("file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument '--file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(fileName);
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument '--file' is missing value.";
                    break;
                }
                if (arg.startsWith("--commands=") || arg.startsWith("commands=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = value.split(",+");
                    continue;
                }
                if (arg.startsWith("--command=") || arg.startsWith("command=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                    commands = new String[]{value};
                    continue;
                }
                if (arg.startsWith("--user=")) {
                    username = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    continue;
                }
                if (arg.startsWith("--password=")) {
                    password = (arg.startsWith("--") ? arg.substring(11) : arg.substring(9)).toCharArray();
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-h")) {
                    commands = new String[]{"help"};
                    continue;
                }
                if (file != null) {
                    argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                    break;
                }
                if (commands != null) {
                    argError = "Duplicate argument '--command'/'--commands'.";
                    break;
                }
                commands = arg.split(",+");
            }
            if (argError != null) {
                System.err.println(argError);
                return;
            }
            if (version) {
                cmdCtx = new CommandContextImpl();
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                CliLauncher.processFile(file, defaultControllerHost, defaultControllerPort, connect, username, password);
                return;
            }
            if (commands != null) {
                CliLauncher.processCommands(commands, defaultControllerHost, defaultControllerPort, connect, username, password);
                return;
            }
            cmdCtx = new CommandContextImpl(defaultControllerHost, defaultControllerPort, username, password, true);
            cmdCtx.interact(connect);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            System.exit(0);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(String[] commands, String defaultControllerHost, int defaultControllerPort, boolean connect, String username, char[] password) throws CliInitializationException {
        final CommandContextImpl cmdCtx = new CommandContextImpl(defaultControllerHost, defaultControllerPort, username, password, false);
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController();
            }
        }));
        if (connect) {
            cmdCtx.connectController(null, -1);
        }
        try {
            for (int i = 0; i < commands.length && !cmdCtx.isTerminated(); ++i) {
                cmdCtx.processLine(commands[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (!cmdCtx.isTerminated()) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(File file, String defaultControllerHost, int defaultControllerPort, boolean connect, String username, char[] password) throws CliInitializationException {
        final CommandContextImpl cmdCtx = new CommandContextImpl(defaultControllerHost, defaultControllerPort, username, password, false);
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController();
            }
        }));
        if (connect) {
            cmdCtx.connectController(null, -1);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (!cmdCtx.isTerminated() && line != null) {
                cmdCtx.processLine(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                cmdCtx.printLine("Failed to process file '" + file.getAbsolutePath() + "'");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                if (!cmdCtx.isTerminated()) {
                    cmdCtx.terminateSession();
                }
                cmdCtx.disconnectController();
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)reader);
            if (!cmdCtx.isTerminated()) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController();
        }
        StreamUtils.safeClose((Closeable)reader);
        if (!cmdCtx.isTerminated()) {
            cmdCtx.terminateSession();
        }
        cmdCtx.disconnectController();
    }
}

