/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.impl.CommandCandidatesProvider;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;

public class CommandCompleter
implements CommandLineCompleter {
    private final CommandRegistry cmdRegistry;
    private final CommandCandidatesProvider cmdProvider;

    public CommandCompleter(CommandRegistry cmdRegistry) {
        if (cmdRegistry == null) {
            throw new IllegalArgumentException("Command registry can't be null.");
        }
        this.cmdRegistry = cmdRegistry;
        this.cmdProvider = new CommandCandidatesProvider(cmdRegistry);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        DefaultCallbackHandler parsedCmd;
        block6: {
            if (buffer.isEmpty()) {
                for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
                    CommandHandler handler = this.cmdRegistry.getCommandHandler(cmd);
                    if (!handler.isAvailable(ctx)) continue;
                    candidates.add(cmd);
                }
                Collections.sort(candidates);
                return 0;
            }
            parsedCmd = (DefaultCallbackHandler)ctx.getParsedCommandLine();
            try {
                parsedCmd.parse(ctx.getPrefix(), buffer, false);
            }
            catch (CommandFormatException e) {
                if (parsedCmd.endsOnAddressOperationNameSeparator() && parsedCmd.endsOnSeparator()) break block6;
                return -1;
            }
        }
        OperationCandidatesProvider candidatesProvider = this.cmdProvider;
        if (!buffer.isEmpty()) {
            int cmdFirstIndex = 0;
            while (cmdFirstIndex < buffer.length()) {
                char ch;
                if (Character.isWhitespace(ch = buffer.charAt(cmdFirstIndex++))) continue;
                if (ch != '.' && ch != ':' && ch != '/') break;
                candidatesProvider = ctx.getOperationCandidatesProvider();
                break;
            }
        }
        return OperationRequestCompleter.INSTANCE.complete(ctx, parsedCmd, candidatesProvider, buffer, cursor, candidates);
    }
}

