/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.Locale;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaultsService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanDescriptions;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class InfinispanSubsystemAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        InfinispanSubsystemAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-cache-container").set(source.require("default-cache-container"));
        target.get("cache-container").setEmptyObject();
    }

    public ModelNode getModelDescription(Locale locale) {
        return InfinispanDescriptions.getSubsystemAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        InfinispanSubsystemAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        InfinispanLogger.ROOT_LOGGER.activatingSubsystem();
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(EmbeddedCacheManagerDefaultsService.SERVICE_NAME, (Service)new EmbeddedCacheManagerDefaultsService()).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
        String defaultContainer = operation.require("default-cache-container").asString();
        InjectedValue container = new InjectedValue();
        ValueService service = new ValueService((Value)container);
        newControllers.add(target.addService(EmbeddedCacheManagerService.getServiceName(null), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName(defaultContainer), EmbeddedCacheManager.class, (Injector)container).setInitialMode(ServiceController.Mode.ON_DEMAND).install());
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

