/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.loaders.AbstractCacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.loaders.jdbc.AbstractJdbcCacheStoreConfig;
import org.infinispan.loaders.jdbc.TableManipulation;
import org.infinispan.loaders.jdbc.binary.JdbcBinaryCacheStoreConfig;
import org.infinispan.loaders.jdbc.connectionfactory.ManagedConnectionFactory;
import org.infinispan.loaders.jdbc.mixed.JdbcMixedCacheStoreConfig;
import org.infinispan.loaders.jdbc.stringbased.JdbcStringBasedCacheStoreConfig;
import org.infinispan.loaders.remote.RemoteCacheStoreConfig;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaultsService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.FileCacheStoreConfig;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public abstract class CacheAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String cacheName = cacheAddress.getLastElement().getValue();
        model.get("name").set(cacheName);
        this.populateCacheMode(operation, model);
        this.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        Configuration overrides = new Configuration();
        LinkedList additionalDeps = new LinkedList();
        this.processModelNode(model, overrides, additionalDeps);
        PathAddress cacheAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ServiceName containerServiceName = EmbeddedCacheManagerService.getServiceName(containerName);
        ServiceName cacheServiceName = containerServiceName.append(new String[]{cacheName});
        ServiceName cacheConfigurationServiceName = CacheConfigurationService.getServiceName(containerName, cacheName);
        Resource rootResource = context.getRootResource();
        ModelNode container = rootResource.navigate(containerAddress).getModel();
        String defaultCache = container.require("default-cache").asString();
        StartMode startMode = model.hasDefined("start") ? StartMode.valueOf(model.get("start").asString()) : StartMode.LAZY;
        CacheConfigurationService.CacheConfigurationHelperImpl helper = new CacheConfigurationService.CacheConfigurationHelperImpl(cacheName);
        ServiceTarget target = context.getServiceTarget();
        CacheConfigurationService cacheConfigurationService = new CacheConfigurationService(cacheName, overrides, helper);
        ServiceBuilder configBuilder = target.addService(cacheConfigurationServiceName, (Service)cacheConfigurationService).addDependency(containerServiceName, EmbeddedCacheManager.class, helper.getCacheContainerInjector()).addDependency(EmbeddedCacheManagerDefaultsService.SERVICE_NAME, EmbeddedCacheManagerDefaults.class, helper.getDefaultsInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, helper.getTransactionManagerInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, helper.getTransactionSynchronizationRegistryInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        for (AdditionalDependency additionalDependency : additionalDeps) {
            this.addDependency(configBuilder, additionalDependency);
        }
        if (cacheName.equals(defaultCache)) {
            configBuilder.addAliases(new ServiceName[]{CacheConfigurationService.getServiceName(containerName, null)});
        }
        newControllers.add(configBuilder.install());
        log.debug((Object)("cache configuration service for " + cacheName + " installed for container " + containerName));
        CacheService cacheService = new CacheService(cacheName);
        ServiceBuilder serviceBuilder = target.addService(cacheServiceName, cacheService);
        serviceBuilder.addDependency(containerServiceName, CacheContainer.class, cacheService.getCacheContainerInjector());
        serviceBuilder.addDependency(cacheConfigurationServiceName);
        serviceBuilder.setInitialMode(startMode.getMode());
        if (overrides.getCacheMode().isClustered()) {
            ServiceName transportServiceName = EmbeddedCacheManagerService.getTransportServiceName(containerName);
            serviceBuilder.addDependency(transportServiceName);
            context.getServiceRegistry(true).getRequiredService(transportServiceName).setMode(ServiceController.Mode.ON_DEMAND);
        }
        if (cacheName.equals(defaultCache)) {
            serviceBuilder.addAliases(new ServiceName[]{CacheService.getServiceName(containerName, null)});
        }
        if (startMode.getMode() == ServiceController.Mode.ACTIVE) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        newControllers.add(serviceBuilder.install());
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
    }

    private <T> void addDependency(ServiceBuilder<?> builder, AdditionalDependency<T> dep) {
        if (dep.hasInjector()) {
            builder.addDependency(dep.getName(), dep.getType(), dep.getTarget());
        } else {
            builder.addDependency(dep.getName());
        }
    }

    abstract void populateCacheMode(ModelNode var1, ModelNode var2) throws OperationFailedException;

    void populate(ModelNode fromModel, ModelNode toModel) {
        if (fromModel.hasDefined("start")) {
            toModel.get("start").set(fromModel.get("start"));
        }
        if (fromModel.hasDefined("batching")) {
            toModel.get("batching").set(fromModel.get("batching"));
        }
        if (fromModel.hasDefined("indexing")) {
            toModel.get("indexing").set(fromModel.get("indexing"));
        }
        if (fromModel.hasDefined("store")) {
            toModel.get("store").set(fromModel.get("store"));
        }
        if (fromModel.hasDefined("file-store")) {
            toModel.get("file-store").set(fromModel.get("file-store"));
        }
        if (fromModel.hasDefined("jdbc-store")) {
            toModel.get("jdbc-store").set(fromModel.get("jdbc-store"));
        }
        if (fromModel.hasDefined("remote-store")) {
            toModel.get("remote-store").set(fromModel.get("remote-store"));
        }
    }

    void processModelNode(ModelNode cache, Configuration configuration, List<AdditionalDependency<?>> additionalDeps) {
        String storeKey;
        Indexing indexing;
        String cacheName = cache.require("name").asString();
        configuration.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        FluentConfiguration fluent = configuration.fluent();
        Configuration.CacheMode mode = Configuration.CacheMode.valueOf((String)cache.require("cache-mode").asString());
        fluent.mode(mode);
        if (cache.hasDefined("batching") && cache.get("batching").asBoolean()) {
            fluent.invocationBatching();
        }
        if (cache.hasDefined("indexing") && (indexing = Indexing.valueOf(cache.get("indexing").asString())).isEnabled()) {
            fluent.indexing().indexLocalOnly(Boolean.valueOf(indexing.isLocalOnly()));
        }
        if (cache.hasDefined("queue-size")) {
            fluent.async().replQueueMaxElements(Integer.valueOf(cache.get("queue-size").asInt()));
        }
        if (cache.hasDefined("queue-flush-interval")) {
            fluent.async().replQueueInterval(Long.valueOf(cache.get("queue-flush-interval").asLong()));
        }
        if (cache.hasDefined("remote-timeout")) {
            fluent.sync().replTimeout(Long.valueOf(cache.get("remote-timeout").asLong()));
        }
        if (cache.hasDefined("owners")) {
            fluent.hash().numOwners(Integer.valueOf(cache.get("owners").asInt()));
        }
        if (cache.hasDefined("virtual-nodes")) {
            fluent.hash().numVirtualNodes(Integer.valueOf(cache.get("virtual-nodes").asInt()));
        }
        if (cache.hasDefined("l1-lifespan")) {
            long lifespan = cache.get("l1-lifespan").asLong();
            if (lifespan > 0L) {
                fluent.l1().lifespan(Long.valueOf(lifespan));
            } else {
                fluent.l1().disable();
            }
        }
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "locking"}).isDefined()) {
            ModelNode locking = cache.get(new String[]{"singleton", "locking"});
            FluentConfiguration.LockingConfig fluentLocking = fluent.locking();
            if (locking.hasDefined("isolation")) {
                fluentLocking.isolationLevel(IsolationLevel.valueOf((String)locking.get("isolation").asString()));
            }
            if (locking.hasDefined("striping")) {
                fluentLocking.useLockStriping(Boolean.valueOf(locking.get("striping").asBoolean()));
            }
            if (locking.hasDefined("acquire-timeout")) {
                fluentLocking.lockAcquisitionTimeout(Long.valueOf(locking.get("acquire-timeout").asLong()));
            }
            if (locking.hasDefined("concurrency-level")) {
                fluentLocking.concurrencyLevel(Integer.valueOf(locking.get("concurrency-level").asInt()));
            }
        }
        FluentConfiguration.TransactionConfig fluentTx = fluent.transaction();
        TransactionMode txMode = TransactionMode.NON_XA;
        LockingMode lockingMode = LockingMode.OPTIMISTIC;
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "transaction"}).isDefined()) {
            ModelNode transaction = cache.get(new String[]{"singleton", "transaction"});
            if (transaction.hasDefined("stop-timeout")) {
                fluentTx.cacheStopTimeout(Integer.valueOf(transaction.get("stop-timeout").asInt()));
            }
            if (transaction.hasDefined("mode")) {
                txMode = TransactionMode.valueOf(transaction.get("mode").asString());
            }
            if (transaction.hasDefined("locking")) {
                lockingMode = LockingMode.valueOf((String)transaction.get("locking").asString());
            }
        }
        fluentTx.transactionMode(txMode.getMode());
        fluentTx.lockingMode(lockingMode);
        FluentConfiguration.RecoveryConfig recovery = fluentTx.useSynchronization(Boolean.valueOf(!txMode.isXAEnabled())).recovery();
        if (txMode.isRecoveryEnabled()) {
            recovery.syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(true));
        } else {
            recovery.disable();
        }
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "eviction"}).isDefined()) {
            ModelNode eviction = cache.get(new String[]{"singleton", "eviction"});
            FluentConfiguration.EvictionConfig fluentEviction = fluent.eviction();
            if (eviction.hasDefined("strategy")) {
                fluentEviction.strategy(EvictionStrategy.valueOf((String)eviction.get("strategy").asString()));
            }
            if (eviction.hasDefined("max-entries")) {
                fluentEviction.maxEntries(Integer.valueOf(eviction.get("max-entries").asInt()));
            }
        }
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "expiration"}).isDefined()) {
            ModelNode expiration = cache.get(new String[]{"singleton", "expiration"});
            FluentConfiguration.ExpirationConfig fluentExpiration = fluent.expiration();
            if (expiration.hasDefined("max-idle")) {
                fluentExpiration.maxIdle(Long.valueOf(expiration.get("max-idle").asLong()));
            }
            if (expiration.hasDefined("lifespan")) {
                fluentExpiration.lifespan(Long.valueOf(expiration.get("lifespan").asLong()));
            }
            if (expiration.hasDefined("interval")) {
                fluentExpiration.wakeUpInterval(Long.valueOf(expiration.get("interval").asLong()));
            }
        }
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "state-transfer"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"singleton", "state-transfer"});
            FluentConfiguration.StateRetrievalConfig fluentStateTransfer = fluent.stateRetrieval();
            if (stateTransfer.hasDefined("enabled")) {
                fluentStateTransfer.fetchInMemoryState(Boolean.valueOf(stateTransfer.get("enabled").asBoolean()));
            }
            if (stateTransfer.hasDefined("timeout")) {
                fluentStateTransfer.timeout(Long.valueOf(stateTransfer.get("timeout").asLong()));
            }
            if (stateTransfer.hasDefined("flush-timeout")) {
                fluentStateTransfer.logFlushTimeout(Long.valueOf(stateTransfer.get("flush-timeout").asLong()));
            }
        }
        if (cache.hasDefined("singleton") && cache.get(new String[]{"singleton", "rehashing"}).isDefined()) {
            ModelNode rehashing = cache.get(new String[]{"singleton", "rehashing"});
            FluentConfiguration.HashConfig fluentHash = fluent.hash();
            if (rehashing.hasDefined("enabled")) {
                fluentHash.rehashEnabled(Boolean.valueOf(rehashing.get("enabled").asBoolean()));
            }
            if (rehashing.hasDefined("timeout")) {
                fluentHash.rehashRpcTimeout(Long.valueOf(rehashing.get("timeout").asLong()));
            }
        }
        if ((storeKey = this.findStoreKey(cache)) != null) {
            ModelNode store = cache.get(storeKey);
            FluentConfiguration.LoadersConfig fluentStores = fluent.loaders();
            fluentStores.shared(Boolean.valueOf(store.hasDefined("shared") ? store.get("shared").asBoolean() : false));
            fluentStores.preload(Boolean.valueOf(store.hasDefined("preload") ? store.get("preload").asBoolean() : false));
            fluentStores.passivation(Boolean.valueOf(store.hasDefined("passivation") ? store.get("passivation").asBoolean() : true));
            CacheStoreConfig storeConfig = this.buildCacheStore(cacheName, store, storeKey, additionalDeps);
            storeConfig.singletonStore().enabled(Boolean.valueOf(store.hasDefined("singleton") ? store.get("singleton").asBoolean() : false));
            storeConfig.fetchPersistentState(Boolean.valueOf(store.hasDefined("fetch-state") ? store.get("fetch-state").asBoolean() : true));
            storeConfig.purgeOnStartup(Boolean.valueOf(store.hasDefined("purge") ? store.get("purge").asBoolean() : true));
            fluentStores.addCacheLoader(new CacheLoaderConfig[]{storeConfig});
        }
    }

    private String findStoreKey(ModelNode cache) {
        if (cache.hasDefined("store")) {
            return "store";
        }
        if (cache.hasDefined("file-store")) {
            return "file-store";
        }
        if (cache.hasDefined("jdbc-store")) {
            return "jdbc-store";
        }
        if (cache.hasDefined("remote-store")) {
            return "remote-store";
        }
        return null;
    }

    private CacheStoreConfig buildCacheStore(String name, ModelNode store, String storeKey, List<AdditionalDependency<?>> additionalDeps) {
        AdditionalDependency<String> dep;
        FileCacheStoreConfig storeConfig;
        Properties properties = new Properties();
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                String propertyName = property.getName();
                String propertyValue = property.getValue().asString();
                properties.setProperty(propertyName, propertyValue);
            }
        }
        if (storeKey.equals("file-store")) {
            storeConfig = new FileCacheStoreConfig();
            String relativeTo = store.hasDefined("relative-to") ? store.get("relative-to").asString() : "jboss.server.data.dir";
            dep = new AdditionalDependency<String>(AbstractPathService.pathNameOf((String)relativeTo), String.class, storeConfig.getRelativeToInjector());
            additionalDeps.add(dep);
            storeConfig.path(store.hasDefined("path") ? store.get("path").asString() : name);
            storeConfig.fsyncMode(FileCacheStoreConfig.FsyncMode.PER_WRITE);
            storeConfig.setProperties(properties);
            XmlConfigHelper.setValues((Object)((Object)storeConfig), (Map)properties, (boolean)false, (boolean)true);
            return storeConfig;
        }
        if (storeKey.equals("jdbc-store")) {
            storeConfig = this.buildJDBCStoreConfig(store);
            String datasource = store.require("datasource").asString();
            dep = new AdditionalDependency(ServiceName.JBOSS.append(new String[]{"data-source"}).append(new String[]{"reference-factory"}).append(new String[]{datasource}));
            additionalDeps.add(dep);
            storeConfig.setDatasourceJndiLocation(datasource);
            storeConfig.setConnectionFactoryClass(ManagedConnectionFactory.class.getName());
            storeConfig.setProperties(properties);
            XmlConfigHelper.setValues((Object)((Object)storeConfig), (Map)properties, (boolean)false, (boolean)true);
            return storeConfig;
        }
        if (storeKey.equals("remote-store")) {
            storeConfig = new RemoteCacheStoreConfig();
            for (ModelNode server : store.require("remote-server").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                AdditionalDependency<OutboundSocketBinding> dep2 = new AdditionalDependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, new Injector<OutboundSocketBinding>((RemoteCacheStoreConfig)storeConfig){
                    final /* synthetic */ RemoteCacheStoreConfig val$storeConfig;
                    {
                        this.val$storeConfig = remoteCacheStoreConfig;
                    }

                    public void inject(OutboundSocketBinding value) throws InjectionException {
                        String address;
                        try {
                            address = value.getDestinationAddress().getHostAddress() + ":" + Integer.toString(value.getDestinationPort());
                        }
                        catch (UnknownHostException uhe) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(uhe, value);
                        }
                        String serverList = this.val$storeConfig.getHotRodClientProperties().getProperty("infinispan.client.hotrod.server_list");
                        serverList = serverList == null ? address : serverList + ";" + address;
                        this.val$storeConfig.getHotRodClientProperties().setProperty("infinispan.client.hotrod.server_list", serverList);
                    }

                    public void uninject() {
                    }
                });
                additionalDeps.add(dep2);
            }
            if (store.hasDefined("cache")) {
                storeConfig.setRemoteCacheName(store.get("cache").asString());
            }
            if (store.hasDefined("socket-timeout")) {
                properties.setProperty("infinispan.client.hotrod.socket_timeout", store.require("socket-timeout").asString());
            }
            if (store.hasDefined("tcp-no-delay")) {
                properties.setProperty("infinispan.client.hotrod.tcp_no_delay", store.require("tcp-no-delay").asString());
            }
            storeConfig.setHotRodClientProperties(properties);
            return storeConfig;
        }
        String className = store.require("class").asString();
        try {
            CacheStore cacheStore = CacheStore.class.getClassLoader().loadClass(className).asSubclass(CacheStore.class).newInstance();
            CacheStoreConfig storeConfig2 = cacheStore.getConfigurationClass().asSubclass(CacheStoreConfig.class).newInstance();
            if (storeConfig2 instanceof AbstractCacheLoaderConfig) {
                ((AbstractCacheLoaderConfig)storeConfig2).setProperties(properties);
                XmlConfigHelper.setValues((Object)storeConfig2, (Map)properties, (boolean)false, (boolean)true);
            }
            return storeConfig2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("%s is not a valid cache store", className), e);
        }
    }

    private AbstractJdbcCacheStoreConfig buildJDBCStoreConfig(ModelNode store) {
        boolean useEntryTable = store.hasDefined("entry-table");
        boolean useBucketTable = store.hasDefined("bucket-table");
        if (useEntryTable && !useBucketTable) {
            JdbcStringBasedCacheStoreConfig storeConfig = new JdbcStringBasedCacheStoreConfig();
            storeConfig.setTableManipulation(this.buildEntryTableManipulation(store.get("entry-table")));
            return storeConfig;
        }
        if (useBucketTable && !useEntryTable) {
            JdbcBinaryCacheStoreConfig storeConfig = new JdbcBinaryCacheStoreConfig();
            storeConfig.setTableManipulation(this.buildBucketTableManipulation(store.get("bucket-table")));
            return storeConfig;
        }
        JdbcMixedCacheStoreConfig storeConfig = new JdbcMixedCacheStoreConfig();
        storeConfig.setStringsTableManipulation(this.buildEntryTableManipulation(store.get("entry-table")));
        storeConfig.setBinaryTableManipulation(this.buildBucketTableManipulation(store.get("bucket-table")));
        return storeConfig;
    }

    private TableManipulation buildBucketTableManipulation(ModelNode table) {
        return this.buildTableManipulation(table, "ispn_bucket");
    }

    private TableManipulation buildEntryTableManipulation(ModelNode table) {
        return this.buildTableManipulation(table, "ispn_entry");
    }

    private TableManipulation buildTableManipulation(ModelNode table, String defaultPrefix) {
        TableManipulation manipulation = new TableManipulation();
        manipulation.setBatchSize(table.isDefined() && table.hasDefined("batch-size") ? table.get("batch-size").asInt() : 100);
        manipulation.setFetchSize(table.isDefined() && table.hasDefined("fetch-size") ? table.get("fetch-size").asInt() : 100);
        manipulation.setTableNamePrefix(table.isDefined() && table.hasDefined("prefix") ? table.get("prefix").asString() : defaultPrefix);
        manipulation.setIdColumnName(this.getColumnProperty(table, "id-column", "name", "id"));
        manipulation.setIdColumnType(this.getColumnProperty(table, "id-column", "type", "VARCHAR"));
        manipulation.setDataColumnName(this.getColumnProperty(table, "data-column", "name", "datum"));
        manipulation.setDataColumnType(this.getColumnProperty(table, "data-column", "type", "BINARY"));
        manipulation.setTimestampColumnName(this.getColumnProperty(table, "timestamp-column", "name", "version"));
        manipulation.setTimestampColumnType(this.getColumnProperty(table, "timestamp-column", "type", "BIGINT"));
        return manipulation;
    }

    String getColumnProperty(ModelNode table, String columnKey, String key, String defaultValue) {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        return column.hasDefined(key) ? column.get(key).asString() : defaultValue;
    }

    protected class AdditionalDependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;
        private final boolean hasInjector;

        AdditionalDependency(ServiceName name) {
            this.name = name;
            this.type = null;
            this.target = null;
            this.hasInjector = false;
        }

        AdditionalDependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
            this.hasInjector = true;
        }

        ServiceName getName() {
            return this.name;
        }

        public boolean hasInjector() {
            return this.hasInjector;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getTarget() {
            return this.target;
        }
    }
}

