/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.config.Configuration;
import org.infinispan.manager.CacheContainer;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaults;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerDefaultsService;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.TransportConfiguration;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.jgroups.Channel;

public class CacheContainerAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheContainerAdd.class.getPackage().getName());
    public static final CacheContainerAdd INSTANCE = new CacheContainerAdd();

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        CacheContainerAdd.populate(existing, operation);
        return operation;
    }

    static String getContainerJNDIName(ModelNode container, String name) {
        JndiName jndiName = null;
        jndiName = container.hasDefined("jndi-name") ? CacheContainerAdd.toJndiName(container.get("jndi-name").asString()) : JndiName.of((String)"java:jboss").append("infinispan").append(name);
        return jndiName.getAbsoluteName();
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("default-cache").set(source.require("default-cache"));
        if (source.hasDefined("jndi-name")) {
            target.get("jndi-name").set(source.get("jndi-name"));
        }
        if (source.hasDefined("listener-executor")) {
            target.get("listener-executor").set(source.get("listener-executor"));
        }
        if (source.hasDefined("eviction-executor")) {
            target.get("eviction-executor").set(source.get("eviction-executor"));
        }
        if (source.hasDefined("replication-queue-executor")) {
            target.get("replication-queue-executor").set(source.get("replication-queue-executor"));
        }
        if (source.hasDefined("alias")) {
            ModelNode aliases = target.get("alias");
            for (ModelNode alias : source.get("alias").asList()) {
                aliases.add(alias);
            }
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        CacheContainerAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        model = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String defaultCache = model.require("default-cache").asString();
        Transport transportConfig = new Transport();
        EmbeddedCacheManager config = new EmbeddedCacheManager(name, defaultCache, transportConfig);
        ServiceName[] aliases = null;
        if (model.hasDefined("alias")) {
            List list = operation.get("alias").asList();
            aliases = new ServiceName[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                aliases[i] = EmbeddedCacheManagerService.getServiceName(((ModelNode)list.get(i)).asString());
            }
        }
        ServiceTarget target = context.getServiceTarget();
        ServiceName serviceName = EmbeddedCacheManagerService.getServiceName(name);
        ServiceBuilder containerBuilder = target.addService(serviceName, (Service)new EmbeddedCacheManagerService(config)).addDependency(EmbeddedCacheManagerDefaultsService.SERVICE_NAME, EmbeddedCacheManagerDefaults.class, config.getDefaultsInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, config.getTransactionManagerInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, config.getTransactionSynchronizationRegistryInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, config.getXAResourceRecoveryRegistryInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, config.getMBeanServerInjector()).addAliases(aliases).setInitialMode(ServiceController.Mode.ON_DEMAND);
        String jndiName = (model.hasDefined("jndi-name") ? CacheContainerAdd.toJndiName(model.get("jndi-name").asString()) : JndiName.of((String)"java:jboss").append("infinispan").append(name)).getAbsoluteName();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(serviceName, CacheContainer.class, (Injector)new ManagedReferenceInjector(binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.ON_DEMAND);
        newControllers.add(binderBuilder.install());
        String stack = null;
        if (model.hasDefined("singleton")) {
            ModelNode transport = model.get(new String[]{"singleton", "transport"});
            if (transport.hasDefined("stack")) {
                stack = transport.get("stack").asString();
            }
            this.addExecutorDependency((ServiceBuilder<CacheContainer>)containerBuilder, transport, "executor", transportConfig.getExecutorInjector());
            if (transport.hasDefined("lock-timeout")) {
                transportConfig.setLockTimeout(transport.get("lock-timeout").asLong());
            }
            if (transport.hasDefined("site")) {
                transportConfig.setSite(transport.get("site").asString());
            }
            if (transport.hasDefined("rack")) {
                transportConfig.setRack(transport.get("rack").asString());
            }
            if (transport.hasDefined("machine")) {
                transportConfig.setMachine(transport.get("machine").asString());
            }
        }
        ServiceName channelServiceName = ChannelService.getServiceName((String)name);
        containerBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, channelServiceName, Channel.class, transportConfig.getChannelInjector());
        this.addExecutorDependency((ServiceBuilder<CacheContainer>)containerBuilder, model, "listener-executor", config.getListenerExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<CacheContainer>)containerBuilder, model, "eviction-executor", config.getEvictionExecutorInjector());
        this.addScheduledExecutorDependency((ServiceBuilder<CacheContainer>)containerBuilder, model, "replication-queue-executor", config.getReplicationQueueExecutorInjector());
        newControllers.add(containerBuilder.install());
        InjectedValue channelFactory = new InjectedValue();
        ServiceBuilder channelBuilder = target.addService(channelServiceName, (Service)new ChannelService(name, (Value)channelFactory)).addAliases(new ServiceName[]{EmbeddedCacheManagerService.getTransportServiceName(name)}).addDependency(ChannelFactoryService.getServiceName((String)stack), ChannelFactory.class, (Injector)channelFactory).setInitialMode(ServiceController.Mode.NEVER);
        newControllers.add(channelBuilder.install());
        log.debugf("Cache container %s installed", (Object)name);
    }

    private void addExecutorDependency(ServiceBuilder<CacheContainer> builder, ModelNode model, String key, Injector<Executor> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), Executor.class, injector);
        }
    }

    private void addScheduledExecutorDependency(ServiceBuilder<CacheContainer> builder, ModelNode model, String key, Injector<ScheduledExecutorService> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), ScheduledExecutorService.class, injector);
        }
    }

    private static JndiName toJndiName(String value) {
        return value.startsWith("java:") ? JndiName.of((String)value) : JndiName.of((String)"java:jboss").append(value.startsWith("/") ? value.substring(1) : value);
    }

    static class Transport
    implements TransportConfiguration {
        private final InjectedValue<Channel> channel = new InjectedValue();
        private final InjectedValue<Executor> executor = new InjectedValue();
        private Long lockTimeout;
        private String site;
        private String rack;
        private String machine;

        Transport() {
        }

        void setLockTimeout(long lockTimeout) {
            this.lockTimeout = lockTimeout;
        }

        void setSite(String site) {
            this.site = site;
        }

        void setRack(String rack) {
            this.rack = rack;
        }

        void setMachine(String machine) {
            this.machine = machine;
        }

        Injector<Channel> getChannelInjector() {
            return this.channel;
        }

        Injector<Executor> getExecutorInjector() {
            return this.executor;
        }

        @Override
        public Value<Channel> getChannel() {
            return this.channel;
        }

        @Override
        public Executor getExecutor() {
            return (Executor)this.executor.getOptionalValue();
        }

        @Override
        public Long getLockTimeout() {
            return this.lockTimeout;
        }

        @Override
        public String getSite() {
            return this.site;
        }

        @Override
        public String getRack() {
            return this.rack;
        }

        @Override
        public String getMachine() {
            return this.machine;
        }
    }

    static class EmbeddedCacheManager
    implements EmbeddedCacheManagerConfiguration {
        private final InjectedValue<EmbeddedCacheManagerDefaults> defaults = new InjectedValue();
        private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistry = new InjectedValue();
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
        private final String name;
        private final String defaultCache;
        private final Map<String, Configuration> configurations = new HashMap<String, Configuration>();
        private final TransportConfiguration transport;

        EmbeddedCacheManager(String name, String defaultCache, TransportConfiguration transport) {
            this.name = name;
            this.defaultCache = defaultCache;
            this.transport = transport;
        }

        Injector<EmbeddedCacheManagerDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.transactionManager;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.transactionSynchronizationRegistry;
        }

        Injector<XAResourceRecoveryRegistry> getXAResourceRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<Executor> getListenerExecutorInjector() {
            return this.listenerExecutor;
        }

        Injector<ScheduledExecutorService> getEvictionExecutorInjector() {
            return this.evictionExecutor;
        }

        Injector<ScheduledExecutorService> getReplicationQueueExecutorInjector() {
            return this.replicationQueueExecutor;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDefaultCache() {
            return this.defaultCache;
        }

        @Override
        public Map<String, Configuration> getConfigurations() {
            return this.configurations;
        }

        @Override
        public TransportConfiguration getTransportConfiguration() {
            return this.transport;
        }

        @Override
        public EmbeddedCacheManagerDefaults getDefaults() {
            return (EmbeddedCacheManagerDefaults)this.defaults.getValue();
        }

        @Override
        public Value<TransactionManager> getTransactionManager() {
            return this.transactionManager;
        }

        @Override
        public Value<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistry() {
            return this.transactionSynchronizationRegistry;
        }

        @Override
        public XAResourceRecoveryRegistry getXAResourceRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public Executor getListenerExecutor() {
            return (Executor)this.listenerExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getEvictionExecutor() {
            return (ScheduledExecutorService)this.evictionExecutor.getOptionalValue();
        }

        @Override
        public ScheduledExecutorService getReplicationQueueExecutor() {
            return (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        }
    }
}

