/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.executors.ExecutorFactory;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.jboss.as.clustering.concurrent.ManagedExecutorService;
import org.jboss.as.clustering.concurrent.ManagedScheduledExecutorService;
import org.jboss.as.clustering.infinispan.InfinispanMessages;

public class ExecutorProvider
implements ExecutorFactory,
ScheduledExecutorFactory {
    private static final ExecutorProvider INSTANCE = new ExecutorProvider();
    private static final String EXECUTOR = "executor";

    public static void initListenerExecutor(GlobalConfigurationBuilder builder, Executor executor) {
        builder.asyncListenerExecutor().factory((ExecutorFactory)INSTANCE).withProperties(ExecutorProvider.createProperties(executor));
    }

    public static void initTransportExecutor(GlobalConfigurationBuilder builder, Executor executor) {
        builder.asyncTransportExecutor().factory((ExecutorFactory)INSTANCE).withProperties(ExecutorProvider.createProperties(executor));
    }

    public static void initEvictionExecutor(GlobalConfigurationBuilder builder, ScheduledExecutorService executor) {
        builder.evictionScheduledExecutor().factory((ScheduledExecutorFactory)INSTANCE).withProperties(ExecutorProvider.createProperties(executor));
    }

    public static void initReplicationQueueExecutor(GlobalConfigurationBuilder builder, ScheduledExecutorService executor) {
        builder.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)INSTANCE).withProperties(ExecutorProvider.createProperties(executor));
    }

    private static Properties createProperties(Executor executor) {
        Properties properties = new Properties();
        properties.put(EXECUTOR, executor);
        return properties;
    }

    public ExecutorService getExecutor(Properties properties) {
        Executor executor = (Executor)properties.get(EXECUTOR);
        if (executor == null) {
            throw InfinispanMessages.MESSAGES.invalidExecutorProperty(EXECUTOR, properties);
        }
        return new ManagedExecutorService(executor);
    }

    public ScheduledExecutorService getScheduledExecutor(Properties properties) {
        ScheduledExecutorService executor = (ScheduledExecutorService)properties.get(EXECUTOR);
        if (executor == null) {
            throw InfinispanMessages.MESSAGES.invalidExecutorProperty(EXECUTOR, properties);
        }
        return new ManagedScheduledExecutorService(executor);
    }
}

