/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.xa.XAResource;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class CacheService<K, V>
implements Service<Cache<K, V>> {
    private final Dependencies dependencies;
    private final String name;
    private volatile Cache<K, V> cache;
    private volatile XAResourceRecovery recovery;
    private static final Logger log = Logger.getLogger((String)CacheService.class.getPackage().getName());

    public static ServiceName getServiceName(String container, String cache) {
        return EmbeddedCacheManagerService.getServiceName(container).append(new String[]{cache != null ? cache : "___defaultcache"});
    }

    public CacheService(String name, Dependencies dependencies) {
        this.name = name;
        this.dependencies = dependencies;
    }

    public Cache<K, V> getValue() {
        return this.cache;
    }

    public void start(StartContext context) {
        EmbeddedCacheManager container = this.dependencies.getCacheContainer();
        this.cache = container.getCache(this.name);
        this.cache.start();
        XAResourceRecoveryRegistry recoveryRegistry = this.dependencies.getRecoveryRegistry();
        if (recoveryRegistry != null) {
            this.recovery = new InfinispanXAResourceRecovery(this.name, container);
            recoveryRegistry.addXAResourceRecovery(this.recovery);
        }
        log.debugf("%s cache started", (Object)this.name);
    }

    public void stop(StopContext context) {
        if (this.cache != null && this.cache.getStatus().allowInvocations()) {
            if (this.recovery != null) {
                this.dependencies.getRecoveryRegistry().removeXAResourceRecovery(this.recovery);
            }
            this.cache.stop();
            log.debugf("%s cache stopped", (Object)this.name);
        }
    }

    static class InfinispanXAResourceRecovery
    implements XAResourceRecovery {
        private final String cacheName;
        private final EmbeddedCacheManager container;

        InfinispanXAResourceRecovery(String cacheName, EmbeddedCacheManager container) {
            this.cacheName = cacheName;
            this.container = container;
        }

        public XAResource[] getXAResources() {
            return new XAResource[]{this.container.getCache(this.cacheName).getAdvancedCache().getXAResource()};
        }

        public int hashCode() {
            return this.container.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName().hashCode() ^ this.cacheName.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof InfinispanXAResourceRecovery)) {
                return false;
            }
            InfinispanXAResourceRecovery recovery = (InfinispanXAResourceRecovery)object;
            return this.container.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName().equals(recovery.container.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName()) && this.cacheName.equals(recovery.cacheName);
        }

        public String toString() {
            return this.container.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName() + "." + this.cacheName;
        }
    }

    public static interface Dependencies {
        public EmbeddedCacheManager getCacheContainer();

        public XAResourceRecoveryRegistry getRecoveryRegistry();
    }
}

