/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.jboss.as.clustering.ManagedExecutorService;
import org.jboss.as.clustering.ManagedScheduledExecutorService;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.JGroupsLogger;
import org.jboss.as.clustering.jgroups.ManagedSocketFactory;
import org.jboss.as.clustering.jgroups.MuxChannel;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.ThreadFactoryAdapter;
import org.jboss.as.clustering.jgroups.TimerSchedulerAdapter;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.network.SocketBinding;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;

public class JChannelFactory
implements ChannelFactory,
ChannelListener,
ProtocolStackConfigurator {
    private final ProtocolStackConfiguration configuration;
    private final Map<Channel, String> channels = Collections.synchronizedMap(new WeakHashMap());

    public JChannelFactory(ProtocolStackConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel createChannel(String id) throws Exception {
        MuxChannel channel = new MuxChannel(this);
        TP transport = channel.getProtocolStack().getTransport();
        if (transport.isSingleton()) {
            TP tP = transport;
            synchronized (tP) {
                this.init(transport);
            }
        } else {
            this.init(transport);
        }
        channel.setName(this.configuration.getEnvironment().getNodeName() + "/" + id);
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            try {
                this.channels.put((Channel)channel, id);
                JmxConfigurator.registerChannel((JChannel)channel, (MBeanServer)server, (String)id);
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            }
            channel.addChannelListener(this);
        }
        return channel;
    }

    private void init(TP transport) {
        ScheduledExecutorService timerExecutor;
        ExecutorService oobExecutor;
        ExecutorService defaultExecutor;
        java.util.concurrent.ThreadFactory threadFactory;
        SocketFactory factory;
        TransportConfiguration transportConfig = this.configuration.getTransport();
        SocketBinding binding = transportConfig.getSocketBinding();
        if (binding != null && !((factory = transport.getSocketFactory()) instanceof ManagedSocketFactory)) {
            transport.setSocketFactory((SocketFactory)new ManagedSocketFactory(factory, binding.getSocketBindings()));
        }
        if ((threadFactory = transportConfig.getThreadFactory()) != null && !(transport.getThreadFactory() instanceof ThreadFactoryAdapter)) {
            transport.setThreadFactory((ThreadFactory)new ThreadFactoryAdapter(threadFactory));
        }
        if ((defaultExecutor = transportConfig.getDefaultExecutor()) != null && !(transport.getDefaultThreadPool() instanceof ManagedExecutorService)) {
            transport.setDefaultThreadPool((Executor)new ManagedExecutorService(defaultExecutor));
        }
        if ((oobExecutor = transportConfig.getOOBExecutor()) != null && !(transport.getOOBThreadPool() instanceof ManagedExecutorService)) {
            transport.setOOBThreadPool((Executor)new ManagedExecutorService(oobExecutor));
        }
        if ((timerExecutor = transportConfig.getTimerExecutor()) != null && !(transport.getTimer() instanceof TimerSchedulerAdapter)) {
            this.setValue((Protocol)transport, "timer", new TimerSchedulerAdapter((ScheduledExecutorService)new ManagedScheduledExecutorService(timerExecutor)));
        }
    }

    public String getProtocolStackString() {
        return null;
    }

    public List<org.jgroups.conf.ProtocolConfiguration> getProtocolStack() {
        SocketBinding diagnosticsSocketBinding;
        SocketBinding binding;
        ArrayList<org.jgroups.conf.ProtocolConfiguration> configs = new ArrayList<org.jgroups.conf.ProtocolConfiguration>(this.configuration.getProtocols().size() + 1);
        TransportConfiguration transport = this.configuration.getTransport();
        org.jgroups.conf.ProtocolConfiguration config = this.createProtocol(transport);
        Map properties = config.getProperties();
        if (transport.isShared()) {
            properties.put("singleton_name", this.configuration.getName());
        }
        if ((binding = transport.getSocketBinding()) != null) {
            this.configureBindAddress(transport, config, binding);
            this.configureServerSocket(transport, config, "bind_port", binding);
            this.configureMulticastSocket(transport, config, "mcast_addr", "mcast_port", binding);
        }
        boolean diagnostics = (diagnosticsSocketBinding = transport.getDiagnosticsSocketBinding()) != null;
        properties.put("enable_diagnostics", String.valueOf(diagnostics));
        if (diagnostics) {
            this.configureMulticastSocket(transport, config, "diagnostics_addr", "diagnostics_port", diagnosticsSocketBinding);
        }
        configs.add(config);
        for (ProtocolConfiguration protocol : this.configuration.getProtocols()) {
            config = this.createProtocol(protocol);
            binding = protocol.getSocketBinding();
            if (binding != null) {
                this.configureBindAddress(protocol, config, binding);
                this.configureServerSocket(protocol, config, "bind_port", binding);
                this.configureServerSocket(protocol, config, "start_port", binding);
                this.configureMulticastSocket(protocol, config, "mcast_addr", "mcast_port", binding);
            } else if (transport.getSocketBinding() != null) {
                this.configureBindAddress(protocol, config, transport.getSocketBinding());
            }
            configs.add(config);
        }
        return configs;
    }

    private void configureBindAddress(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, SocketBinding binding) {
        String property = "bind_addr";
        if (protocol.hasProperty("bind_addr")) {
            config.getProperties().put("bind_addr", binding.getSocketAddress().getAddress().getHostAddress());
        }
    }

    private void configureServerSocket(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String property, SocketBinding binding) {
        if (protocol.hasProperty(property)) {
            config.getProperties().put(property, String.valueOf(binding.getSocketAddress().getPort()));
        }
    }

    private void configureMulticastSocket(ProtocolConfiguration protocol, org.jgroups.conf.ProtocolConfiguration config, String addressProperty, String portProperty, SocketBinding binding) {
        Map properties = config.getProperties();
        try {
            InetSocketAddress mcastSocketAddress = binding.getMulticastSocketAddress();
            if (protocol.hasProperty(addressProperty)) {
                properties.put(addressProperty, mcastSocketAddress.getAddress().getHostAddress());
            }
            if (protocol.hasProperty(portProperty)) {
                properties.put(portProperty, String.valueOf(mcastSocketAddress.getPort()));
            }
        }
        catch (IllegalStateException e) {
            JGroupsLogger.ROOT_LOGGER.tracef(e, "Could not set %s.%s and %s.%s, %s socket binding does not specify a multicast socket", new Object[]{config.getProtocolName(), addressProperty, config.getProtocolName(), portProperty, binding.getName()});
        }
    }

    private org.jgroups.conf.ProtocolConfiguration createProtocol(ProtocolConfiguration protocolConfig) {
        String protocol = protocolConfig.getName();
        final HashMap<String, String> properties = new HashMap<String, String>(this.configuration.getDefaults().getProperties(protocol));
        properties.putAll(protocolConfig.getProperties());
        return new org.jgroups.conf.ProtocolConfiguration(protocol, properties){

            public Map<String, String> getOriginalProperties() {
                return properties;
            }
        };
    }

    private void setValue(Protocol protocol, String property, Object value) {
        JGroupsLogger.ROOT_LOGGER.tracef("Setting %s.%s=%d", protocol.getName(), property, value);
        try {
            protocol.setValue(property, value);
        }
        catch (IllegalArgumentException e) {
            JGroupsLogger.ROOT_LOGGER.tracef(e, "Failed to set non-existent %s.%s=%d", protocol.getName(), property, value);
        }
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    public void channelClosed(Channel channel) {
        MBeanServer server = this.configuration.getMBeanServer();
        if (server != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)((JChannel)channel), (MBeanServer)server, (String)this.channels.remove(channel));
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.warn(e.getMessage(), e);
            }
        }
    }
}

