/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;

public class TimerSchedulerAdapter
implements TimeScheduler {
    private final ScheduledExecutorService executor;

    public TimerSchedulerAdapter(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executor.schedule(command, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithDynamicInterval(final TimeScheduler.Task task) {
        final MutableScheduledFuture future = new MutableScheduledFuture(this.schedule((Runnable)task, task.nextInterval(), TimeUnit.MILLISECONDS));
        final long nextInterval = task.nextInterval();
        if (nextInterval > 0L) {
            Runnable scheduleTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        future.get();
                        long interval = nextInterval;
                        while (interval > 0L && !Thread.currentThread().isInterrupted()) {
                            future.setFuture(TimerSchedulerAdapter.this.schedule((Runnable)task, interval, TimeUnit.MILLISECONDS));
                            future.get();
                            interval = task.nextInterval();
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            this.execute(scheduleTask);
        }
        return future;
    }

    public void setThreadFactory(ThreadFactory factory) {
    }

    public String dumpTimerTasks() {
        return this.getThreadPool().getQueue().toString();
    }

    public int getMinThreads() {
        return this.getThreadPool().getCorePoolSize();
    }

    public void setMinThreads(int size) {
    }

    public int getMaxThreads() {
        return this.getThreadPool().getMaximumPoolSize();
    }

    public void setMaxThreads(int size) {
    }

    public long getKeepAliveTime() {
        return this.getThreadPool().getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    public void setKeepAliveTime(long time) {
    }

    public int getCurrentThreads() {
        return this.getThreadPool().getActiveCount();
    }

    public int size() {
        return this.getThreadPool().getPoolSize();
    }

    public void stop() {
        this.executor.shutdown();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    private ThreadPoolExecutor getThreadPool() {
        return TimerSchedulerAdapter.getThreadPool(this.executor);
    }

    private static ThreadPoolExecutor getThreadPool(Executor executor) {
        if (executor instanceof ThreadPoolExecutor) {
            return (ThreadPoolExecutor)executor;
        }
        final Field field = TimerSchedulerAdapter.getField(executor.getClass(), Executor.class);
        if (field != null) {
            PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    field.setAccessible(true);
                    return null;
                }
            };
            AccessController.doPrivileged(action);
            try {
                return TimerSchedulerAdapter.getThreadPool((Executor)field.get(executor));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static <T> Field getField(Class<? extends T> targetClass, Class<T> fieldClass) {
        for (Field field : targetClass.getDeclaredFields()) {
            if (!fieldClass.isAssignableFrom(field.getType())) continue;
            return field;
        }
        Class<T> superClass = targetClass.getSuperclass();
        return superClass != null && fieldClass.isAssignableFrom(superClass) ? TimerSchedulerAdapter.getField(superClass.asSubclass(fieldClass), fieldClass) : null;
    }

    private static class MutableScheduledFuture<T>
    implements ScheduledFuture<T> {
        private volatile ScheduledFuture<T> future;

        MutableScheduledFuture(ScheduledFuture<T> future) {
            this.setFuture(future);
        }

        void setFuture(ScheduledFuture<T> future) {
            this.future = future;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.future.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed delayed) {
            return this.future.compareTo(delayed);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return (T)this.future.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (T)this.future.get(timeout, unit);
        }
    }
}

