/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.clustering.jgroups.LogFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemAdd;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemDescribe;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemProviders;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRemove;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemXMLWriter;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackAdd;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackRemove;
import org.jboss.as.clustering.jgroups.subsystem.StackConfigOperationHandlers;
import org.jboss.as.clustering.jgroups.subsystem.SubsystemWriteAttributeHandler;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class JGroupsExtension
implements Extension {
    static final String SUBSYSTEM_NAME = "jgroups";
    private static final PathElement stacksPath = PathElement.pathElement((String)"stack");
    private static final PathElement transportPath = PathElement.pathElement((String)"transport", (String)"TRANSPORT");
    private static final PathElement protocolPath = PathElement.pathElement((String)"protocol");
    private static final PathElement protocolPropertyPath = PathElement.pathElement((String)"property");
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 1;
    private static final int MANAGEMENT_API_MICRO_VERSION = 0;

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, 1, 1, 0);
        subsystem.registerXMLElementWriter((XMLElementWriter)new JGroupsSubsystemXMLWriter());
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel(JGroupsSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationStepHandler)JGroupsSubsystemAdd.INSTANCE, JGroupsSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("remove", (OperationStepHandler)JGroupsSubsystemRemove.INSTANCE, JGroupsSubsystemProviders.SUBSYSTEM_REMOVE, false);
        registration.registerOperationHandler("describe", (OperationStepHandler)JGroupsSubsystemDescribe.INSTANCE, JGroupsSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        SubsystemWriteAttributeHandler.INSTANCE.registerAttributes(registration);
        ManagementResourceRegistration stacks = registration.registerSubModel(stacksPath, JGroupsSubsystemProviders.STACK);
        stacks.registerOperationHandler("add", (OperationStepHandler)ProtocolStackAdd.INSTANCE, JGroupsSubsystemProviders.STACK_ADD, false);
        stacks.registerOperationHandler("remove", (OperationStepHandler)ProtocolStackRemove.INSTANCE, JGroupsSubsystemProviders.STACK_REMOVE, false);
        stacks.registerOperationHandler("add-protocol", StackConfigOperationHandlers.PROTOCOL_ADD, JGroupsSubsystemProviders.PROTOCOL_ADD);
        stacks.registerOperationHandler("remove-protocol", StackConfigOperationHandlers.PROTOCOL_REMOVE, JGroupsSubsystemProviders.PROTOCOL_REMOVE);
        if (context.isRuntimeOnlyRegistrationValid()) {
            EnumSet<OperationEntry.Flag> readOnly = EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY);
            stacks.registerOperationHandler("export-native-configuration", StackConfigOperationHandlers.EXPORT_NATIVE_CONFIGURATION, JGroupsSubsystemProviders.EXPORT_NATIVE_CONFIGURATION, readOnly);
        }
        ManagementResourceRegistration transport = stacks.registerSubModel(transportPath, JGroupsSubsystemProviders.TRANSPORT);
        transport.registerOperationHandler("add", StackConfigOperationHandlers.TRANSPORT_ADD, JGroupsSubsystemProviders.TRANSPORT_ADD);
        transport.registerOperationHandler("remove", StackConfigOperationHandlers.REMOVE, JGroupsSubsystemProviders.TRANSPORT_REMOVE);
        StackConfigOperationHandlers.TRANSPORT_ATTR.registerAttributes(transport);
        JGroupsExtension.createPropertyRegistration(transport);
        ManagementResourceRegistration protocol = stacks.registerSubModel(protocolPath, JGroupsSubsystemProviders.PROTOCOL);
        StackConfigOperationHandlers.PROTOCOL_ATTR.registerAttributes(protocol);
        JGroupsExtension.createPropertyRegistration(protocol);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }

    static void createPropertyRegistration(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel(protocolPropertyPath, JGroupsSubsystemProviders.PROTOCOL_PROPERTY);
        registration.registerOperationHandler("add", StackConfigOperationHandlers.PROTOCOL_PROPERTY_ADD, JGroupsSubsystemProviders.PROTOCOL_PROPERTY_ADD);
        registration.registerOperationHandler("remove", StackConfigOperationHandlers.REMOVE, JGroupsSubsystemProviders.PROTOCOL_PROPERTY_REMOVE);
        registration.registerReadWriteAttribute("value", null, StackConfigOperationHandlers.PROTOCOL_PROPERTY_ATTR, EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES));
    }

    static {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("jgroups.logging.log_factory_class") == null) {
                    System.setProperty("jgroups.logging.log_factory_class", LogFactory.class.getName());
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

