/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.service;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.CoreGroupCommunicationServiceService;
import org.jboss.as.clustering.GroupMembershipListener;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.infinispan.atomic.AtomicMapCache;
import org.jboss.as.clustering.infinispan.invoker.BatchOperation;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.service.ServiceProviderRegistry;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

@Listener(sync=false)
public class ServiceProviderRegistryService
implements ServiceProviderRegistry,
GroupMembershipListener,
Service<ServiceProviderRegistry> {
    private static final short SCOPE_ID = 224;
    private final InjectedValue<Cache> cacheRef = new InjectedValue();
    private final InjectedValue<GroupMembershipNotifier> notifierRef = new InjectedValue();
    private final Map<String, ServiceProviderRegistry.Listener> listeners = new ConcurrentHashMap<String, ServiceProviderRegistry.Listener>();
    private volatile GroupMembershipNotifier notifier;
    private volatile Cache<String, Map<ClusterNode, Void>> cache;

    public static ServiceName getServiceName(String name) {
        return CoreGroupCommunicationServiceService.getServiceName((String)name).append(new String[]{"registry"});
    }

    public ServiceBuilder<ServiceProviderRegistry> build(ServiceTarget target, String container) {
        new CoreGroupCommunicationServiceService(224).build(target, container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        return target.addService(ServiceProviderRegistryService.getServiceName(container), (Service)this).addDependency(CacheService.getServiceName((String)container, null), Cache.class, this.cacheRef).addDependency(CoreGroupCommunicationServiceService.getServiceName((String)container), GroupMembershipNotifier.class, this.notifierRef);
    }

    @Override
    public void register(final String service, ServiceProviderRegistry.Listener listener) {
        this.listeners.put(service, listener);
        final ClusterNode node = this.notifier.getClusterNode();
        Operation<Set<ClusterNode>> operation = new Operation<Set<ClusterNode>>(){

            public Set<ClusterNode> invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                Map map = (Map)cache.putIfAbsent((Object)service, null);
                map.put(node, null);
                return map.keySet();
            }
        };
        Set<ClusterNode> nodes = this.invoke(operation);
        listener.serviceProvidersChanged(nodes, false);
    }

    @Override
    public void unregister(final String service) {
        final ClusterNode node = this.notifier.getClusterNode();
        Operation<Void> operation = new Operation<Void>(){

            public Void invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                ((Map)cache.get((Object)service)).remove(node);
                return null;
            }
        };
        this.invoke(operation);
        this.listeners.remove(service);
    }

    @Override
    public Set<ClusterNode> getServiceProviders(String service) {
        return Collections.unmodifiableSet(((Map)this.cache.get((Object)service)).keySet());
    }

    public ServiceProviderRegistry getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.notifier = (GroupMembershipNotifier)this.notifierRef.getValue();
        this.notifier.registerGroupMembershipListener((GroupMembershipListener)this);
        Cache cache = (Cache)this.cacheRef.getValue();
        this.cache = new AtomicMapCache(cache.getAdvancedCache().with(this.getClass().getClassLoader()));
        this.cache.addListener((Object)this);
    }

    public void stop(StopContext context) {
        this.cache.removeListener((Object)this);
        this.notifier.unregisterGroupMembershipListener((GroupMembershipListener)this);
    }

    public void membershipChanged(List<ClusterNode> deadMembers, List<ClusterNode> newMembers, List<ClusterNode> allMembers) {
        this.purgeDeadMembers(deadMembers, false);
    }

    public void membershipChangedDuringMerge(List<ClusterNode> deadMembers, List<ClusterNode> newMembers, List<ClusterNode> allMembers, List<List<ClusterNode>> originatingGroups) {
        this.purgeDeadMembers(deadMembers, true);
    }

    private void purgeDeadMembers(final List<ClusterNode> deadNodes, boolean merge) {
        Operation<List<Map.Entry<String, Set<ClusterNode>>>> operation = new Operation<List<Map.Entry<String, Set<ClusterNode>>>>(){

            public List<Map.Entry<String, Set<ClusterNode>>> invoke(Cache<String, Map<ClusterNode, Void>> cache) {
                ArrayList<Map.Entry<String, Set<ClusterNode>>> entries = new ArrayList<Map.Entry<String, Set<ClusterNode>>>(cache.size());
                for (String key : cache.keySet()) {
                    Set nodes;
                    Map map = (Map)cache.get((Object)key);
                    if (map == null || !(nodes = map.keySet()).removeAll(deadNodes)) continue;
                    entries.add(new AbstractMap.SimpleImmutableEntry(key, nodes));
                }
                return entries;
            }
        };
        for (Map.Entry<String, Set<ClusterNode>> entry : this.invoke(operation)) {
            ServiceProviderRegistry.Listener listener = this.listeners.get(entry.getKey());
            if (listener == null) continue;
            listener.serviceProvidersChanged(entry.getValue(), merge);
        }
    }

    @CacheEntryModified
    public void modified(CacheEntryModifiedEvent<String, Map<ClusterNode, Void>> event) {
        if (event.isPre() || event.isOriginLocal()) {
            return;
        }
        String service = (String)event.getKey();
        ServiceProviderRegistry.Listener listener = this.listeners.get(service);
        if (listener != null) {
            listener.serviceProvidersChanged(((Map)event.getValue()).keySet(), false);
        }
    }

    private <R> R invoke(Operation<R> operation) {
        return (R)new BatchOperation(operation).invoke(this.cache);
    }

    abstract class Operation<R>
    implements CacheInvoker.Operation<String, Map<ClusterNode, Void>, R> {
        Operation() {
        }
    }
}

