/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.singleton;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.service.ServiceProviderRegistry;
import org.jboss.as.clustering.service.ServiceProviderRegistryService;
import org.jboss.as.clustering.singleton.SingletonElectionPolicy;
import org.jboss.as.clustering.singleton.SingletonLogger;
import org.jboss.as.clustering.singleton.SingletonMessages;
import org.jboss.as.clustering.singleton.SingletonRpcHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SingletonService<T extends Serializable>
implements Service<T>,
ServiceProviderRegistry.Listener,
StopContext,
SingletonRpcHandler<T> {
    public static final String DEFAULT_CONTAINER = "cluster";
    private final InjectedValue<ServiceProviderRegistry> registryRef = new InjectedValue();
    private final InjectedValue<GroupRpcDispatcher> dispatcherRef = new InjectedValue();
    private final Service<T> service;
    private final ServiceName serviceName;
    private final AtomicBoolean master = new AtomicBoolean(false);
    private volatile ServiceProviderRegistry registry;
    private volatile GroupRpcDispatcher dispatcher;
    private volatile SingletonElectionPolicy electionPolicy;
    private volatile SingletonRpcHandler<T> handler;
    private volatile StartContext context;
    private volatile boolean restartOnMerge = true;

    public SingletonService(Service<T> service, ServiceName serviceName) {
        this.service = service;
        this.serviceName = serviceName;
    }

    public ServiceBuilder<T> build(ServiceContainer target) {
        return this.build(target, DEFAULT_CONTAINER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceBuilder<T> build(ServiceContainer target, String container) {
        ServiceName registryName = ServiceProviderRegistryService.getServiceName((String)container);
        ServiceContainer serviceContainer = target;
        synchronized (serviceContainer) {
            if (target.getService(registryName) == null) {
                new ServiceProviderRegistryService().build((ServiceTarget)target, container).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            }
        }
        return target.addService(this.serviceName, (Service)this).addDependency(ServiceProviderRegistryService.getServiceName((String)container), ServiceProviderRegistry.class, this.registryRef).addDependency(ServiceName.JBOSS.append(new String[]{DEFAULT_CONTAINER, container}), GroupRpcDispatcher.class, this.dispatcherRef);
    }

    public void start(StartContext context) throws StartException {
        this.context = context;
        this.dispatcher = (GroupRpcDispatcher)this.dispatcherRef.getValue();
        this.registry = (ServiceProviderRegistry)this.registryRef.getValue();
        String name = this.serviceName.getCanonicalName();
        this.handler = new RpcHandler(this.dispatcher, name);
        this.dispatcher.registerRPCHandler(name, (Object)this, SingletonService.class.getClassLoader());
        this.registry.register(name, (ServiceProviderRegistry.Listener)this);
    }

    public void stop(StopContext context) {
        String name = this.serviceName.getCanonicalName();
        this.registry.unregister(name);
        this.dispatcher.unregisterRPCHandler(name, (Object)this);
    }

    public void setElectionPolicy(SingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
    }

    public void setRestartOnMerge(boolean restart) {
        this.restartOnMerge = restart;
    }

    public void serviceProvidersChanged(Set<ClusterNode> nodes, boolean merge) {
        if (this.elected(nodes)) {
            if (this.master.get()) {
                if (this.restartOnMerge && merge) {
                    this.stopOldMaster();
                    this.startNewMaster();
                }
            } else {
                SingletonLogger.ROOT_LOGGER.electedMaster(this.serviceName.getCanonicalName());
                this.handler.stopOldMaster();
                this.startNewMaster();
            }
        } else if (this.master.get()) {
            SingletonLogger.ROOT_LOGGER.electedSlave(this.serviceName.getCanonicalName());
            this.stopOldMaster();
        }
    }

    private boolean elected(Set<ClusterNode> candidates) {
        ClusterNode elected = this.election(candidates);
        return elected != null ? elected.equals(this.dispatcher.getClusterNode()) : false;
    }

    private ClusterNode election(Set<ClusterNode> candidates) {
        List nodes = this.dispatcher.getClusterNodes();
        nodes.retainAll(candidates);
        if (nodes.isEmpty()) {
            return null;
        }
        return this.electionPolicy == null || nodes.size() == 1 ? (ClusterNode)nodes.get(0) : this.electionPolicy.elect(nodes);
    }

    private void startNewMaster() {
        this.master.set(true);
        try {
            this.service.start(this.context);
        }
        catch (StartException e) {
            this.master.set(false);
            throw new RuntimeException(e);
        }
    }

    public T getValue() {
        AtomicReference<T> ref = this.getValueRef();
        return (T)(ref != null ? (Serializable)ref.get() : (Serializable)this.handler.getValueRef().get());
    }

    @Override
    public AtomicReference<T> getValueRef() {
        return this.master.get() ? new AtomicReference<Object>(this.service.getValue()) : null;
    }

    @Override
    public void stopOldMaster() {
        if (this.master.compareAndSet(true, false)) {
            this.service.stop((StopContext)this);
        }
    }

    public void asynchronous() throws IllegalStateException {
        this.context.asynchronous();
    }

    public void complete() throws IllegalStateException {
        this.context.complete();
    }

    public long getElapsedTime() {
        return this.context.getElapsedTime();
    }

    public ServiceController<?> getController() {
        return this.context.getController();
    }

    public void execute(Runnable command) {
        this.context.execute(command);
    }

    private class RpcHandler
    implements SingletonRpcHandler<T> {
        private final GroupRpcDispatcher dispatcher;
        private String name;

        RpcHandler(GroupRpcDispatcher dispatcher, String name) {
            this.dispatcher = dispatcher;
            this.name = name;
        }

        @Override
        public void stopOldMaster() {
            try {
                this.dispatcher.callMethodOnCluster(this.name, "stopOldMaster", new Object[0], new Class[0], true);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public AtomicReference<T> getValueRef() {
            try {
                List results = this.dispatcher.callMethodOnCluster(this.name, "getValueRef", new Object[0], new Class[0], false);
                Iterator refs = results.iterator();
                while (refs.hasNext()) {
                    if (refs.next() != null) continue;
                    refs.remove();
                }
                int count = results.size();
                if (count != 1) {
                    throw SingletonMessages.MESSAGES.unexpectedResponseCount(count);
                }
                return (AtomicReference)results.get(0);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

