/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import javax.transaction.TransactionManager;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.jboss.as.clustering.infinispan.ChannelProvider;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.ExecutorProvider;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.util.loading.ContextClassLoaderSwitcher;

public class EmbeddedCacheManagerService
implements Service<CacheContainer> {
    private static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"infinispan"});
    private final ContextClassLoaderSwitcher switcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
    private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
    private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
    private final InjectedValue<Executor> listenerExecutor = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> evictionExecutor = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> replicationQueueExecutor = new InjectedValue();
    private final InjectedValue<Executor> transportExecutor = new InjectedValue();
    private final GlobalConfiguration globalConfiguration;
    private final Configuration defaultConfiguration;
    private final Map<String, Configuration> configurations;
    private final String name;
    private final String defaultCache;
    private volatile CacheContainer container;

    public static ServiceName getServiceName() {
        return SERVICE_NAME;
    }

    public static ServiceName getServiceName(String name) {
        return SERVICE_NAME.append(new String[]{name});
    }

    public EmbeddedCacheManagerService(String name, String defaultCache, GlobalConfiguration globalConfiguration, Configuration defaultConfiguration, Map<String, Configuration> configurations) {
        this.name = name;
        this.defaultCache = defaultCache;
        this.globalConfiguration = globalConfiguration;
        this.defaultConfiguration = defaultConfiguration;
        this.configurations = configurations;
    }

    ServiceBuilder<CacheContainer> build(ServiceTarget target) {
        return target.addService(EmbeddedCacheManagerService.getServiceName(this.name), (Service)this).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"}), TransactionManager.class, this.transactionManager).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, this.mbeanServer);
    }

    void addTransportDependency(ServiceBuilder<CacheContainer> builder, String stack) {
        builder.addDependency(stack != null ? ChannelFactoryService.getServiceName(stack) : ChannelFactoryService.getServiceName(), ChannelFactory.class, this.channelFactory);
    }

    void addListenerExecutorDependency(ServiceBuilder<CacheContainer> builder, String executor) {
        builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, this.listenerExecutor);
    }

    void addEvictionExecutorDependency(ServiceBuilder<CacheContainer> builder, String executor) {
        builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, this.evictionExecutor);
    }

    void addReplicationQueueExecutorDependency(ServiceBuilder<CacheContainer> builder, String executor) {
        builder.addDependency(ThreadsServices.executorName((String)executor), ScheduledExecutorService.class, this.replicationQueueExecutor);
    }

    void addTransportExecutorDependency(ServiceBuilder<CacheContainer> builder, String executor) {
        builder.addDependency(ThreadsServices.executorName((String)executor), Executor.class, this.transportExecutor);
    }

    public CacheContainer getValue() throws IllegalStateException, IllegalArgumentException {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        TransactionManager transactionManager;
        ScheduledExecutorService evictionExecutor;
        Executor transportExecutor;
        this.globalConfiguration.setCacheManagerName(this.name);
        String nodeName = ((ServerEnvironment)this.environment.getValue()).getNodeName();
        this.globalConfiguration.setTransportNodeName(nodeName);
        this.globalConfiguration.setClusterName(String.format("%s:%s", nodeName, this.name));
        ChannelProvider.init(this.globalConfiguration, (ChannelFactory)this.channelFactory.getValue());
        MBeanServer server = (MBeanServer)this.mbeanServer.getOptionalValue();
        if (server != null) {
            this.globalConfiguration.setExposeGlobalJmxStatistics(true);
            this.globalConfiguration.setMBeanServerLookupInstance((MBeanServerLookup)new MBeanServerProvider(server));
            this.globalConfiguration.setJmxDomain(server.getDefaultDomain());
            this.defaultConfiguration.setExposeJmxStatistics(true);
        } else {
            this.globalConfiguration.setExposeGlobalJmxStatistics(false);
            this.defaultConfiguration.setExposeJmxStatistics(false);
        }
        Executor listenerExecutor = (Executor)this.listenerExecutor.getOptionalValue();
        if (listenerExecutor != null) {
            ExecutorProvider.initListenerExecutor(this.globalConfiguration, listenerExecutor);
        }
        if ((transportExecutor = (Executor)this.transportExecutor.getOptionalValue()) != null) {
            ExecutorProvider.initTransportExecutor(this.globalConfiguration, transportExecutor);
        }
        if ((evictionExecutor = (ScheduledExecutorService)this.evictionExecutor.getOptionalValue()) != null) {
            ExecutorProvider.initEvictionExecutor(this.globalConfiguration, evictionExecutor);
        }
        ScheduledExecutorService replicationQueueExecutor = (ScheduledExecutorService)this.replicationQueueExecutor.getOptionalValue();
        if (listenerExecutor != null) {
            ExecutorProvider.initReplicationQueueExecutor(this.globalConfiguration, replicationQueueExecutor);
        }
        if ((transactionManager = (TransactionManager)this.transactionManager.getOptionalValue()) != null) {
            this.defaultConfiguration.setTransactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(transactionManager));
        }
        ContextClassLoaderSwitcher.SwitchContext switchContext = this.switcher.getSwitchContext(this.getClass().getClassLoader());
        try {
            DefaultCacheManager manager = new DefaultCacheManager(this.globalConfiguration, this.defaultConfiguration, false);
            for (Map.Entry<String, Configuration> entry : this.configurations.entrySet()) {
                manager.defineConfiguration(entry.getKey(), entry.getValue());
            }
            this.container = new DefaultCacheContainer((EmbeddedCacheManager)manager, this.defaultCache);
            this.container.start();
        }
        finally {
            switchContext.reset();
        }
    }

    public void stop(StopContext context) {
        this.container.stop();
        this.container = null;
    }
}

