/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.LocalDescriptions;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeOperationContext;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.services.net.SocketBinding;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossExecutors;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;

public class ProtocolStackAdd
implements ModelAddOperationHandler,
DescriptionProvider {
    private static final String DEFAULTS = "jgroups-defaults.xml";
    final Map<String, Map<String, String>> defaults = new HashMap<String, Map<String, String>>();

    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        ProtocolStackAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("transport").set(source.require("transport"));
        ModelNode protocols = target.get("protocol");
        for (ModelNode protocol : source.require("protocol").asList()) {
            protocols.add(protocol);
        }
    }

    public ProtocolStackAdd() {
        ProtocolStackConfigurator configurator = this.load(DEFAULTS);
        for (org.jgroups.conf.ProtocolConfiguration config : configurator.getProtocolStack()) {
            this.defaults.put(config.getProtocolName(), config.getProperties());
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return LocalDescriptions.getProtocolStackAddDescription(locale);
    }

    public OperationResult execute(OperationContext context, final ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        ModelNode removeOperation = Util.getResourceRemoveOperation((ModelNode)opAddr);
        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        ProtocolStackAdd.populate(operation, context.getSubModel());
        RuntimeOperationContext runtime = context.getRuntimeContext();
        if (runtime != null) {
            RuntimeTask task = new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ModelNode transport = operation.get("transport");
                    String type = transport.require("type").asString();
                    TransportConfigurationImpl transportConfig = new TransportConfigurationImpl(type, ProtocolStackAdd.this.defaults.get(type));
                    ProtocolStackConfigurationImpl stackConfig = new ProtocolStackConfigurationImpl(transportConfig);
                    InjectionCollector injections = new InjectionCollector();
                    this.process(transport, transportConfig, injections);
                    if (transport.has("diagnostics-socket-binding")) {
                        injections.addSocketBindingInjector(transport.get("diagnostics-socket-binding").asString(), transportConfig.getDiagnosticsSocketBindingInjector());
                    }
                    if (transport.has("default-executor")) {
                        injections.addExecutorInjector(transport.get("default-executor").asString(), transportConfig.getDefaultExecutorInjector());
                    }
                    if (transport.has("oob-executor")) {
                        injections.addExecutorInjector(transport.get("oob-executor").asString(), transportConfig.getOOBExecutorInjector());
                    }
                    if (transport.has("timer-executor")) {
                        injections.addScheduledExecutorInjector(transport.get("timer-executor").asString(), transportConfig.getTimerExecutorInjector());
                    }
                    if (transport.has("thread-factory")) {
                        injections.addThreadFactoryInjector(transport.get("thread-factory").asString(), transportConfig.getThreadFactoryInjector());
                    }
                    for (ModelNode protocol : operation.get("protocol").asList()) {
                        type = protocol.require("type").asString();
                        ProtocolConfigurationImpl protocolConfig = new ProtocolConfigurationImpl(type, ProtocolStackAdd.this.defaults.get(type));
                        this.process(protocol, protocolConfig, injections);
                        stackConfig.getProtocols().add(protocolConfig);
                    }
                    ServiceBuilder<ChannelFactory> builder = new ChannelFactoryService(name, stackConfig).build(context.getServiceTarget());
                    injections.addDependencies(builder);
                    builder.install();
                    resultHandler.handleResultComplete();
                }

                private void process(ModelNode protocol, ProtocolConfigurationImpl protocolConfig, InjectionCollector injections) {
                    if (protocol.has("socket-binding")) {
                        injections.addSocketBindingInjector(protocol.get("socket-binding").asString(), protocolConfig.getSocketBindingInjector());
                    }
                    Map<String, String> properties = protocolConfig.getProperties();
                    if (protocol.has("property")) {
                        for (Property property : protocol.get("property").asPropertyList()) {
                            properties.put(property.getName(), property.getValue().asString());
                        }
                    }
                }
            };
            runtime.setRuntimeTask(task);
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(removeOperation);
    }

    private ProtocolStackConfigurator load(String resource) {
        URL url = JGroupsExtension.class.getClassLoader().getResource(resource);
        if (url == null) {
            throw new IllegalStateException(String.format("Failed to locate %s", resource));
        }
        try {
            return XmlConfigurator.getInstance((URL)url);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Failed to parse %s", url), e);
        }
    }

    static class ProtocolConfigurationImpl
    implements ProtocolConfiguration {
        private final String name;
        private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
        private final Map<String, String> properties;

        ProtocolConfigurationImpl(String name, Map<String, String> defaults) {
            this.name = name;
            this.properties = defaults != null ? new HashMap<String, String>(defaults) : new HashMap();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }

        public Injector<SocketBinding> getSocketBindingInjector() {
            return this.socketBinding;
        }

        @Override
        public SocketBinding getSocketBinding() {
            return (SocketBinding)this.socketBinding.getOptionalValue();
        }
    }

    static class TransportConfigurationImpl
    extends ProtocolConfigurationImpl
    implements TransportConfiguration {
        private final InjectedValue<SocketBinding> diagnosticsSocketBinding = new InjectedValue();
        private final InjectedValue<Executor> defaultExecutor = new InjectedValue();
        private final InjectedValue<Executor> oobExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> timerExecutor = new InjectedValue();
        private final InjectedValue<ThreadFactory> threadFactory = new InjectedValue();
        private boolean shared = true;

        TransportConfigurationImpl(String name, Map<String, String> defaults) {
            super(name, defaults);
        }

        public Injector<SocketBinding> getDiagnosticsSocketBindingInjector() {
            return this.diagnosticsSocketBinding;
        }

        public Injector<Executor> getDefaultExecutorInjector() {
            return this.defaultExecutor;
        }

        public Injector<Executor> getOOBExecutorInjector() {
            return this.oobExecutor;
        }

        public Injector<ScheduledExecutorService> getTimerExecutorInjector() {
            return this.timerExecutor;
        }

        public Injector<ThreadFactory> getThreadFactoryInjector() {
            return this.threadFactory;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        public void setShared(boolean shared) {
            this.shared = shared;
        }

        @Override
        public SocketBinding getDiagnosticsSocketBinding() {
            return (SocketBinding)this.diagnosticsSocketBinding.getOptionalValue();
        }

        @Override
        public ExecutorService getDefaultExecutor() {
            Executor executor = (Executor)this.defaultExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ExecutorService getOOBExecutor() {
            Executor executor = (Executor)this.oobExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ScheduledExecutorService getTimerExecutor() {
            return (ScheduledExecutorService)this.timerExecutor.getOptionalValue();
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return (ThreadFactory)this.threadFactory.getOptionalValue();
        }
    }

    static class ProtocolStackConfigurationImpl
    implements ProtocolStackConfiguration {
        private final TransportConfiguration transport;
        private final List<ProtocolConfiguration> protocols = new LinkedList<ProtocolConfiguration>();

        ProtocolStackConfigurationImpl(TransportConfiguration transport) {
            this.transport = transport;
        }

        @Override
        public TransportConfiguration getTransport() {
            return this.transport;
        }

        @Override
        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }
    }

    static class InjectionCollector {
        List<Map.Entry<String, Injector<SocketBinding>>> socketBindingInjections = new LinkedList<Map.Entry<String, Injector<SocketBinding>>>();
        List<Map.Entry<String, Injector<Executor>>> executorInjections = new LinkedList<Map.Entry<String, Injector<Executor>>>();
        List<Map.Entry<String, Injector<ScheduledExecutorService>>> scheduledExecutorInjections = new LinkedList<Map.Entry<String, Injector<ScheduledExecutorService>>>();
        List<Map.Entry<String, Injector<ThreadFactory>>> threadFactoryInjections = new LinkedList<Map.Entry<String, Injector<ThreadFactory>>>();

        InjectionCollector() {
        }

        void addSocketBindingInjector(String name, Injector<SocketBinding> injector) {
            this.socketBindingInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<SocketBinding>>(name, injector));
        }

        void addExecutorInjector(String name, Injector<Executor> injector) {
            this.executorInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<Executor>>(name, injector));
        }

        void addScheduledExecutorInjector(String name, Injector<ScheduledExecutorService> injector) {
            this.scheduledExecutorInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<ScheduledExecutorService>>(name, injector));
        }

        void addThreadFactoryInjector(String name, Injector<ThreadFactory> injector) {
            this.threadFactoryInjections.add(new AbstractMap.SimpleImmutableEntry<String, Injector<ThreadFactory>>(name, injector));
        }

        void addDependencies(ServiceBuilder<?> builder) {
            for (Map.Entry<String, Injector<SocketBinding>> entry : this.socketBindingInjections) {
                builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{entry.getKey()}), SocketBinding.class, entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.executorInjections) {
                builder.addDependency(ThreadsServices.executorName((String)entry.getKey()), Executor.class, (Injector)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.scheduledExecutorInjections) {
                builder.addDependency(ThreadsServices.executorName((String)entry.getKey()), ScheduledExecutorService.class, (Injector)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.threadFactoryInjections) {
                builder.addDependency(ThreadsServices.threadFactoryName((String)entry.getKey()), ThreadFactory.class, (Injector)entry.getValue());
            }
        }
    }
}

