/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.bridge;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.sql.DataSource;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCTypeFactory;
import org.jboss.as.cmp.jdbc.LockingStrategy;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMP1xFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMP2xFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMP2xUpdatedPrincipalFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMP2xUpdatedTimeFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCKeyGenVersionFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCLongVersionFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCSelectorBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCTimestampVersionFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCAuditMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.logging.Logger;

public class JDBCEntityBridge
implements JDBCAbstractEntityBridge {
    public static final byte LOADED = 1;
    public static final byte LOAD_REQUIRED = 2;
    public static final byte DIRTY = 4;
    public static final byte CHECK_DIRTY = 8;
    public static final byte LOCKED = 16;
    public static final byte ADD_TO_SET_ON_UPDATE = 32;
    public static final byte ADD_TO_WHERE_ON_UPDATE = 64;
    private static final String DEFAULT_LOADGROUP_NAME = "*";
    private JDBCEntityMetaData metadata;
    private JDBCStoreManager manager;
    private DataSource dataSource;
    private String qualifiedTableName;
    private String tableName;
    private final String primaryKeyFieldName;
    private final Class<?> primaryKeyClass;
    private JDBCCMPFieldBridge[] primaryKeyFields;
    private JDBCCMPFieldBridge[] cmpFields;
    private JDBCCMRFieldBridge[] cmrFields;
    private JDBCCMPFieldBridge[] tableFields;
    private JDBCCMPFieldBridge versionField;
    private JDBCCMPFieldBridge createdPrincipalField;
    private JDBCCMPFieldBridge createdTimeField;
    private JDBCCMPFieldBridge updatedPrincipalField;
    private JDBCCMPFieldBridge updatedTimeField;
    private Map<Method, JDBCSelectorBridge> selectorsByMethod;
    private Map loadGroupMasks;
    private List lazyLoadGroupMasks;
    private boolean[] eagerLoadGroupMask;
    private boolean[] defaultLockGroupMask;
    private int jdbcContextSize;
    private final Logger log;
    public static final FieldIterator EMPTY_FIELD_ITERATOR = new FieldIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public JDBCCMPFieldBridge next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
        }
    };

    public JDBCEntityBridge(JDBCEntityMetaData metadata, JDBCStoreManager manager) throws Exception {
        this.metadata = metadata;
        this.manager = manager;
        this.primaryKeyFieldName = metadata.getPrimaryKeyFieldName();
        this.primaryKeyClass = metadata.getPrimaryKeyClass();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + metadata.getName()));
    }

    public void init() throws Exception {
        JDBCAuditMetaData auditMetaData;
        this.dataSource = this.manager.getDataSource(this.metadata.getDataSourceName());
        this.qualifiedTableName = SQLUtil.fixTableName(this.metadata.getDefaultTableName(), this.dataSource);
        int dotIndex = this.qualifiedTableName.indexOf(46);
        this.tableName = dotIndex == -1 ? this.qualifiedTableName : this.qualifiedTableName.substring(dotIndex + 1);
        this.loadCMPFields(this.metadata);
        this.loadCMRFields(this.metadata);
        JDBCOptimisticLockingMetaData lockMetaData = this.metadata.getOptimisticLocking();
        if (lockMetaData != null && lockMetaData.getLockingField() != null) {
            JDBCOptimisticLockingMetaData.LockingStrategy strategy = lockMetaData.getLockingStrategy();
            JDBCCMPFieldMetaData versionMD = lockMetaData.getLockingField();
            this.versionField = this.getCMPFieldByName(versionMD.getFieldName());
            boolean hidden = this.versionField == null;
            switch (strategy) {
                case VERSION_COLUMN_STRATEGY: {
                    if (hidden) {
                        this.versionField = new JDBCLongVersionFieldBridge(this.manager, versionMD);
                        break;
                    }
                    this.versionField = new JDBCLongVersionFieldBridge((JDBCCMP2xFieldBridge)this.versionField);
                    break;
                }
                case TIMESTAMP_COLUMN_STRATEGY: {
                    if (hidden) {
                        this.versionField = new JDBCTimestampVersionFieldBridge(this.manager, versionMD);
                        break;
                    }
                    this.versionField = new JDBCTimestampVersionFieldBridge((JDBCCMP2xFieldBridge)this.versionField);
                    break;
                }
                case KEYGENERATOR_COLUMN_STRATEGY: {
                    this.versionField = hidden ? new JDBCKeyGenVersionFieldBridge(this.manager, versionMD, lockMetaData.getKeyGeneratorFactory()) : new JDBCKeyGenVersionFieldBridge((JDBCCMP2xFieldBridge)this.versionField, lockMetaData.getKeyGeneratorFactory());
                }
            }
            if (hidden) {
                this.addCMPField(this.versionField);
            } else {
                this.tableFields[this.versionField.getTableIndex()] = this.versionField;
            }
        }
        if ((auditMetaData = this.metadata.getAudit()) != null) {
            JDBCCMPFieldMetaData auditField = auditMetaData.getCreatedPrincipalField();
            if (auditField != null) {
                this.createdPrincipalField = this.getCMPFieldByName(auditField.getFieldName());
                if (this.createdPrincipalField == null) {
                    this.createdPrincipalField = new JDBCCMP2xFieldBridge(this.manager, auditField);
                    this.addCMPField(this.createdPrincipalField);
                }
            } else {
                this.createdPrincipalField = null;
            }
            if ((auditField = auditMetaData.getCreatedTimeField()) != null) {
                this.createdTimeField = this.getCMPFieldByName(auditField.getFieldName());
                if (this.createdTimeField == null) {
                    this.createdTimeField = new JDBCCMP2xFieldBridge(this.manager, auditField, JDBCTypeFactory.EQUALS, false);
                    this.addCMPField(this.createdTimeField);
                } else {
                    this.tableFields[this.createdTimeField.getTableIndex()] = this.createdTimeField = new JDBCCMP2xFieldBridge((JDBCCMP2xFieldBridge)this.createdTimeField, JDBCTypeFactory.EQUALS, false);
                }
            } else {
                this.createdTimeField = null;
            }
            auditField = auditMetaData.getUpdatedPrincipalField();
            if (auditField != null) {
                this.updatedPrincipalField = this.getCMPFieldByName(auditField.getFieldName());
                if (this.updatedPrincipalField == null) {
                    this.updatedPrincipalField = new JDBCCMP2xUpdatedPrincipalFieldBridge(this.manager, auditField);
                    this.addCMPField(this.updatedPrincipalField);
                } else {
                    this.tableFields[this.updatedPrincipalField.getTableIndex()] = this.updatedPrincipalField = new JDBCCMP2xUpdatedPrincipalFieldBridge((JDBCCMP2xFieldBridge)this.updatedPrincipalField);
                }
            } else {
                this.updatedPrincipalField = null;
            }
            auditField = auditMetaData.getUpdatedTimeField();
            if (auditField != null) {
                this.updatedTimeField = this.getCMPFieldByName(auditField.getFieldName());
                if (this.updatedTimeField == null) {
                    this.updatedTimeField = new JDBCCMP2xUpdatedTimeFieldBridge(this.manager, auditField);
                    this.addCMPField(this.updatedTimeField);
                } else {
                    this.tableFields[this.updatedTimeField.getTableIndex()] = this.updatedTimeField = new JDBCCMP2xUpdatedTimeFieldBridge((JDBCCMP2xFieldBridge)this.updatedTimeField);
                }
            } else {
                this.updatedTimeField = null;
            }
        }
        this.loadSelectors(this.metadata);
    }

    public void resolveRelationships() {
        for (int i = 0; i < this.cmrFields.length; ++i) {
            this.cmrFields[i].resolveRelationship();
        }
        this.loadLoadGroups(this.metadata);
        this.loadEagerLoadGroup(this.metadata);
        this.loadLazyLoadGroups(this.metadata);
    }

    public void start() {
        for (int i = 0; i < this.cmrFields.length; ++i) {
            this.cmrFields[i].start();
        }
    }

    public boolean removeFromRelations(CmpEntityBeanContext ctx, Object[] oldRelations) {
        boolean removed = false;
        for (int i = 0; i < this.cmrFields.length; ++i) {
            if (!this.cmrFields[i].removeFromRelations(ctx, oldRelations)) continue;
            removed = true;
        }
        return removed;
    }

    public void cascadeDelete(CmpEntityBeanContext ctx, Map oldRelations) throws RemoveException, RemoteException {
        for (int i = 0; i < this.cmrFields.length; ++i) {
            JDBCCMRFieldBridge cmrField = this.cmrFields[i];
            Object value = oldRelations.get(cmrField);
            if (value == null) continue;
            cmrField.cascadeDelete(ctx, (List)value);
        }
    }

    @Override
    public String getEntityName() {
        return this.metadata.getName();
    }

    @Override
    public String getAbstractSchemaName() {
        return this.metadata.getAbstractSchemaName();
    }

    public Class getRemoteInterface() {
        return this.metadata.getRemoteClass();
    }

    public Class getLocalInterface() {
        return this.metadata.getLocalClass();
    }

    @Override
    public JDBCEntityMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public JDBCEntityPersistenceStore getManager() {
        return this.manager;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public int getListCacheMax() {
        return this.metadata.getListCacheMax();
    }

    public int getFetchSize() {
        return this.metadata.getFetchSize();
    }

    public Object createPrimaryKeyInstance() {
        if (this.primaryKeyFieldName == null) {
            try {
                return this.primaryKeyClass.newInstance();
            }
            catch (Exception e) {
                throw new EJBException("Error creating primary key instance: ", e);
            }
        }
        return null;
    }

    @Override
    public JDBCFieldBridge[] getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    @Override
    public List<FieldBridge> getFields() {
        int fieldsTotal = this.primaryKeyFields.length + this.cmpFields.length + this.cmrFields.length;
        FieldBridge[] fields = new FieldBridge[fieldsTotal];
        int position = 0;
        System.arraycopy(this.primaryKeyFields, 0, fields, position, this.primaryKeyFields.length);
        System.arraycopy(this.cmpFields, 0, fields, position += this.primaryKeyFields.length, this.cmpFields.length);
        System.arraycopy(this.cmrFields, 0, fields, position += this.cmpFields.length, this.cmrFields.length);
        return Arrays.asList(fields);
    }

    @Override
    public FieldBridge getFieldByName(String name) {
        JDBCFieldBridge field = null;
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            JDBCCMPFieldBridge primaryKeyField = this.primaryKeyFields[i];
            if (!primaryKeyField.getFieldName().equals(name)) continue;
            field = primaryKeyField;
            break;
        }
        if (field == null) {
            field = this.getCMPFieldByName(name);
        }
        if (field == null) {
            field = this.getCMRFieldByName(name);
        }
        return field;
    }

    public boolean[] getEagerLoadMask() {
        return this.eagerLoadGroupMask;
    }

    public Iterator getLazyLoadGroupMasks() {
        return this.lazyLoadGroupMasks.iterator();
    }

    @Override
    public boolean[] getLoadGroupMask(String name) {
        boolean[] mask = (boolean[])this.loadGroupMasks.get(name);
        if (mask == null) {
            throw new IllegalStateException("Load group '" + name + "' is not defined. Defined load groups: " + this.loadGroupMasks.keySet());
        }
        return mask;
    }

    public FieldIterator getLoadIterator(JDBCCMPFieldBridge requiredField, JDBCReadAheadMetaData readahead, CmpEntityBeanContext ctx) {
        FieldIterator loadIter;
        int i;
        boolean[] loadGroup;
        if (requiredField == null) {
            if (readahead != null && !readahead.isNone()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Eager-load for entity: readahead=" + readahead));
                }
                loadGroup = this.getLoadGroupMask(readahead.getEagerLoadGroup());
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Default eager-load for entity: readahead=" + readahead));
                }
                loadGroup = this.eagerLoadGroupMask;
            }
        } else {
            loadGroup = new boolean[this.tableFields.length];
            int requiredInd = requiredField.getTableIndex();
            loadGroup[requiredInd] = true;
            for (boolean[] lazyGroup : this.lazyLoadGroupMasks) {
                if (!lazyGroup[requiredInd]) continue;
                for (i = 0; i < loadGroup.length; ++i) {
                    loadGroup[i] = loadGroup[i] || lazyGroup[i];
                }
            }
        }
        if (loadGroup != null) {
            int fieldsToLoad = 0;
            EntityState entityState = JDBCEntityBridge.getEntityState(ctx);
            for (i = 0; i < this.tableFields.length; ++i) {
                JDBCCMPFieldBridge field = this.tableFields[i];
                if (!loadGroup[i] || field.isPrimaryKeyMember() || field.isLoaded(ctx)) continue;
                entityState.setLoadRequired(i);
                ++fieldsToLoad;
            }
            loadIter = fieldsToLoad > 0 ? entityState.getLoadIterator(ctx) : EMPTY_FIELD_ITERATOR;
        } else {
            loadIter = EMPTY_FIELD_ITERATOR;
        }
        return loadIter;
    }

    public JDBCCMPFieldBridge getCMPFieldByName(String name) {
        JDBCCMPFieldBridge cmpField;
        int i;
        for (i = 0; i < this.primaryKeyFields.length; ++i) {
            cmpField = this.primaryKeyFields[i];
            if (!cmpField.getFieldName().equals(name)) continue;
            return cmpField;
        }
        for (i = 0; i < this.cmpFields.length; ++i) {
            cmpField = this.cmpFields[i];
            if (!cmpField.getFieldName().equals(name)) continue;
            return cmpField;
        }
        return null;
    }

    @Override
    public JDBCAbstractCMRFieldBridge[] getCMRFields() {
        return this.cmrFields;
    }

    public JDBCCMRFieldBridge getCMRFieldByName(String name) {
        for (int i = 0; i < this.cmrFields.length; ++i) {
            JDBCCMRFieldBridge cmrField = this.cmrFields[i];
            if (!cmrField.getFieldName().equals(name)) continue;
            return cmrField;
        }
        return null;
    }

    public JDBCCMPFieldBridge getVersionField() {
        return this.versionField;
    }

    public JDBCCMPFieldBridge getCreatedPrincipalField() {
        return this.createdPrincipalField;
    }

    public JDBCCMPFieldBridge getCreatedTimeField() {
        return this.createdTimeField;
    }

    public JDBCCMPFieldBridge getUpdatedPrincipalField() {
        return this.updatedPrincipalField;
    }

    public JDBCCMPFieldBridge getUpdatedTimeField() {
        return this.updatedTimeField;
    }

    public Collection<JDBCSelectorBridge> getSelectors() {
        return this.selectorsByMethod.values();
    }

    public void initInstance(CmpEntityBeanContext ctx) {
        int i;
        for (i = 0; i < this.tableFields.length; ++i) {
            this.tableFields[i].initInstance(ctx);
        }
        for (i = 0; i < this.cmrFields.length; ++i) {
            JDBCCMRFieldBridge cmrField = this.cmrFields[i];
            cmrField.initInstance(ctx);
        }
    }

    public static boolean isEjbCreateDone(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).ejbCreateDone;
    }

    public static void setCreated(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.getEntityState(ctx).setCreated();
    }

    public static void setEjbCreateDone(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.getEntityState(ctx).ejbCreateDone = true;
    }

    public boolean isModified(CmpEntityBeanContext ctx) {
        boolean invalidateCache = false;
        EntityState entityState = JDBCEntityBridge.getEntityState(ctx);
        if (entityState.isCreated() && !(invalidateCache = this.areCmpFieldsDirty(ctx, entityState))) {
            for (int i = 0; i < this.cmrFields.length; ++i) {
                if (!this.cmrFields[i].invalidateCache(ctx)) continue;
                invalidateCache = true;
                break;
            }
        }
        return invalidateCache;
    }

    public boolean isStoreRequired(CmpEntityBeanContext ctx) {
        boolean modified = false;
        EntityState entityState = JDBCEntityBridge.getEntityState(ctx);
        if (entityState.isCreated() && !(modified = this.areCmpFieldsDirty(ctx, entityState))) {
            for (int i = 0; i < this.cmrFields.length; ++i) {
                if (!this.cmrFields[i].isDirty(ctx)) continue;
                modified = true;
                break;
            }
        }
        return modified;
    }

    private boolean areCmpFieldsDirty(CmpEntityBeanContext ctx, EntityState entityState) {
        for (int i = 0; i < this.tableFields.length; ++i) {
            JDBCCMPFieldBridge field = this.tableFields[i];
            if (!entityState.isCheckDirty(i) || !field.isDirty(ctx)) continue;
            return true;
        }
        return false;
    }

    public FieldIterator getDirtyIterator(CmpEntityBeanContext ctx) {
        int dirtyFields = 0;
        EntityState entityState = JDBCEntityBridge.getEntityState(ctx);
        for (int i = 0; i < this.tableFields.length; ++i) {
            JDBCCMPFieldBridge field = this.tableFields[i];
            if (!entityState.isCheckDirty(i) || !field.isDirty(ctx)) continue;
            entityState.setUpdateRequired(i);
            ++dirtyFields;
        }
        return dirtyFields > 0 ? JDBCEntityBridge.getEntityState(ctx).getDirtyIterator(ctx) : EMPTY_FIELD_ITERATOR;
    }

    public boolean hasLockedFields(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).hasLockedFields();
    }

    public FieldIterator getLockedIterator(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).getLockedIterator(ctx);
    }

    public void initPersistenceContext(CmpEntityBeanContext ctx) {
        ctx.setPersistenceContext(new JDBCContext(this.jdbcContextSize, new EntityState()));
    }

    public void resetPersistenceContext(CmpEntityBeanContext ctx) {
        int i;
        for (i = 0; i < this.primaryKeyFields.length; ++i) {
            this.primaryKeyFields[i].resetPersistenceContext(ctx);
        }
        for (i = 0; i < this.cmpFields.length; ++i) {
            this.cmpFields[i].resetPersistenceContext(ctx);
        }
        for (i = 0; i < this.cmrFields.length; ++i) {
            this.cmrFields[i].resetPersistenceContext(ctx);
        }
    }

    public static void destroyPersistenceContext(CmpEntityBeanContext ctx) {
        ctx.setPersistenceContext(null);
    }

    public int setPrimaryKeyParameters(PreparedStatement ps, int parameterIndex, Object primaryKey) {
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            parameterIndex = this.primaryKeyFields[i].setPrimaryKeyParameters(ps, parameterIndex, primaryKey);
        }
        return parameterIndex;
    }

    public int loadPrimaryKeyResults(ResultSet rs, int parameterIndex, Object[] pkRef) {
        pkRef[0] = this.createPrimaryKeyInstance();
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            parameterIndex = this.primaryKeyFields[i].loadPrimaryKeyResults(rs, parameterIndex, pkRef);
        }
        return parameterIndex;
    }

    public Object extractPrimaryKeyFromInstance(CmpEntityBeanContext ctx) {
        try {
            Object pk = null;
            for (int i = 0; i < this.primaryKeyFields.length; ++i) {
                JDBCCMPFieldBridge pkField = this.primaryKeyFields[i];
                Object fieldValue = pkField.getInstanceValue(ctx);
                pk = pkField.setPrimaryKeyValue(pk, fieldValue);
            }
            return pk;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Internal error extracting primary key from instance", e);
        }
    }

    public void injectPrimaryKeyIntoInstance(CmpEntityBeanContext ctx, Object pk) {
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            JDBCCMPFieldBridge pkField = this.primaryKeyFields[i];
            Object fieldValue = pkField.getPrimaryKeyValue(pk);
            pkField.setInstanceValue(ctx, fieldValue);
        }
    }

    int getNextJDBCContextIndex() {
        return this.jdbcContextSize++;
    }

    int addTableField(JDBCCMPFieldBridge field) {
        JDBCCMPFieldBridge[] tmpFields = this.tableFields;
        if (this.tableFields == null) {
            this.tableFields = new JDBCCMPFieldBridge[1];
        } else {
            this.tableFields = new JDBCCMPFieldBridge[this.tableFields.length + 1];
            System.arraycopy(tmpFields, 0, this.tableFields, 0, tmpFields.length);
        }
        int index = this.tableFields.length - 1;
        this.tableFields[index] = field;
        return index;
    }

    @Override
    public JDBCFieldBridge[] getTableFields() {
        return this.tableFields;
    }

    public void setRemoved(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.getEntityState(ctx).setRemoved();
    }

    public boolean isRemoved(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).isRemoved();
    }

    public void setIsBeingRemoved(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.getEntityState(ctx).setIsBeingRemoved();
    }

    public boolean isBeingRemoved(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).isBeingRemoved();
    }

    public void scheduleForCascadeDelete(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.getEntityState(ctx).scheduleForCascadeDelete();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Scheduled for cascade-delete: " + ctx.getPrimaryKey()));
        }
    }

    public boolean isScheduledForCascadeDelete(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).isScheduledForCascadeDelete();
    }

    public void scheduleForBatchCascadeDelete(CmpEntityBeanContext ctx) {
        JDBCEntityBridge.getEntityState(ctx).scheduleForBatchCascadeDelete();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Scheduled for batch-cascade-delete: " + ctx.getPrimaryKey()));
        }
    }

    public boolean isScheduledForBatchCascadeDelete(CmpEntityBeanContext ctx) {
        return JDBCEntityBridge.getEntityState(ctx).isScheduledForBatchCascadeDelete();
    }

    private static EntityState getEntityState(CmpEntityBeanContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        EntityState entityState = jdbcCtx.getEntityState();
        if (entityState == null) {
            throw new IllegalStateException("Entity state is null.");
        }
        return entityState;
    }

    private void loadCMPFields(JDBCEntityMetaData metadata) {
        List<JDBCCMPFieldMetaData> cmpFieldsMD = metadata.getCMPFields();
        ArrayList<JDBCCMPFieldBridge> cmpFieldsList = new ArrayList<JDBCCMPFieldBridge>();
        ArrayList<JDBCCMPFieldBridge> pkFieldsList = new ArrayList<JDBCCMPFieldBridge>();
        for (JDBCCMPFieldMetaData fieldMD : cmpFieldsMD) {
            JDBCCMPFieldBridge cmpField = this.createCMPField(metadata, fieldMD);
            if (fieldMD.isPrimaryKeyMember()) {
                pkFieldsList.add(cmpField);
                continue;
            }
            cmpFieldsList.add(cmpField);
        }
        this.primaryKeyFields = pkFieldsList.toArray(new JDBCCMPFieldBridge[pkFieldsList.size()]);
        this.cmpFields = cmpFieldsList.toArray(new JDBCCMPFieldBridge[cmpFieldsList.size()]);
    }

    private void loadCMRFields(JDBCEntityMetaData metadata) {
        this.cmrFields = new JDBCCMRFieldBridge[metadata.getRelationshipRoles().size()];
        int cmrFieldIndex = 0;
        for (JDBCRelationshipRoleMetaData relationshipRole : metadata.getRelationshipRoles()) {
            JDBCCMRFieldBridge cmrField = new JDBCCMRFieldBridge(this, this.manager, relationshipRole);
            this.cmrFields[cmrFieldIndex++] = cmrField;
        }
    }

    private void loadLoadGroups(JDBCEntityMetaData metadata) {
        this.loadGroupMasks = new HashMap();
        JDBCOptimisticLockingMetaData olMD = metadata.getOptimisticLocking();
        if (olMD != null) {
            if (this.versionField != null) {
                this.defaultLockGroupMask = new boolean[this.tableFields.length];
                this.defaultLockGroupMask[this.versionField.getTableIndex()] = true;
                this.versionField.setLockingStrategy(LockingStrategy.VERSION);
            } else if (olMD.getGroupName() != null) {
                this.defaultLockGroupMask = this.loadGroupMask(olMD.getGroupName(), null);
                for (int i = 0; i < this.tableFields.length; ++i) {
                    if (!this.defaultLockGroupMask[i]) continue;
                    JDBCCMPFieldBridge tableField = this.tableFields[i];
                    tableField.setLockingStrategy(LockingStrategy.GROUP);
                    tableField.addDefaultFlag((byte)64);
                }
            } else {
                LockingStrategy strategy = olMD.getLockingStrategy() == JDBCOptimisticLockingMetaData.LockingStrategy.READ_STRATEGY ? LockingStrategy.READ : LockingStrategy.MODIFIED;
                for (int i = 0; i < this.tableFields.length; ++i) {
                    JDBCCMPFieldBridge field = this.tableFields[i];
                    if (field.isPrimaryKeyMember()) continue;
                    field.setLockingStrategy(strategy);
                }
            }
        }
        boolean[] defaultLoadGroup = new boolean[this.tableFields.length];
        Arrays.fill(defaultLoadGroup, true);
        for (int i = 0; i < this.primaryKeyFields.length; ++i) {
            int tableIndex = this.primaryKeyFields[i].getTableIndex();
            defaultLoadGroup[tableIndex] = false;
        }
        this.loadGroupMasks.put(DEFAULT_LOADGROUP_NAME, defaultLoadGroup);
        for (String groupName : metadata.getLoadGroups().keySet()) {
            boolean[] loadGroup = this.loadGroupMask(groupName, this.defaultLockGroupMask);
            this.loadGroupMasks.put(groupName, loadGroup);
        }
        this.loadGroupMasks = Collections.unmodifiableMap(this.loadGroupMasks);
    }

    private boolean[] loadGroupMask(String groupName, boolean[] defaultGroup) {
        List<String> fieldNames = this.metadata.getLoadGroup(groupName);
        boolean[] group = new boolean[this.tableFields.length];
        if (defaultGroup != null) {
            System.arraycopy(defaultGroup, 0, group, 0, group.length);
        }
        for (String fieldName : fieldNames) {
            JDBCFieldBridge field = (JDBCFieldBridge)this.getFieldByName(fieldName);
            if (field == null) {
                throw new RuntimeException("Field " + fieldName + " not found for entity " + this.getEntityName());
            }
            if (field instanceof JDBCCMRFieldBridge) {
                JDBCCMRFieldBridge cmrField = (JDBCCMRFieldBridge)field;
                if (cmrField.hasForeignKey()) {
                    JDBCCMPFieldBridge[] fkFields = (JDBCCMPFieldBridge[])cmrField.getForeignKeyFields();
                    for (int i = 0; i < fkFields.length; ++i) {
                        group[fkFields[i].getTableIndex()] = true;
                    }
                    continue;
                }
                throw new RuntimeException("Only CMR fields that have a foreign-key may be a member of a load group: fieldName=" + fieldName);
            }
            group[((JDBCCMPFieldBridge)field).getTableIndex()] = true;
        }
        return group;
    }

    private void loadEagerLoadGroup(JDBCEntityMetaData metadata) {
        String eagerLoadGroupName = metadata.getEagerLoadGroup();
        this.eagerLoadGroupMask = eagerLoadGroupName == null ? this.defaultLockGroupMask : (boolean[])this.loadGroupMasks.get(eagerLoadGroupName);
    }

    private void loadLazyLoadGroups(JDBCEntityMetaData metadata) {
        List<String> lazyGroupNames = metadata.getLazyLoadGroups();
        this.lazyLoadGroupMasks = new ArrayList(lazyGroupNames.size());
        for (String lazyLoadGroupName : lazyGroupNames) {
            this.lazyLoadGroupMasks.add(this.loadGroupMasks.get(lazyLoadGroupName));
        }
        this.lazyLoadGroupMasks = Collections.unmodifiableList(this.lazyLoadGroupMasks);
    }

    private JDBCCMPFieldBridge createCMPField(JDBCEntityMetaData metadata, JDBCCMPFieldMetaData cmpFieldMetaData) {
        JDBCAbstractCMPFieldBridge cmpField = metadata.isCMP1x() ? new JDBCCMP1xFieldBridge(this.manager, cmpFieldMetaData) : new JDBCCMP2xFieldBridge(this.manager, cmpFieldMetaData);
        return cmpField;
    }

    private void loadSelectors(JDBCEntityMetaData metadata) {
        this.selectorsByMethod = new HashMap<Method, JDBCSelectorBridge>(metadata.getQueries().size());
        for (JDBCQueryMetaData q : this.manager.getMetaData().getQueries()) {
            if (!q.getMethod().getName().startsWith("ejbSelect")) continue;
            this.selectorsByMethod.put(q.getMethod(), new JDBCSelectorBridge(this.manager, q));
        }
        this.selectorsByMethod = Collections.unmodifiableMap(this.selectorsByMethod);
    }

    private void addCMPField(JDBCCMPFieldBridge field) {
        JDBCCMPFieldBridge[] tmpCMPFields = this.cmpFields;
        this.cmpFields = new JDBCCMPFieldBridge[this.cmpFields.length + 1];
        System.arraycopy(tmpCMPFields, 0, this.cmpFields, 0, tmpCMPFields.length);
        this.cmpFields[tmpCMPFields.length] = field;
    }

    public static interface FieldIterator {
        public boolean hasNext();

        public JDBCCMPFieldBridge next();

        public void remove();

        public void removeAll();

        public void reset();
    }

    public class EntityState {
        private static final byte REMOVED = 1;
        private static final byte SCHEDULED_FOR_CASCADE_DELETE = 2;
        private static final byte SCHEDULED_FOR_BATCH_CASCADE_DELETE = 4;
        private static final byte IS_BEING_REMOVED = 8;
        private boolean ejbCreateDone = false;
        private boolean ejbPostCreateDone = false;
        private byte entityFlags;
        private final byte[] fieldFlags = new byte[JDBCEntityBridge.access$100(JDBCEntityBridge.this).length];

        public EntityState() {
            for (int i = 0; i < JDBCEntityBridge.this.tableFields.length; ++i) {
                this.fieldFlags[i] = JDBCEntityBridge.this.tableFields[i].getDefaultFlags();
            }
        }

        public void setRemoved() {
            this.entityFlags = (byte)(this.entityFlags | 1);
            this.entityFlags = (byte)(this.entityFlags & 0xFFFFFFF1);
        }

        public boolean isRemoved() {
            return (this.entityFlags & 1) > 0;
        }

        public void setIsBeingRemoved() {
            this.entityFlags = (byte)(this.entityFlags | 8);
        }

        public boolean isBeingRemoved() {
            return (this.entityFlags & 8) > 0;
        }

        public void scheduleForCascadeDelete() {
            this.entityFlags = (byte)(this.entityFlags | 2);
        }

        public boolean isScheduledForCascadeDelete() {
            return (this.entityFlags & 2) > 0;
        }

        public void scheduleForBatchCascadeDelete() {
            this.entityFlags = (byte)(this.entityFlags | 6);
        }

        public boolean isScheduledForBatchCascadeDelete() {
            return (this.entityFlags & 4) > 0;
        }

        public void setCreated() {
            this.ejbCreateDone = true;
            this.ejbPostCreateDone = true;
        }

        public boolean isCreated() {
            return this.ejbCreateDone && this.ejbPostCreateDone;
        }

        public boolean isLoaded(int fieldIndex) {
            return (this.fieldFlags[fieldIndex] & 1) > 0;
        }

        public void setLoaded(int fieldIndex) {
            int n = fieldIndex;
            this.fieldFlags[n] = (byte)(this.fieldFlags[n] | 1);
        }

        public void setLoadRequired(int fieldIndex) {
            int n = fieldIndex;
            this.fieldFlags[n] = (byte)(this.fieldFlags[n] | 2);
        }

        public void setUpdateRequired(int fieldIndex) {
            int n = fieldIndex;
            this.fieldFlags[n] = (byte)(this.fieldFlags[n] | 4);
        }

        public void setCheckDirty(int fieldIndex) {
            int n = fieldIndex;
            this.fieldFlags[n] = (byte)(this.fieldFlags[n] | 8);
        }

        public boolean isCheckDirty(int fieldIndex) {
            return (this.fieldFlags[fieldIndex] & 8) > 0;
        }

        public void setClean(int fieldIndex) {
            int n = fieldIndex;
            this.fieldFlags[n] = (byte)(this.fieldFlags[n] & 0xFFFFFFE3);
        }

        public void resetFlags(int fieldIndex) {
            this.fieldFlags[fieldIndex] = JDBCEntityBridge.this.tableFields[fieldIndex].getDefaultFlags();
        }

        public FieldIterator getDirtyIterator(CmpEntityBeanContext ctx) {
            return new MaskFieldIterator(36);
        }

        public boolean hasLockedFields() {
            boolean result = false;
            for (int i = 0; i < this.fieldFlags.length; ++i) {
                if ((this.fieldFlags[i] & 0x50) <= 0) continue;
                result = true;
                break;
            }
            return result;
        }

        public FieldIterator getLockedIterator(CmpEntityBeanContext ctx) {
            return new MaskFieldIterator(80);
        }

        public boolean lockValue(int fieldIndex) {
            boolean lock = false;
            byte fieldFlag = this.fieldFlags[fieldIndex];
            if ((fieldFlag & 1) > 0 && (fieldFlag & 0x10) == 0) {
                int n = fieldIndex;
                this.fieldFlags[n] = (byte)(this.fieldFlags[n] | 0x10);
                lock = true;
            }
            return lock;
        }

        public FieldIterator getLoadIterator(CmpEntityBeanContext ctx) {
            return new MaskFieldIterator(2);
        }

        private class MaskFieldIterator
        implements FieldIterator {
            private final byte flagMask;
            private int nextIndex = 0;
            private int curIndex = -1;

            public MaskFieldIterator(byte flagMask) {
                this.flagMask = flagMask;
            }

            @Override
            public boolean hasNext() {
                while (this.nextIndex < EntityState.this.fieldFlags.length) {
                    if ((EntityState.this.fieldFlags[this.nextIndex] & this.flagMask) > 0) {
                        return true;
                    }
                    ++this.nextIndex;
                }
                return false;
            }

            @Override
            public JDBCCMPFieldBridge next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.curIndex = this.nextIndex;
                return JDBCEntityBridge.this.tableFields[this.nextIndex++];
            }

            @Override
            public void remove() {
                byte[] byArray = EntityState.this.fieldFlags;
                int n = this.curIndex;
                byArray[n] = (byte)(byArray[n] & ~this.flagMask);
            }

            @Override
            public void removeAll() {
                int inversedMask = ~this.flagMask;
                int i = 0;
                while (i < EntityState.this.fieldFlags.length) {
                    byte[] byArray = EntityState.this.fieldFlags;
                    int n = i++;
                    byArray[n] = (byte)(byArray[n] & inversedMask);
                }
            }

            @Override
            public void reset() {
                this.nextIndex = 0;
                this.curIndex = -1;
            }
        }
    }
}

