/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2.schema;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.as.cmp.jdbc2.schema.Cache;

public class TableCache
implements Cache {
    private Cache.Listener listener = Cache.Listener.NOOP;
    private final Map rowsById;
    private CachedRow head;
    private CachedRow tail;
    private int maxCapacity;
    private final int minCapacity;
    private boolean locked;
    private final int partitionIndex;

    public TableCache(int partitionIndex, int initialCapacity, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.minCapacity = initialCapacity;
        this.rowsById = new HashMap(initialCapacity);
        this.partitionIndex = partitionIndex;
    }

    public void registerListener(Cache.Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock();
        try {
            int n = this.rowsById.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public int getMinCapacity() {
        return this.minCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void lock() {
        boolean intr = false;
        try {
            if (this.locked) {
                long start = System.currentTimeMillis();
                while (this.locked) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
                this.listener.contention(this.partitionIndex, System.currentTimeMillis() - start);
            }
            this.locked = true;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void lock(Object key) {
        this.lock();
    }

    @Override
    public synchronized void unlock() {
        if (!this.locked) {
            throw new IllegalStateException("The instance is not locked!");
        }
        this.locked = false;
        this.notify();
    }

    @Override
    public void unlock(Object key) {
        this.unlock();
    }

    @Override
    public Object[] getFields(Object pk) {
        Object[] fields;
        CachedRow row = (CachedRow)this.rowsById.get(pk);
        if (row != null && row.locker == null) {
            this.promoteRow(row);
            fields = new Object[row.fields.length];
            System.arraycopy(row.fields, 0, fields, 0, fields.length);
            this.listener.hit(this.partitionIndex);
        } else {
            fields = null;
            this.listener.miss(this.partitionIndex);
        }
        return fields;
    }

    @Override
    public Object[] getRelations(Object pk) {
        Object[] relations;
        CachedRow row = (CachedRow)this.rowsById.get(pk);
        if (row != null && row.relations != null && row.locker == null) {
            this.promoteRow(row);
            relations = new Object[row.relations.length];
            System.arraycopy(row.relations, 0, relations, 0, relations.length);
        } else {
            relations = null;
        }
        return relations;
    }

    @Override
    public void put(Transaction tx, Object pk, Object[] fields, Object[] relations) {
        CachedRow row = (CachedRow)this.rowsById.get(pk);
        if (row == null) {
            Object[] fieldsCopy = new Object[fields.length];
            System.arraycopy(fields, 0, fieldsCopy, 0, fields.length);
            row = new CachedRow(pk, fieldsCopy);
            if (relations != null) {
                Object[] relationsCopy = new Object[relations.length];
                System.arraycopy(relations, 0, relationsCopy, 0, relations.length);
                row.relations = relationsCopy;
            }
            this.rowsById.put(pk, row);
            if (this.head == null) {
                this.head = row;
                this.tail = row;
            } else {
                this.head.prev = row;
                row.next = this.head;
                this.head = row;
            }
        } else if (row.locker == null || row.locker.equals(tx)) {
            this.promoteRow(row);
            System.arraycopy(fields, 0, row.fields, 0, fields.length);
            if (relations != null) {
                if (row.relations == null) {
                    row.relations = new Object[relations.length];
                }
                System.arraycopy(relations, 0, row.relations, 0, relations.length);
            }
            row.lastUpdated = System.currentTimeMillis();
            row.locker = null;
        }
        CachedRow victim = this.tail;
        while (this.rowsById.size() > this.maxCapacity && victim != null) {
            CachedRow nextVictim = victim.prev;
            if (victim.locker == null) {
                this.dereference(victim);
                this.rowsById.remove(victim.pk);
                this.listener.eviction(this.partitionIndex, row.pk, this.rowsById.size());
            }
            victim = nextVictim;
        }
    }

    public void ageOut(long lastUpdated) {
        CachedRow victim = this.tail;
        while (victim != null && victim.lastUpdated < lastUpdated) {
            CachedRow nextVictim = victim.prev;
            if (victim.locker == null) {
                this.dereference(victim);
                this.rowsById.remove(victim.pk);
                this.listener.eviction(this.partitionIndex, victim.pk, this.rowsById.size());
            }
            victim = nextVictim;
        }
    }

    @Override
    public void remove(Transaction tx, Object pk) {
        CachedRow row = (CachedRow)this.rowsById.remove(pk);
        if (row == null || row.locker != null && !tx.equals(row.locker)) {
            String msg = "removal of " + pk + " rejected for " + tx + ": " + (row == null ? "the entry could not be found" : "the entry is locked for update by " + row.locker);
            throw new Cache.RemoveException(msg);
        }
        this.dereference(row);
        row.locker = null;
    }

    @Override
    public boolean contains(Transaction tx, Object pk) {
        CachedRow row = (CachedRow)this.rowsById.get(pk);
        return row != null && (row.locker == null || tx.equals(row.locker));
    }

    @Override
    public void lockForUpdate(Transaction tx, Object pk) throws Exception {
        CachedRow row = (CachedRow)this.rowsById.get(pk);
        if (row != null) {
            if (row.locker != null && !tx.equals(row.locker)) {
                throw new Exception("lock acquisition rejected for " + tx + ", the entry is locked for update by " + row.locker + ", id=" + pk);
            }
            row.locker = tx;
        }
    }

    @Override
    public void releaseLock(Transaction tx, Object pk) throws Exception {
        CachedRow row = (CachedRow)this.rowsById.get(pk);
        if (row != null) {
            if (!tx.equals(row.locker)) {
                throw new Exception("rejected to release lock for " + tx + ", the entry is locked for update by " + row.locker + ", id=" + pk);
            }
            row.locker = null;
        }
    }

    @Override
    public void flush() {
        this.rowsById.clear();
        this.head = null;
        this.tail = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        try {
            this.lock();
            CachedRow cursor = this.head;
            while (cursor != null) {
                buf.append('(').append(cursor.pk).append('|');
                for (int i = 0; i < cursor.fields.length; ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(cursor.fields[i]);
                }
                buf.append(')');
                cursor = cursor.next;
            }
        }
        finally {
            this.unlock();
        }
        buf.append(']');
        return buf.toString();
    }

    private void dereference(CachedRow row) {
        CachedRow next = row.next;
        CachedRow prev = row.prev;
        if (row == this.head) {
            this.head = next;
        }
        if (row == this.tail) {
            this.tail = prev;
        }
        if (next != null) {
            next.prev = prev;
        }
        if (prev != null) {
            prev.next = next;
        }
        row.next = null;
        row.prev = null;
    }

    private void promoteRow(CachedRow row) {
        if (this.head == null) {
            this.head = row;
            this.tail = row;
        } else if (row != this.head) {
            if (row == this.tail) {
                this.tail = row.prev;
                this.tail.next = null;
                row.prev = null;
                row.next = this.head;
                this.head.prev = row;
                this.head = row;
            } else {
                CachedRow next = row.next;
                CachedRow prev = row.prev;
                if (prev != null) {
                    prev.next = next;
                }
                if (next != null) {
                    next.prev = prev;
                }
                this.head.prev = row;
                row.next = this.head;
                row.prev = null;
                this.head = row;
            }
        }
    }

    private class CachedRow {
        public final Object pk;
        public final Object[] fields;
        public Object[] relations;
        private Transaction locker;
        private CachedRow next;
        private CachedRow prev;
        public long lastUpdated = System.currentTimeMillis();

        public CachedRow(Object pk, Object[] fields) {
            this.pk = pk;
            this.fields = fields;
        }
    }
}

