/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import java.util.zip.CRC32;
import javax.sql.DataSource;
import org.jboss.as.cmp.jdbc.JDBCType;
import org.jboss.as.cmp.jdbc.JDBCUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.logging.Logger;

public final class SQLUtil {
    public static final String EMPTY_STRING = "";
    public static final String INSERT_INTO = "INSERT INTO ";
    public static final String VALUES = " VALUES ";
    public static final String SELECT = "SELECT ";
    public static final String DISTINCT = "DISTINCT ";
    public static final String FROM = " FROM ";
    public static final String WHERE = " WHERE ";
    public static final String ORDERBY = " ORDER BY ";
    public static final String DELETE_FROM = "DELETE FROM ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String NOT = " NOT ";
    public static final String EXISTS = "EXISTS ";
    public static final String COMMA = ", ";
    public static final String LEFT_JOIN = " LEFT JOIN ";
    public static final String LEFT_OUTER_JOIN = " LEFT OUTER JOIN ";
    public static final String ON = " ON ";
    public static final String NOT_EQUAL = "<>";
    public static final String CREATE_TABLE = "CREATE TABLE ";
    public static final String DROP_TABLE = "DROP TABLE ";
    public static final String CREATE_INDEX = "CREATE INDEX ";
    public static final String NULL = "NULL";
    public static final String IS = " IS ";
    public static final String IN = " IN ";
    public static final String EMPTY = "EMPTY";
    public static final String BETWEEN = " BETWEEN ";
    public static final String LIKE = " LIKE ";
    public static final String MEMBER_OF = " MEMBER OF ";
    public static final String CONCAT = "CONCAT";
    public static final String SUBSTRING = "SUBSTRING";
    public static final String LCASE = "LCASE";
    public static final String UCASE = "UCASE";
    public static final String LENGTH = "LENGTH";
    public static final String LOCATE = "LOCATE";
    public static final String ABS = "ABS";
    public static final String MOD = "MOD";
    public static final String SQRT = "SQRT";
    public static final String COUNT = "COUNT";
    public static final String MAX = "MAX";
    public static final String MIN = "MIN";
    public static final String AVG = "AVG";
    public static final String SUM = "SUM";
    public static final String ASC = " ASC";
    public static final String DESC = " DESC";
    public static final String OFFSET = " OFFSET ";
    public static final String LIMIT = " LIMIT ";
    public static final String UPDATE = "UPDATE ";
    public static final String SET = " SET ";
    public static final String TYPE = " TYPE ";
    private static final String DOT = ".";
    private static final String EQ_QUESTMARK = "=?";
    private static final Vector rwords = new Vector();

    public static String getTableNameWithoutSchema(String tableName) {
        int dot = tableName.indexOf(46);
        if (dot != -1) {
            char firstChar = tableName.charAt(0);
            tableName = tableName.substring(dot + 1);
            if (firstChar == '\"' || firstChar == '\'') {
                tableName = firstChar + tableName;
            }
        }
        return tableName;
    }

    public static String getSchema(String tableName) {
        String schema = null;
        int dot = tableName.indexOf(46);
        if (dot != -1) {
            char firstChar = tableName.charAt(0);
            boolean quoted = firstChar == '\"' || firstChar == '\'';
            schema = tableName.substring(quoted ? 1 : 0, dot);
        }
        return schema;
    }

    public static String fixTableName(String tableName, DataSource dataSource) {
        char firstChar = tableName.charAt(0);
        if (firstChar == '\"' || firstChar == '\'') {
            return tableName;
        }
        String strSchema = EMPTY_STRING;
        int iIndex = tableName.indexOf(46);
        if (iIndex != -1) {
            strSchema = tableName.substring(0, iIndex);
            tableName = tableName.substring(iIndex + 1);
        }
        if (rwords != null) {
            for (int i = 0; i < rwords.size(); ++i) {
                if (!((String)rwords.elementAt(i)).equalsIgnoreCase(tableName)) continue;
                tableName = "X" + tableName;
                break;
            }
        }
        Connection con = null;
        try {
            con = dataSource.getConnection();
            DatabaseMetaData dmd = con.getMetaData();
            int maxLength = dmd.getMaxTableNameLength();
            if (maxLength > 0 && tableName.length() > maxLength) {
                CRC32 crc = new CRC32();
                crc.update(tableName.getBytes());
                String nameCRC = Long.toString(crc.getValue(), 36);
                tableName = tableName.substring(0, maxLength - nameCRC.length() - 2);
                tableName = tableName + "_" + nameCRC;
            }
            if (dmd.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            if (strSchema.length() > 0) {
                tableName = strSchema + DOT + tableName;
            }
            String string = tableName;
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while fixing table name", e);
        }
        finally {
            JDBCUtil.safeClose(con);
        }
    }

    public static void addToRwords(String word) {
        if (!rwords.contains(word)) {
            rwords.add(word);
        }
    }

    public static String fixConstraintName(String name, DataSource dataSource) {
        return SQLUtil.fixTableName(name, dataSource).replace('.', '_');
    }

    public static String getCreateTableColumnsClause(JDBCFieldBridge[] fields) {
        StringBuffer buf = new StringBuffer(100);
        boolean comma = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            if (comma) {
                buf.append(COMMA);
            } else {
                comma = true;
            }
            buf.append(SQLUtil.getCreateTableColumnsClause(type));
        }
        return buf.toString();
    }

    public static String getCreateTableColumnsClause(JDBCType type) {
        String[] columnNames = type.getColumnNames();
        String[] sqlTypes = type.getSQLTypes();
        boolean[] notNull = type.getNotNull();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < columnNames.length; ++i) {
            if (i != 0) {
                buf.append(COMMA);
            }
            buf.append(columnNames[i]).append(' ').append(sqlTypes[i]);
            if (!notNull[i]) continue;
            buf.append(NOT).append(NULL);
        }
        return buf.toString();
    }

    public static StringBuffer getColumnNamesClause(JDBCFieldBridge[] fields, StringBuffer sb) {
        return SQLUtil.getColumnNamesClause(fields, EMPTY_STRING, sb);
    }

    public static StringBuffer getColumnNamesClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf) {
        boolean comma = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            if (comma) {
                buf.append(COMMA);
            } else {
                comma = true;
            }
            SQLUtil.getColumnNamesClause(type, identifier, buf);
        }
        return buf;
    }

    public static StringBuffer getSearchableColumnNamesClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf) {
        boolean comma = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null || !type.isSearchable()) continue;
            if (comma) {
                buf.append(COMMA);
            } else {
                comma = true;
            }
            SQLUtil.getColumnNamesClause(type, identifier, buf);
        }
        return buf;
    }

    public static StringBuffer getColumnNamesClause(JDBCEntityBridge.FieldIterator loadIter, StringBuffer sb) {
        if (loadIter.hasNext()) {
            SQLUtil.getColumnNamesClause(loadIter.next(), sb);
        }
        while (loadIter.hasNext()) {
            sb.append(COMMA);
            SQLUtil.getColumnNamesClause(loadIter.next(), sb);
        }
        return sb;
    }

    public static StringBuffer getColumnNamesClause(JDBCFieldBridge field, StringBuffer sb) {
        return SQLUtil.getColumnNamesClause(field.getJDBCType(), sb);
    }

    public static StringBuffer getColumnNamesClause(JDBCFieldBridge field, String identifier, StringBuffer sb) {
        return SQLUtil.getColumnNamesClause(field.getJDBCType(), identifier, sb);
    }

    private static StringBuffer getColumnNamesClause(JDBCType type, String identifier, StringBuffer buf) {
        boolean hasIdentifier;
        String[] columnNames = type.getColumnNames();
        boolean bl = hasIdentifier = identifier.length() > 0;
        if (hasIdentifier) {
            buf.append(identifier).append(DOT);
        }
        buf.append(columnNames[0]);
        int i = 1;
        while (i < columnNames.length) {
            buf.append(COMMA);
            if (hasIdentifier) {
                buf.append(identifier).append(DOT);
            }
            buf.append(columnNames[i++]);
        }
        return buf;
    }

    public static StringBuffer appendColumnNamesClause(JDBCAbstractEntityBridge entity, String eagerLoadGroup, StringBuffer sb) {
        return SQLUtil.appendColumnNamesClause(entity, eagerLoadGroup, EMPTY_STRING, sb);
    }

    public static StringBuffer appendColumnNamesClause(JDBCAbstractEntityBridge entity, String eagerLoadGroup, String alias, StringBuffer sb) {
        return SQLUtil.appendColumnNamesClause(entity.getTableFields(), entity.getLoadGroupMask(eagerLoadGroup), alias, sb);
    }

    public static StringBuffer appendColumnNamesClause(JDBCFieldBridge[] fields, boolean[] mask, String identifier, StringBuffer buf) {
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type;
            if (!mask[i] || (type = SQLUtil.getJDBCType(fields[i])) == null) continue;
            buf.append(COMMA);
            SQLUtil.getColumnNamesClause(type, identifier, buf);
        }
        return buf;
    }

    public static StringBuffer appendSearchableColumnNamesClause(JDBCFieldBridge[] fields, boolean[] mask, String identifier, StringBuffer buf) {
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type;
            if (!mask[i] || (type = SQLUtil.getJDBCType(fields[i])) == null || !type.isSearchable()) continue;
            buf.append(COMMA);
            SQLUtil.getColumnNamesClause(type, identifier, buf);
        }
        return buf;
    }

    public static StringBuffer appendColumnNamesClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf) {
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            buf.append(COMMA);
            SQLUtil.getColumnNamesClause(type, identifier, buf);
        }
        return buf;
    }

    private static StringBuffer getColumnNamesClause(JDBCType type, StringBuffer buf) {
        String[] columnNames = type.getColumnNames();
        buf.append(columnNames[0]);
        int i = 1;
        while (i < columnNames.length) {
            buf.append(COMMA).append(columnNames[i++]);
        }
        return buf;
    }

    public static StringBuffer getSetClause(JDBCEntityBridge.FieldIterator fieldsIter, StringBuffer buf) {
        JDBCType type = SQLUtil.getJDBCType(fieldsIter.next());
        SQLUtil.getSetClause(type, buf);
        while (fieldsIter.hasNext()) {
            type = SQLUtil.getJDBCType(fieldsIter.next());
            buf.append(COMMA);
            SQLUtil.getSetClause(type, buf);
        }
        return buf;
    }

    private static StringBuffer getSetClause(JDBCType type, StringBuffer buf) {
        String[] columnNames = type.getColumnNames();
        buf.append(columnNames[0]).append(EQ_QUESTMARK);
        int i = 1;
        while (i < columnNames.length) {
            buf.append(COMMA).append(columnNames[i++]).append(EQ_QUESTMARK);
        }
        return buf;
    }

    public static StringBuffer getValuesClause(JDBCFieldBridge[] fields, StringBuffer buf) {
        boolean comma = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            if (comma) {
                buf.append(COMMA);
            } else {
                comma = true;
            }
            SQLUtil.getValuesClause(type, buf);
        }
        return buf;
    }

    private static StringBuffer getValuesClause(JDBCType type, StringBuffer buf) {
        int columnCount = type.getColumnNames().length;
        buf.append('?');
        int i = 1;
        while (i++ < columnCount) {
            buf.append(COMMA).append('?');
        }
        return buf;
    }

    public static StringBuffer getWhereClause(JDBCFieldBridge[] fields, StringBuffer buf) {
        return SQLUtil.getWhereClause(fields, EMPTY_STRING, buf);
    }

    public static StringBuffer getWhereClause(JDBCFieldBridge[] fields, String identifier, StringBuffer buf) {
        boolean and = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            if (and) {
                buf.append(AND);
            } else {
                and = true;
            }
            SQLUtil.getWhereClause(type, identifier, buf);
        }
        return buf;
    }

    public static StringBuffer getWhereClause(JDBCFieldBridge[] fields, long mask, StringBuffer buf) {
        return SQLUtil.getWhereClause(fields, mask, EMPTY_STRING, buf);
    }

    private static StringBuffer getWhereClause(JDBCFieldBridge[] fields, long mask, String identifier, StringBuffer buf) {
        boolean and = false;
        long fieldMask = 1L;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type;
            if ((fieldMask & mask) > 0L && (type = SQLUtil.getJDBCType(fields[i])) != null) {
                if (and) {
                    buf.append(AND);
                } else {
                    and = true;
                }
                SQLUtil.getWhereClause(type, identifier, buf);
            }
            fieldMask <<= 1;
        }
        return buf;
    }

    public static StringBuffer getWhereClause(JDBCFieldBridge field, StringBuffer buf) {
        return SQLUtil.getWhereClause(field.getJDBCType(), EMPTY_STRING, buf);
    }

    public static StringBuffer getWhereClause(JDBCType type, String identifier, StringBuffer buf) {
        if (identifier.length() > 0) {
            identifier = identifier + '.';
        }
        String[] columnNames = type.getColumnNames();
        buf.append(identifier).append(columnNames[0]).append(EQ_QUESTMARK);
        int i = 1;
        while (i < columnNames.length) {
            buf.append(AND).append(identifier).append(columnNames[i++]).append(EQ_QUESTMARK);
        }
        return buf;
    }

    public static StringBuffer getWhereClause(JDBCType type, String identifier, String comparison, StringBuffer buf) {
        if (identifier.length() > 0) {
            identifier = identifier + '.';
        }
        String[] columnNames = type.getColumnNames();
        buf.append(identifier).append(columnNames[0]).append(comparison).append('?');
        int i = 1;
        while (i < columnNames.length) {
            buf.append(AND).append(identifier).append(columnNames[i++]).append(comparison).append('?');
        }
        return buf;
    }

    public static StringBuffer getIsNullClause(boolean not, JDBCFieldBridge[] fields, String identifier, StringBuffer buf) {
        boolean and = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            if (and) {
                buf.append(AND);
            } else {
                and = true;
            }
            SQLUtil.getIsNullClause(not, type, identifier, buf);
        }
        return buf;
    }

    public static StringBuffer getIsNullClause(boolean not, JDBCFieldBridge field, String identifier, StringBuffer buf) {
        return SQLUtil.getIsNullClause(not, field.getJDBCType(), identifier, buf);
    }

    private static StringBuffer getIsNullClause(boolean not, JDBCType type, String identifier, StringBuffer buf) {
        if (identifier.length() > 0) {
            identifier = identifier + '.';
        }
        String[] columnNames = type.getColumnNames();
        buf.append(identifier).append(columnNames[0]).append(IS);
        (not ? buf.append(NOT) : buf).append(NULL);
        int i = 1;
        while (i < columnNames.length) {
            buf.append(AND).append(identifier).append(columnNames[i++]).append(IS);
            (not ? buf.append(NOT) : buf).append(NULL);
        }
        return buf;
    }

    public static StringBuffer getJoinClause(JDBCAbstractCMRFieldBridge cmrField, String parentAlias, String childAlias, StringBuffer buf) {
        JDBCAbstractEntityBridge parentEntity = cmrField.getEntity();
        JDBCAbstractEntityBridge childEntity = (JDBCAbstractEntityBridge)cmrField.getRelatedEntity();
        if (cmrField.hasForeignKey()) {
            JDBCFieldBridge[] parentFkFields = cmrField.getForeignKeyFields();
            int i = 0;
            while (i < parentFkFields.length) {
                JDBCFieldBridge parentField = parentFkFields[i++];
                JDBCFieldBridge childField = (JDBCFieldBridge)childEntity.getFieldByName(parentField.getFieldName());
                SQLUtil.getJoinClause(parentField, parentAlias, childField, childAlias, buf);
                if (i >= parentFkFields.length) continue;
                buf.append(AND);
            }
        } else {
            JDBCFieldBridge[] childFkFields = cmrField.getRelatedCMRField().getForeignKeyFields();
            int i = 0;
            while (i < childFkFields.length) {
                JDBCFieldBridge childField = childFkFields[i++];
                JDBCFieldBridge parentField = (JDBCFieldBridge)parentEntity.getFieldByName(childField.getFieldName());
                SQLUtil.getJoinClause(parentField, parentAlias, childField, childAlias, buf);
                if (i >= childFkFields.length) continue;
                buf.append(AND);
            }
        }
        return buf;
    }

    public static StringBuffer getRelationTableJoinClause(JDBCAbstractCMRFieldBridge cmrField, String parentAlias, String relationTableAlias, StringBuffer buf) {
        JDBCAbstractEntityBridge parentEntity = cmrField.getEntity();
        JDBCFieldBridge[] parentFields = cmrField.getTableKeyFields();
        int i = 0;
        while (i < parentFields.length) {
            JDBCFieldBridge relationField = parentFields[i++];
            JDBCFieldBridge parentField = (JDBCFieldBridge)parentEntity.getFieldByName(relationField.getFieldName());
            SQLUtil.getJoinClause(parentField, parentAlias, relationField, relationTableAlias, buf);
            if (i >= parentFields.length) continue;
            buf.append(AND);
        }
        return buf;
    }

    private static StringBuffer getJoinClause(JDBCFieldBridge pkField, String parent, JDBCFieldBridge fkField, String child, StringBuffer buf) {
        return SQLUtil.getJoinClause(pkField.getJDBCType(), parent, fkField.getJDBCType(), child, buf);
    }

    public static StringBuffer getJoinClause(JDBCFieldBridge[] pkFields, String parent, JDBCFieldBridge[] fkFields, String child, StringBuffer buf) {
        if (pkFields.length != fkFields.length) {
            throw new IllegalArgumentException("Error createing theta join clause: pkField.size()=" + pkFields.length + " fkField.size()=" + fkFields.length);
        }
        boolean and = false;
        for (int i = 0; i < pkFields.length; ++i) {
            JDBCType pkType = SQLUtil.getJDBCType(pkFields[i]);
            JDBCType fkType = SQLUtil.getJDBCType(fkFields[i]);
            if (and) {
                buf.append(AND);
            } else {
                and = true;
            }
            SQLUtil.getJoinClause(pkType, parent, fkType, child, buf);
        }
        return buf;
    }

    private static StringBuffer getJoinClause(JDBCType pkType, String parent, JDBCType fkType, String child, StringBuffer buf) {
        String[] fkColumnNames;
        String[] pkColumnNames;
        if (parent.length() > 0) {
            parent = parent + '.';
        }
        if (child.length() > 0) {
            child = child + '.';
        }
        if ((pkColumnNames = pkType.getColumnNames()).length != (fkColumnNames = fkType.getColumnNames()).length) {
            throw new IllegalArgumentException("PK and FK have different number of columns");
        }
        buf.append(parent).append(pkColumnNames[0]).append('=').append(child).append(fkColumnNames[0]);
        int i = 1;
        while (i < pkColumnNames.length) {
            buf.append(AND).append(parent).append(pkColumnNames[i]).append('=').append(child).append(fkColumnNames[i++]);
        }
        return buf;
    }

    public static StringBuffer getSelfCompareWhereClause(JDBCFieldBridge[] fields, String fromIdentifier, String toIdentifier, StringBuffer buf) {
        boolean and = false;
        for (int i = 0; i < fields.length; ++i) {
            JDBCType type = SQLUtil.getJDBCType(fields[i]);
            if (type == null) continue;
            if (and) {
                buf.append(AND);
            } else {
                and = true;
            }
            SQLUtil.getSelfCompareWhereClause(type, fromIdentifier, toIdentifier, buf);
        }
        return buf;
    }

    private static StringBuffer getSelfCompareWhereClause(JDBCType type, String fromIdentifier, String toIdentifier, StringBuffer buf) {
        if (fromIdentifier.length() > 0) {
            fromIdentifier = fromIdentifier + '.';
        }
        if (toIdentifier.length() > 0) {
            toIdentifier = toIdentifier + '.';
        }
        String[] columnNames = type.getColumnNames();
        buf.append(fromIdentifier).append(columnNames[0]).append('=').append(toIdentifier).append(columnNames[0]);
        int i = 1;
        while (i < columnNames.length) {
            buf.append(AND).append(fromIdentifier).append(columnNames[i]).append('=').append(toIdentifier).append(columnNames[i++]);
        }
        return buf;
    }

    public static StringBuffer getSelfCompareWhereClause(JDBCFieldBridge fromField, JDBCFieldBridge toField, String fromIdentifier, String toIdentifier, String comparison, StringBuffer buf) {
        return SQLUtil.getSelfCompareWhereClause(fromField.getJDBCType(), toField.getJDBCType(), fromIdentifier, toIdentifier, comparison, buf);
    }

    private static StringBuffer getSelfCompareWhereClause(JDBCType fromType, JDBCType toType, String fromIdentifier, String toIdentifier, String comparison, StringBuffer buf) {
        if (fromIdentifier.length() > 0) {
            fromIdentifier = fromIdentifier + '.';
        }
        if (toIdentifier.length() > 0) {
            toIdentifier = toIdentifier + '.';
        }
        String[] fromColumnNames = fromType.getColumnNames();
        String[] toColumnNames = toType.getColumnNames();
        buf.append(fromIdentifier).append(fromColumnNames[0]).append(comparison).append(toIdentifier).append(toColumnNames[0]);
        int i = 1;
        while (i < fromColumnNames.length) {
            buf.append(AND).append(fromIdentifier).append(fromColumnNames[i]).append(comparison).append(toIdentifier).append(toColumnNames[i++]);
        }
        return buf;
    }

    public static boolean tableExists(String tableName, DataSource dataSource) {
        boolean bl;
        Connection con = null;
        ResultSet rs = null;
        try {
            con = dataSource.getConnection();
            DatabaseMetaData dmd = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = null;
            String quote = dmd.getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new RuntimeException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
                if (dmd.storesLowerCaseQuotedIdentifiers()) {
                    tableName = tableName.toLowerCase();
                } else if (dmd.storesUpperCaseQuotedIdentifiers()) {
                    tableName = tableName.toUpperCase();
                }
            } else if (dmd.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getTables(catalog, schema, tableName, null);
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Error while checking if table aleady exists " + tableName, e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(con);
        return bl;
    }

    public static OldColumns getOldColumns(String tableName, DataSource dataSource) {
        OldColumns oldColumns;
        Connection con = null;
        ResultSet rs = null;
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> typeNames = new ArrayList<String>();
        ArrayList<Integer> columnSizes = new ArrayList<Integer>();
        try {
            con = dataSource.getConnection();
            DatabaseMetaData dmd = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = null;
            String quote = dmd.getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new RuntimeException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
                if (dmd.storesLowerCaseQuotedIdentifiers()) {
                    tableName = tableName.toLowerCase();
                } else if (dmd.storesUpperCaseQuotedIdentifiers()) {
                    tableName = tableName.toUpperCase();
                }
            } else if (dmd.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getColumns(catalog, schema, tableName, null);
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                columnNames.add(columnName == null ? null : columnName.toUpperCase());
                typeNames.add(rs.getString("TYPE_NAME"));
                columnSizes.add(new Integer(rs.getInt("COLUMN_SIZE")));
            }
            oldColumns = new OldColumns(columnNames, typeNames, columnSizes);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Error while geting column names", e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(con);
        return oldColumns;
    }

    public static OldIndexes getOldIndexes(String tableName, DataSource dataSource) {
        OldIndexes oldIndexes;
        tableName = SQLUtil.unquote(tableName, dataSource);
        Connection con = null;
        ResultSet rs = null;
        ArrayList<String> indexNames = new ArrayList<String>();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> ascDesc = new ArrayList<String>();
        try {
            con = dataSource.getConnection();
            DatabaseMetaData dmd = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = null;
            if (dmd.storesLowerCaseIdentifiers()) {
                tableName = tableName.toLowerCase();
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = tableName.toUpperCase();
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getIndexInfo(catalog, schema, tableName, false, false);
            while (rs.next()) {
                indexNames.add(rs.getString("INDEX_NAME"));
                columnNames.add(rs.getString("COLUMN_NAME"));
                ascDesc.add(rs.getString("ASC_OR_DESC"));
            }
            oldIndexes = new OldIndexes(indexNames, columnNames, ascDesc);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Error while geting column names", e);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(con);
        return oldIndexes;
    }

    public static String unquote(String tableName, DataSource ds) {
        Connection con = null;
        try {
            con = ds.getConnection();
            String quote = con.getMetaData().getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new RuntimeException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get datasource connection");
        }
        finally {
            JDBCUtil.safeClose(con);
        }
        return tableName;
    }

    private static JDBCType getJDBCType(JDBCFieldBridge field) {
        JDBCType type = field.getJDBCType();
        if (type != null && type.getColumnNames().length > 0) {
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(DataSource dataSource, String tableName) {
        Logger log = Logger.getLogger((String)"CLEANER");
        String sql = DROP_TABLE + tableName;
        try {
            Connection con = null;
            Statement statement = null;
            try {
                con = dataSource.getConnection();
                statement = con.createStatement();
                statement.executeUpdate(sql);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(statement);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(statement);
            JDBCUtil.safeClose(con);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while droping table " + tableName, e);
        }
        log.info((Object)("Dropped table " + tableName + " succesfuly"));
    }

    public static class OldIndexes {
        private ArrayList indexNames;
        private ArrayList columnNames;
        private ArrayList columnAscDesc;

        private OldIndexes(ArrayList in, ArrayList cn, ArrayList ad) {
            this.indexNames = in;
            this.columnNames = cn;
            this.columnAscDesc = ad;
        }

        public ArrayList getColumnNames() {
            return this.columnNames;
        }

        public ArrayList getIndexNames() {
            return this.indexNames;
        }

        public ArrayList getColumnAscDesc() {
            return this.columnAscDesc;
        }
    }

    public static class OldColumns {
        private ArrayList columnNames;
        private ArrayList typeNames;
        private ArrayList columnSizes;

        private OldColumns(ArrayList cn, ArrayList tn, ArrayList cs) {
            this.columnNames = cn;
            this.typeNames = tn;
            this.columnSizes = cs;
        }

        public ArrayList getColumnNames() {
            return this.columnNames;
        }

        public ArrayList getTypeNames() {
            return this.typeNames;
        }

        public ArrayList getColumnSizes() {
            return this.columnSizes;
        }
    }
}

