/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.bridge;

import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponentInstance;
import org.jboss.as.cmp.context.CmpEntityBeanContext;

public class EntityBridgeInvocationHandler {
    private final Map<String, BridgeInvoker> fieldMap;
    private final Map<Method, BridgeInvoker> selectorMap;

    public EntityBridgeInvocationHandler(Map<String, BridgeInvoker> fieldMap, Map<Method, BridgeInvoker> selectorMap) {
        this.fieldMap = fieldMap;
        this.selectorMap = selectorMap;
    }

    public Object invoke(CmpEntityBeanComponentInstance instance, Object proxy, Method method, Object[] args) throws FinderException {
        String methodName = method.getName();
        BridgeInvoker invoker = this.fieldMap.get(methodName);
        if (invoker == null && (invoker = this.selectorMap.get(method)) == null) {
            throw new EJBException("Method is not a known CMP field accessor, CMR field accessor, or ejbSelect method: methodName=" + methodName);
        }
        try {
            return invoker.invoke(instance.getEjbContext(), method, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FinderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Internal error", e);
        }
    }

    public static class FieldSetInvoker
    implements BridgeInvoker {
        private final FieldBridge field;

        public FieldSetInvoker(FieldBridge field) {
            this.field = field;
        }

        @Override
        public Object invoke(CmpEntityBeanContext ctx, Method method, Object[] args) {
            if (ctx == null) {
                throw new EJBException("EJB home methods are not allowed to access CMP or CMR fields: methodName=" + method.getName());
            }
            this.field.setValue(ctx, args[0]);
            return null;
        }
    }

    public static class FieldGetInvoker
    implements BridgeInvoker {
        private final FieldBridge field;

        public FieldGetInvoker(FieldBridge field) {
            this.field = field;
        }

        @Override
        public Object invoke(CmpEntityBeanContext ctx, Method method, Object[] args) {
            if (ctx == null) {
                throw new EJBException("EJB home methods are not allowed to access CMP or CMR fields: methodName=" + method.getName());
            }
            return this.field.getValue(ctx);
        }
    }

    public static interface BridgeInvoker {
        public Object invoke(CmpEntityBeanContext var1, Method var2, Object[] var3) throws Exception;
    }
}

