/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc.metadata;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.jdbc.metadata.JDBCApplicationMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedEntity;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedRelationship;
import org.jboss.as.cmp.jdbc.metadata.parser.ParsedRelationshipRole;
import org.jboss.metadata.ejb.spec.RelationMetaData;
import org.jboss.metadata.ejb.spec.RelationRoleMetaData;

public final class JDBCRelationMetaData {
    private String relationName;
    private MappingStyle mappingStyle;
    private String dataSourceName;
    private JDBCTypeMappingMetaData datasourceMapping;
    private String tableName;
    private boolean tableCreated;
    private boolean tableDropped;
    private Boolean createTable;
    private Boolean removeTable;
    private Boolean alterTable;
    private final List<String> tablePostCreateCmd = new ArrayList<String>();
    private Boolean rowLocking;
    private Boolean primaryKeyConstraint;
    private Boolean readOnly;
    private Integer readTimeOut;
    private JDBCRelationshipRoleMetaData left;
    private JDBCRelationshipRoleMetaData right;
    private List<JDBCRelationshipRoleMetaData> roles = new ArrayList<JDBCRelationshipRoleMetaData>();

    public JDBCRelationMetaData() {
    }

    public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, RelationMetaData relationMetaData) {
        RelationRoleMetaData leftRole = relationMetaData.getLeftRole();
        RelationRoleMetaData rightRole = relationMetaData.getRightRole();
        this.mappingStyle = leftRole.isMultiplicityMany() && rightRole.isMultiplicityMany() ? MappingStyle.TABLE : MappingStyle.FOREIGN_KEY;
        this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, leftRole);
        this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, rightRole);
        this.left.init(this.right);
        this.right.init(this.left);
        this.relationName = JDBCRelationMetaData.getNonNullRelationName(this.left, this.right, relationMetaData.getEjbRelationName());
        this.tableName = this.mappingStyle == MappingStyle.TABLE ? this.createDefaultTableName() : null;
    }

    public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, JDBCRelationMetaData defaultValues) {
        JDBCEntityMetaData defaultEntity = jdbcApplication.getDefaultEntity();
        this.mappingStyle = defaultValues.mappingStyle;
        this.readOnly = defaultValues.readOnly != null ? defaultValues.readOnly.booleanValue() : defaultEntity.isReadOnly();
        this.readTimeOut = defaultValues.readTimeOut != null ? defaultValues.readTimeOut.intValue() : defaultEntity.getReadTimeOut();
        this.dataSourceName = defaultValues.dataSourceName != null ? defaultValues.dataSourceName : defaultEntity.getDataSourceName();
        this.datasourceMapping = defaultValues.datasourceMapping != null ? defaultValues.datasourceMapping : defaultEntity.getTypeMapping();
        String tableNameString = defaultValues.getDefaultTableName();
        if (tableNameString == null) {
            tableNameString = defaultValues.createDefaultTableName();
        }
        this.tableName = tableNameString;
        this.createTable = defaultValues.createTable != null ? defaultValues.createTable.booleanValue() : defaultEntity.getCreateTable();
        this.removeTable = defaultValues.removeTable != null ? defaultValues.removeTable.booleanValue() : defaultEntity.getRemoveTable();
        if (defaultValues.tablePostCreateCmd != null && !defaultValues.tablePostCreateCmd.isEmpty()) {
            this.tablePostCreateCmd.addAll(defaultValues.tablePostCreateCmd);
        } else if (defaultEntity.getDefaultTablePostCreateCmd() != null) {
            this.tablePostCreateCmd.addAll(defaultEntity.getDefaultTablePostCreateCmd());
        }
        this.alterTable = defaultValues.alterTable != null ? defaultValues.alterTable.booleanValue() : defaultEntity.getAlterTable();
        this.rowLocking = defaultValues.rowLocking != null ? defaultValues.rowLocking.booleanValue() : defaultEntity.hasRowLocking();
        this.primaryKeyConstraint = defaultValues.primaryKeyConstraint != null ? defaultValues.primaryKeyConstraint.booleanValue() : defaultEntity.hasPrimaryKeyConstraint();
        JDBCRelationshipRoleMetaData defaultLeft = defaultValues.getLeftRelationshipRole();
        JDBCRelationshipRoleMetaData defaultRight = defaultValues.getRightRelationshipRole();
        this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, defaultLeft);
        this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, defaultRight);
        this.left.init(this.right);
        this.right.init(this.left);
        this.relationName = JDBCRelationMetaData.getNonNullRelationName(this.left, this.right, defaultValues.getRelationName());
        if (this.isForeignKeyMappingStyle() && this.left.getKeyFields().isEmpty() && this.right.getKeyFields().isEmpty()) {
            throw CmpMessages.MESSAGES.atLeastOneRelationshipRoleMustHaveField(this.relationName);
        }
        if (this.isTableMappingStyle() && (this.left.getKeyFields().isEmpty() || this.right.getKeyFields().isEmpty())) {
            throw CmpMessages.MESSAGES.bothRolesMustHaveFields(this.relationName);
        }
    }

    public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, ParsedEntity defaultEntity, JDBCRelationMetaData defaultValues) {
        String tableNameString;
        String preferredRelationMapping = defaultEntity.getPreferredMappingStyle();
        this.mappingStyle = "relation-table".equals(preferredRelationMapping) || defaultValues.isManyToMany() ? MappingStyle.TABLE : MappingStyle.FOREIGN_KEY;
        this.readOnly = defaultEntity.getReadOnly() != null ? defaultEntity.getReadOnly() : Boolean.valueOf(defaultValues.isReadOnly());
        this.readTimeOut = defaultEntity.getReadTimeOut() != null ? defaultEntity.getReadTimeOut() : Integer.valueOf(defaultValues.getReadTimeOut());
        this.dataSourceName = defaultEntity.getDataSourceName() != null ? defaultEntity.getDataSourceName() : defaultValues.getDataSourceName();
        if (defaultEntity.getDataSourceMappingName() != null) {
            this.datasourceMapping = jdbcApplication.getTypeMappingByName(defaultEntity.getDataSourceMappingName());
            if (this.datasourceMapping == null) {
                throw CmpMessages.MESSAGES.datasourceMappingNotFound(defaultEntity.getDataSourceMappingName());
            }
        } else if (defaultValues.getTypeMapping() != null) {
            this.datasourceMapping = defaultValues.getTypeMapping();
        }
        if ((tableNameString = defaultEntity.getTableName()) == null && (tableNameString = defaultValues.getDefaultTableName()) == null) {
            tableNameString = defaultValues.createDefaultTableName();
        }
        this.tableName = tableNameString;
        this.createTable = defaultEntity.getCreateTable() != null ? defaultEntity.getCreateTable() : Boolean.valueOf(defaultValues.getCreateTable());
        this.removeTable = defaultEntity.getRemoveTable() != null ? defaultEntity.getRemoveTable() : Boolean.valueOf(defaultValues.getRemoveTable());
        if (!defaultEntity.getTablePostCreateCmd().isEmpty()) {
            this.tablePostCreateCmd.addAll(defaultEntity.getTablePostCreateCmd());
        } else {
            this.tablePostCreateCmd.addAll(defaultValues.getDefaultTablePostCreateCmd());
        }
        this.alterTable = defaultEntity.getAlterTable() != null ? defaultEntity.getAlterTable() : Boolean.valueOf(defaultValues.getAlterTable());
        this.rowLocking = defaultEntity.getRowLocking() != null ? Boolean.valueOf(!this.isReadOnly() && defaultEntity.getRowLocking() != false) : Boolean.valueOf(defaultValues.hasRowLocking());
        this.primaryKeyConstraint = defaultEntity.getPrimaryKeyConstraint() != null ? defaultEntity.getPrimaryKeyConstraint() : Boolean.valueOf(defaultValues.hasPrimaryKeyConstraint());
        JDBCRelationshipRoleMetaData defaultLeft = defaultValues.getLeftRelationshipRole();
        JDBCRelationshipRoleMetaData defaultRight = defaultValues.getRightRelationshipRole();
        this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, defaultLeft);
        this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, defaultRight);
        this.left.init(this.right);
        this.right.init(this.left);
        this.relationName = JDBCRelationMetaData.getNonNullRelationName(this.left, this.right, defaultValues.getRelationName());
    }

    public JDBCRelationMetaData(JDBCApplicationMetaData jdbcApplication, ParsedRelationship parsedRelationship, JDBCRelationMetaData defaultValues) {
        String tableNameString;
        this.mappingStyle = parsedRelationship.getMappingStyle() != null ? parsedRelationship.getMappingStyle() : defaultValues.mappingStyle;
        this.readOnly = parsedRelationship.getReadOnly() != null ? parsedRelationship.getReadOnly() : Boolean.valueOf(defaultValues.isReadOnly());
        this.readTimeOut = parsedRelationship.getReadTimeOut() != null ? parsedRelationship.getReadTimeOut() : Integer.valueOf(defaultValues.getReadTimeOut());
        this.dataSourceName = parsedRelationship.getDataSourceName() != null ? parsedRelationship.getDataSourceName() : defaultValues.getDataSourceName();
        if (parsedRelationship.getDatasourceMapping() != null) {
            this.datasourceMapping = jdbcApplication.getTypeMappingByName(parsedRelationship.getDatasourceMapping());
            if (this.datasourceMapping == null) {
                throw CmpMessages.MESSAGES.datasourceMappingNotFound(parsedRelationship.getDatasourceMapping());
            }
        } else if (defaultValues.getTypeMapping() != null) {
            this.datasourceMapping = defaultValues.getTypeMapping();
        }
        if ((tableNameString = parsedRelationship.getTableName()) == null && (tableNameString = defaultValues.getDefaultTableName()) == null) {
            tableNameString = defaultValues.createDefaultTableName();
        }
        this.tableName = tableNameString;
        this.createTable = parsedRelationship.getCreateTable() != null ? parsedRelationship.getCreateTable() : Boolean.valueOf(defaultValues.getCreateTable());
        this.removeTable = parsedRelationship.getRemoveTable() != null ? parsedRelationship.getRemoveTable() : Boolean.valueOf(defaultValues.getRemoveTable());
        if (!parsedRelationship.getTablePostCreateCmd().isEmpty()) {
            this.tablePostCreateCmd.addAll(parsedRelationship.getTablePostCreateCmd());
        } else {
            this.tablePostCreateCmd.addAll(defaultValues.getDefaultTablePostCreateCmd());
        }
        this.alterTable = parsedRelationship.getAlterTable() != null ? parsedRelationship.getAlterTable() : Boolean.valueOf(defaultValues.getAlterTable());
        this.rowLocking = parsedRelationship.getRowLocking() != null ? Boolean.valueOf(!this.isReadOnly() && parsedRelationship.getRowLocking() != false) : Boolean.valueOf(defaultValues.hasRowLocking());
        this.primaryKeyConstraint = parsedRelationship.getPrimaryKeyConstraint() != null ? parsedRelationship.getPrimaryKeyConstraint() : Boolean.valueOf(defaultValues.hasPrimaryKeyConstraint());
        JDBCRelationshipRoleMetaData defaultLeft = defaultValues.getLeftRelationshipRole();
        JDBCRelationshipRoleMetaData defaultRight = defaultValues.getRightRelationshipRole();
        if (parsedRelationship.getRoles().isEmpty()) {
            this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, defaultLeft);
            this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, defaultRight);
            this.left.init(this.right);
            this.right.init(this.left);
        } else {
            ParsedRelationshipRole leftRole = this.getEJBRelationshipRole(parsedRelationship.getRoles(), defaultLeft);
            this.left = new JDBCRelationshipRoleMetaData(this, jdbcApplication, leftRole, defaultLeft);
            ParsedRelationshipRole rightRole = this.getEJBRelationshipRole(parsedRelationship.getRoles(), defaultRight);
            this.right = new JDBCRelationshipRoleMetaData(this, jdbcApplication, rightRole, defaultRight);
            this.left.init(this.right, leftRole);
            this.right.init(this.left, rightRole);
        }
        this.relationName = JDBCRelationMetaData.getNonNullRelationName(this.left, this.right, defaultValues.getRelationName());
        if (this.isForeignKeyMappingStyle() && this.left.getKeyFields().isEmpty() && this.right.getKeyFields().isEmpty()) {
            throw CmpMessages.MESSAGES.atLeastOneRelationshipRoleMustHaveField(this.relationName);
        }
        if (this.isTableMappingStyle() && (this.left.getKeyFields().isEmpty() || this.right.getKeyFields().isEmpty())) {
            throw CmpMessages.MESSAGES.bothRolesMustHaveFields(this.relationName);
        }
    }

    private ParsedRelationshipRole getEJBRelationshipRole(List<ParsedRelationshipRole> roles, JDBCRelationshipRoleMetaData defaultRole) {
        String roleName = defaultRole.getRelationshipRoleName();
        if (roleName == null) {
            throw CmpMessages.MESSAGES.noEjbRelationRoleNameElement();
        }
        for (ParsedRelationshipRole role : roles) {
            if (!roleName.equals(role.getRelationshipRoleName())) continue;
            return role;
        }
        throw CmpMessages.MESSAGES.noEjbRelationshipRole(roleName);
    }

    public JDBCRelationshipRoleMetaData getLeftRelationshipRole() {
        return this.left;
    }

    public JDBCRelationshipRoleMetaData getRightRelationshipRole() {
        return this.right;
    }

    public JDBCRelationshipRoleMetaData getOtherRelationshipRole(JDBCRelationshipRoleMetaData role) {
        if (this.left == role) {
            return this.right;
        }
        if (this.right == role) {
            return this.left;
        }
        throw CmpMessages.MESSAGES.roleNotLeftOrRightRole(role.getRelationshipRoleName());
    }

    public String getRelationName() {
        return this.relationName;
    }

    public boolean isTableMappingStyle() {
        return this.mappingStyle == MappingStyle.TABLE;
    }

    public boolean isForeignKeyMappingStyle() {
        return this.mappingStyle == MappingStyle.FOREIGN_KEY;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDefaultTableName() {
        return this.tableName;
    }

    public List<String> getDefaultTablePostCreateCmd() {
        return this.tablePostCreateCmd;
    }

    public boolean isTableCreated() {
        return this.tableCreated;
    }

    public void setTableCreated() {
        this.tableCreated = true;
    }

    public void setTableDropped() {
        this.tableDropped = true;
    }

    public boolean isTableDropped() {
        return this.tableDropped;
    }

    public boolean getCreateTable() {
        return this.createTable != null && this.createTable != false;
    }

    public boolean getRemoveTable() {
        return this.removeTable != null && this.removeTable != false;
    }

    public boolean getAlterTable() {
        return this.alterTable != null && this.alterTable != false;
    }

    public boolean hasPrimaryKeyConstraint() {
        return this.primaryKeyConstraint != null && this.primaryKeyConstraint != false;
    }

    public boolean isReadOnly() {
        return this.readOnly != null && this.readOnly != false;
    }

    public int getReadTimeOut() {
        return this.readTimeOut != null ? this.readTimeOut : -1;
    }

    public boolean hasRowLocking() {
        return this.rowLocking != null && this.rowLocking != false;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public void setPrimaryKeyConstraint(boolean primaryKeyConstraint) {
        this.primaryKeyConstraint = primaryKeyConstraint;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDatasourceMapping(JDBCTypeMappingMetaData datasourceMapping) {
        this.datasourceMapping = datasourceMapping;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public void setRemoveTable(boolean removeTable) {
        this.removeTable = removeTable;
    }

    public void setAlterTable(boolean alterTable) {
        this.alterTable = alterTable;
    }

    public void setRowLocking(boolean rowLocking) {
        this.rowLocking = rowLocking;
    }

    public void setMappingStyle(MappingStyle mappingStyle) {
        this.mappingStyle = mappingStyle;
    }

    public void addPostTableCreate(String command) {
        this.tablePostCreateCmd.add(command);
    }

    private static String getNonNullRelationName(JDBCRelationshipRoleMetaData left, JDBCRelationshipRoleMetaData right, String relationName) {
        if (relationName == null) {
            relationName = left.getEntity().getName() + (!left.isNavigable() ? "" : "_" + left.getCMRFieldName()) + "-" + right.getEntity().getName() + (!right.isNavigable() ? "" : "_" + right.getCMRFieldName());
        }
        return relationName;
    }

    private String createDefaultTableName() {
        String defaultTableName = this.left.getEntity().getName();
        if (this.left.getCMRFieldName() != null) {
            defaultTableName = defaultTableName + "_" + this.left.getCMRFieldName();
        }
        defaultTableName = defaultTableName + "_" + this.right.getEntity().getName();
        if (this.right.getCMRFieldName() != null) {
            defaultTableName = defaultTableName + "_" + this.right.getCMRFieldName();
        }
        return defaultTableName;
    }

    public JDBCTypeMappingMetaData getTypeMapping() {
        return this.datasourceMapping;
    }

    public void setLeft(JDBCRelationshipRoleMetaData jdbcRelationshipRoleMetaData) {
        this.left = jdbcRelationshipRoleMetaData;
    }

    public void setRight(JDBCRelationshipRoleMetaData jdbcRelationshipRoleMetaData) {
        this.left = jdbcRelationshipRoleMetaData;
    }

    private boolean isManyToMany() {
        return this.left.isMultiplicityMany() && this.right.isMultiplicityMany();
    }

    public static enum MappingStyle {
        TABLE,
        FOREIGN_KEY;

    }
}

