/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.sql.DataSource;
import org.jboss.as.cmp.CmpConfig;
import org.jboss.as.cmp.CmpLogger;
import org.jboss.as.cmp.CmpMessages;
import org.jboss.as.cmp.bridge.EntityBridgeInvocationHandler;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.ejbql.Catalog;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.JDBCQueryCommand;
import org.jboss.as.cmp.jdbc.JDBCStartCommand;
import org.jboss.as.cmp.jdbc.JDBCStopCommand;
import org.jboss.as.cmp.jdbc.JDBCStoreManager;
import org.jboss.as.cmp.jdbc.JDBCTypeFactory;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.as.cmp.jdbc2.ApplicationPkCreateCommand;
import org.jboss.as.cmp.jdbc2.CreateCommand;
import org.jboss.as.cmp.jdbc2.PersistentContext;
import org.jboss.as.cmp.jdbc2.QueryCommand;
import org.jboss.as.cmp.jdbc2.QueryFactory;
import org.jboss.as.cmp.jdbc2.bridge.EJBSelectBridge;
import org.jboss.as.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.as.cmp.jdbc2.schema.EntityTable;
import org.jboss.as.cmp.jdbc2.schema.Schema;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactory;
import org.jboss.as.cmp.keygenerator.KeyGeneratorFactoryRegistry;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.TransactionLocal;

public class JDBCStoreManager2
implements JDBCEntityPersistenceStore {
    private final DeploymentUnit deploymentUnit;
    private CmpEntityBeanComponent component;
    private final JDBCEntityMetaData metaData;
    private final CmpConfig cmpConfig;
    private Logger log;
    private JDBCEntityBridge2 entityBridge;
    private EntityBridgeInvocationHandler bridgeInvocationHandler;
    private JDBCTypeFactory typeFactory;
    private Schema schema;
    private Catalog catalog;
    private final InjectedValue<KeyGeneratorFactoryRegistry> keyGeneratorFactoryRegistry = new InjectedValue();
    private QueryFactory queryFactory;
    private CreateCommand createCmd;
    private JDBCStartCommand startCmd;
    private JDBCStopCommand stop;
    private final TransactionLocal cascadeDeleteRegistry = new TransactionLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    public static final AttachmentKey<Schema> SCHEMA = AttachmentKey.create(Schema.class);
    private static final AttachmentKey<AttachmentList<JDBCStoreManager2>> CREATED_MANAGERS = AttachmentKey.createList(JDBCStoreManager2.class);

    public JDBCStoreManager2(DeploymentUnit deploymentUnit, JDBCEntityMetaData metaData, CmpConfig cmpConfig, Catalog catalog) {
        this.deploymentUnit = deploymentUnit;
        this.metaData = metaData;
        this.catalog = catalog;
        this.cmpConfig = cmpConfig;
    }

    public Schema getSchema() {
        this.schema = (Schema)this.deploymentUnit.getAttachment(SCHEMA);
        if (this.schema == null) {
            this.schema = new Schema(this.component.getComponentName());
            this.deploymentUnit.putAttachment(SCHEMA, (Object)this.schema);
        }
        return this.schema;
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public boolean registerCascadeDelete(Object key, Object value) {
        Map map = (Map)this.cascadeDeleteRegistry.get();
        return map.put(key, value) == null;
    }

    public boolean isCascadeDeleted(Object key) {
        Map map = (Map)this.cascadeDeleteRegistry.get();
        return map.containsKey(key);
    }

    public void unregisterCascadeDelete(Object key) {
        Map map = (Map)this.cascadeDeleteRegistry.get();
        map.remove(key);
    }

    public void init(CmpEntityBeanComponent component) {
        this.component = component;
        this.deploymentUnit.addToAttachmentList(CREATED_MANAGERS, (Object)this);
        try {
            this.initStoreManager();
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.failedToInitStoreManager(e);
        }
        this.entityBridge.resolveRelationships();
        try {
            this.startStoreManager();
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.failedToStartStoreManagerRuntime(e);
        }
        this.startCmd.addForeignKeyConstraints();
    }

    public void stop() {
        if (this.stop != null) {
            List managers = (List)this.deploymentUnit.getAttachment(CREATED_MANAGERS);
            while (managers != null && !managers.isEmpty()) {
                int stoppedInIteration = 0;
                Iterator i = managers.iterator();
                while (i.hasNext()) {
                    JDBCStoreManager2 manager = (JDBCStoreManager2)i.next();
                    if (!manager.stop.execute()) continue;
                    i.remove();
                    try {
                        manager.entityBridge.stop();
                    }
                    catch (Exception e) {
                        CmpLogger.ROOT_LOGGER.failedToStopEntityBridge(e);
                    }
                    ++stoppedInIteration;
                }
                if (stoppedInIteration != 0) continue;
                break;
            }
        }
    }

    @Override
    public JDBCAbstractEntityBridge getEntityBridge() {
        return this.entityBridge;
    }

    @Override
    public JDBCEntityMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public JDBCTypeFactory getJDBCTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public CmpEntityBeanComponent getComponent() {
        return this.component;
    }

    @Override
    public Object createBeanClassInstance() throws Exception {
        return null;
    }

    @Override
    public void initEntity(CmpEntityBeanContext ctx) {
        this.entityBridge.initPersistenceContext(ctx);
        this.entityBridge.initInstance(ctx);
    }

    @Override
    public Object createEntity(Method m, Object[] args, CmpEntityBeanContext ctx) throws CreateException {
        return this.createCmd.execute(m, args, ctx);
    }

    @Override
    public Object postCreateEntity(Method m, Object[] args, CmpEntityBeanContext ctx) throws CreateException {
        return null;
    }

    @Override
    public Object findEntity(Method finderMethod, Object[] args, CmpEntityBeanContext instance, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        QueryCommand query = this.queryFactory.getQueryCommand(finderMethod);
        return query.fetchOne(this.schema, args, factory);
    }

    @Override
    public Collection findEntities(Method finderMethod, Object[] args, CmpEntityBeanContext instance, JDBCQueryCommand.EntityProxyFactory factory) throws FinderException {
        QueryCommand query = this.queryFactory.getQueryCommand(finderMethod);
        return query.fetchCollection(this.schema, args, factory);
    }

    @Override
    public void activateEntity(CmpEntityBeanContext ctx) {
        this.entityBridge.initPersistenceContext(ctx);
    }

    @Override
    public void loadEntity(CmpEntityBeanContext ctx) {
        try {
            EntityTable.Row row = this.entityBridge.getTable().loadRow(ctx.getPrimaryKey());
            PersistentContext pctx = new PersistentContext(this.entityBridge, row);
            ctx.setPersistenceContext(pctx);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw CmpMessages.MESSAGES.failedToLoadEntity(this.entityBridge.getEntityName(), ctx.getPrimaryKey(), e);
        }
    }

    @Override
    public boolean isStoreRequired(CmpEntityBeanContext instance) {
        return this.entityBridge.isStoreRequired(instance);
    }

    @Override
    public boolean isModified(CmpEntityBeanContext instance) throws Exception {
        return this.entityBridge.isModified(instance);
    }

    @Override
    public void storeEntity(CmpEntityBeanContext instance) {
    }

    @Override
    public void passivateEntity(CmpEntityBeanContext ctx) {
        JDBCEntityBridge2.destroyPersistenceContext(ctx);
    }

    @Override
    public void removeEntity(CmpEntityBeanContext ctx) throws RemoveException {
        this.entityBridge.remove(ctx);
        PersistentContext pctx = (PersistentContext)ctx.getPersistenceContext();
        pctx.remove();
    }

    protected void initStoreManager() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing CMP plugin for " + this.component.getComponentName()));
        }
        this.typeFactory = new JDBCTypeFactory(this.metaData.getTypeMapping(), this.metaData.getJDBCApplication().getValueClasses(), this.metaData.getJDBCApplication().getUserTypeMappings());
        this.entityBridge = new JDBCEntityBridge2(this, this.metaData);
        this.entityBridge.init();
        Catalog catalog = this.getCatalog();
        catalog.addEntity(this.entityBridge);
        this.stop = new JDBCStopCommand(this);
    }

    protected void startStoreManager() throws Exception {
        this.queryFactory = new QueryFactory(this.entityBridge);
        this.queryFactory.init();
        this.bridgeInvocationHandler = new EntityBridgeInvocationHandler(JDBCStoreManager2.createFieldMap(this.entityBridge), JDBCStoreManager2.createSelectorMap(this.entityBridge, this.queryFactory));
        this.startCmd = new JDBCStartCommand(this);
        this.startCmd.execute();
        JDBCEntityCommandMetaData entityCommand = this.getMetaData().getEntityCommand();
        if (entityCommand == null || "default".equals(entityCommand.getCommandName())) {
            this.createCmd = new ApplicationPkCreateCommand();
        } else {
            Class<?> cmdClass = entityCommand.getCommandClass();
            if (cmdClass == null) {
                throw CmpMessages.MESSAGES.entityCommandClassNotSpecified(this.entityBridge.getEntityName());
            }
            try {
                this.createCmd = (CreateCommand)cmdClass.newInstance();
            }
            catch (ClassCastException cce) {
                throw CmpMessages.MESSAGES.entityCommandNotValidClass(cmdClass.getName(), CreateCommand.class.getName());
            }
        }
        this.createCmd.init(this);
    }

    @Override
    public CmpConfig getCmpConfig() {
        return this.cmpConfig;
    }

    @Override
    public DataSource getDataSource(String name) {
        return null;
    }

    @Override
    public boolean hasCreateTable(String entityName) {
        List tables = (List)this.deploymentUnit.getAttachment(JDBCStoreManager.CREATE_TABLES);
        return tables != null && tables.contains(entityName);
    }

    @Override
    public void addCreateTable(String entityName) {
        this.deploymentUnit.addToAttachmentList(JDBCStoreManager.CREATE_TABLES, (Object)entityName);
    }

    @Override
    public void addExistingTable(String entityName) {
        this.deploymentUnit.addToAttachmentList(JDBCStoreManager.EXISTING_TABLES, (Object)entityName);
    }

    @Override
    public EntityBridgeInvocationHandler getInvocationHandler() {
        return this.bridgeInvocationHandler;
    }

    private static Map<String, Method> getAbstractAccessors(Class<?> beanClass) {
        Method[] methods = beanClass.getMethods();
        HashMap<String, Method> abstractAccessors = new HashMap<String, Method>(methods.length);
        for (Method method : methods) {
            String methodName;
            if (!Modifier.isAbstract(method.getModifiers()) || !(methodName = method.getName()).startsWith("get") && !methodName.startsWith("set")) continue;
            abstractAccessors.put(methodName, method);
        }
        return abstractAccessors;
    }

    private static Map<String, EntityBridgeInvocationHandler.BridgeInvoker> createFieldMap(JDBCEntityBridge2 entityBridge) {
        Map<String, Method> abstractAccessors = JDBCStoreManager2.getAbstractAccessors(entityBridge.getMetaData().getEntityClass());
        List<FieldBridge> fields = entityBridge.getFields();
        HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker> map = new HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker>(fields.size() * 2);
        for (FieldBridge field : fields) {
            String fieldName = field.getFieldName();
            String fieldBaseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String getterName = "get" + fieldBaseName;
            String setterName = "set" + fieldBaseName;
            Method getterMethod = abstractAccessors.get(getterName);
            Method setterMethod = abstractAccessors.get(setterName);
            if (getterMethod != null && setterMethod == null) {
                throw CmpMessages.MESSAGES.getterButNoSetterForField(fieldName);
            }
            if (getterMethod == null && setterMethod != null) {
                throw CmpMessages.MESSAGES.setterButNoGetterForField(fieldName);
            }
            if (getterMethod == null || setterMethod == null) continue;
            map.put(getterMethod.getName(), new EntityBridgeInvocationHandler.FieldGetInvoker(field));
            map.put(setterMethod.getName(), new EntityBridgeInvocationHandler.FieldSetInvoker(field));
            abstractAccessors.remove(getterName);
            abstractAccessors.remove(setterName);
        }
        return Collections.unmodifiableMap(map);
    }

    private static Map<Method, EntityBridgeInvocationHandler.BridgeInvoker> createSelectorMap(JDBCEntityBridge2 entityBridge, QueryFactory queryFactory) {
        Collection<JDBCQueryMetaData> queries = entityBridge.getMetaData().getQueries();
        HashMap<Method, EntityBridgeInvocationHandler.BridgeInvoker> selectorsByMethod = new HashMap<Method, EntityBridgeInvocationHandler.BridgeInvoker>(queries.size());
        for (JDBCQueryMetaData metadata : queries) {
            if (!metadata.getMethod().getName().startsWith("ejbSelect")) continue;
            try {
                QueryCommand queryCommand = queryFactory.getQueryCommand(metadata.getMethod());
                Schema schema = ((JDBCStoreManager2)entityBridge.getManager()).getSchema();
                EJBSelectBridge ejbSelectBridge = new EJBSelectBridge((JDBCStoreManager2)entityBridge.getManager(), entityBridge.getComponent(), schema, metadata, queryCommand);
                selectorsByMethod.put(metadata.getMethod(), ejbSelectBridge);
            }
            catch (FinderException e) {
                throw new RuntimeException(e);
            }
        }
        return selectorsByMethod;
    }

    @Override
    public KeyGeneratorFactory getKeyGeneratorFactory(String name) {
        return ((KeyGeneratorFactoryRegistry)this.keyGeneratorFactoryRegistry.getValue()).getFactory(name);
    }

    public Injector<KeyGeneratorFactoryRegistry> getKeyGeneratorFactoryInjector() {
        return this.keyGeneratorFactoryRegistry;
    }
}

