/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.configadmin.parser.ConfigAdminExtension;
import org.jboss.as.configadmin.parser.ConfigAdminProviders;
import org.jboss.as.configadmin.service.ConfigAdminServiceImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ConfigurationUpdate
implements OperationStepHandler {
    static final ConfigurationUpdate INSTANCE = new ConfigurationUpdate();
    static DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ModelNode node = new ModelNode();
            ResourceBundle resbundle = ConfigAdminProviders.getResourceBundle(locale);
            node.get("operation-name").set("update");
            node.get("description").set(resbundle.getString("configuration.update"));
            node.get(new String[]{"request-properties", "entries", "description"}).set(resbundle.getString("configuration.entries"));
            node.get(new String[]{"request-properties", "entries", "type"}).set(ModelType.LIST);
            node.get(new String[]{"request-properties", "entries", "required"}).set(true);
            node.get(new String[]{"request-properties", "entries", "value-type"}).set(ModelType.PROPERTY);
            node.get("reply-properties").setEmptyObject();
            return node;
        }
    };

    private ConfigurationUpdate() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        resource.getModel().get("entries").set(operation.get("entries"));
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode entries = operation.get("entries");
                String pid = operation.get("address").asObject().get("configuration").asString();
                Hashtable<String, String> dictionary = new Hashtable<String, String>();
                for (String key : entries.keys()) {
                    ((Dictionary)dictionary).put(key, entries.get(key).asString());
                }
                ConfigAdminServiceImpl configAdmin = ConfigAdminExtension.getConfigAdminService(context);
                if (configAdmin != null) {
                    configAdmin.putConfigurationFromDMR(pid, dictionary);
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

