/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    VERSION_1_0("urn:jboss:domain:configadmin:1.0");

    static final Namespace CURRENT;
    private final String name;
    static final EnumSet<Namespace> STANDARD_NAMESPACES;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    String getUriString() {
        return this.name;
    }

    static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = VERSION_1_0;
        STANDARD_NAMESPACES = EnumSet.complementOf(EnumSet.of(UNKNOWN));
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

