/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.deployment.DeploymentPhases;
import org.jboss.as.deployment.attachment.VirtualFileAttachment;
import org.jboss.as.deployment.unit.DeploymentUnitContext;
import org.jboss.as.deployment.unit.DeploymentUnitProcessingException;
import org.jboss.as.deployment.unit.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.ra.RaParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class RaDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public static final long PRIORITY = DeploymentPhases.PARSE_DESCRIPTORS.plus(500L);

    public void processDeployment(DeploymentUnitContext context) throws DeploymentUnitProcessingException {
        VirtualFile deploymentRoot = VirtualFileAttachment.getVirtualFileAttachment((DeploymentUnitContext)context);
        if (deploymentRoot == null || !deploymentRoot.exists()) {
            return;
        }
        String deploymentRootName = deploymentRoot.getName();
        VirtualFile serviceXmlFile = null;
        if (deploymentRootName.endsWith(".rar")) {
            serviceXmlFile = deploymentRoot.getChild("/META-INF/ra.xml");
        }
        InputStream xmlStream = null;
        Connector result = null;
        try {
            if (serviceXmlFile != null && serviceXmlFile.exists() && (result = new RaParser().parse(xmlStream = serviceXmlFile.openStream())) == null) {
                throw new DeploymentUnitProcessingException("Failed to parse service xml [" + serviceXmlFile + "]");
            }
            File root = deploymentRoot.getPhysicalFile();
            URL url = root.toURI().toURL();
            String deploymentName = deploymentRoot.getName().substring(0, deploymentRoot.getName().indexOf(".rar"));
            ConnectorXmlDescriptor xmlDescriptor = new ConnectorXmlDescriptor(result, root, url, deploymentName);
            context.putAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
        }
        catch (Exception e) {
            try {
                throw new DeploymentUnitProcessingException("Failed to parse service xml [" + serviceXmlFile + "]", (Throwable)e);
            }
            catch (Throwable throwable) {
                VFSUtils.safeClose(xmlStream);
                throw throwable;
            }
        }
        VFSUtils.safeClose((Closeable)xmlStream);
    }
}

