/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.connector;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.connector.subsystems.connector.Attribute;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemAdd;
import org.jboss.as.connector.subsystems.connector.ConnectorSubsystemElement;
import org.jboss.as.connector.subsystems.connector.Element;
import org.jboss.as.connector.subsystems.connector.Namespace;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class ConnectorSubsystemElementParser
implements XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<ConnectorSubsystemElement>>> {
    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<ConnectorSubsystemElement>> result) throws XMLStreamException {
        ConnectorSubsystemAdd add = new ConnectorSubsystemAdd();
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case CONNECTOR_1_0: {
                    Element element = Element.forName(reader.getLocalName());
                    if (!visited.add(element)) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    EnumSet<Element> requiredElement = EnumSet.of(Element.DEFAULT_WORKMANAGER);
                    switch (element) {
                        case ARCHIVE_VALIDATION: {
                            int cnt = reader.getAttributeCount();
                            block18: for (int i = 0; i < cnt; ++i) {
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case ENABLED: {
                                        add.setArchiveValidation(Boolean.parseBoolean(reader.getAttributeValue(i)));
                                        continue block18;
                                    }
                                    case FAIL_ON_ERROR: {
                                        add.setArchiveValidationFailOnError(Boolean.parseBoolean(reader.getAttributeValue(i)));
                                        continue block18;
                                    }
                                    case FAIL_ON_WARN: {
                                        add.setArchiveValidationFailOnWarn(Boolean.parseBoolean(reader.getAttributeValue(i)));
                                        continue block18;
                                    }
                                    default: {
                                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                                    }
                                }
                            }
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            break;
                        }
                        case BEAN_VALIDATION: {
                            boolean enabled = ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ENABLED.getLocalName());
                            add.setBeanValidation(enabled);
                            break;
                        }
                        case DEFAULT_WORKMANAGER: {
                            EnumSet<Attribute> required = EnumSet.of(Attribute.SHORT_RUNNING_THREAD_POOL, Attribute.LONG_RUNNING_THREAD_POOL);
                            int cnt = reader.getAttributeCount();
                            block19: for (int i = 0; i < cnt; ++i) {
                                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                                switch (attribute) {
                                    case SHORT_RUNNING_THREAD_POOL: {
                                        add.setShortRunningThreadPool(reader.getAttributeValue(i));
                                        required.remove((Object)Attribute.SHORT_RUNNING_THREAD_POOL);
                                        continue block19;
                                    }
                                    case LONG_RUNNING_THREAD_POOL: {
                                        add.setLongRunningThreadPool(reader.getAttributeValue(i));
                                        required.remove((Object)Attribute.LONG_RUNNING_THREAD_POOL);
                                    }
                                }
                            }
                            if (!required.isEmpty()) {
                                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
                            }
                            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                            requiredElement.remove((Object)Element.DEFAULT_WORKMANAGER);
                            break;
                        }
                        default: {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                    }
                    if (requiredElement.isEmpty()) continue block17;
                    ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, requiredElement);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)add, new AbstractSubsystemUpdate[0]));
    }
}

