/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.adapters.jdbc.util;

import java.util.HashMap;
import java.util.Map;

public class LRUCachePolicy {
    protected Map map;
    protected LRUList lruList;
    protected int maxCapacity;
    protected int minCapacity;

    public LRUCachePolicy() {
    }

    public LRUCachePolicy(int min, int max) {
        if (min < 2 || min > max) {
            throw new IllegalArgumentException("Illegal cache capacities");
        }
        this.minCapacity = min;
        this.maxCapacity = max;
    }

    protected Map createMap() {
        return new HashMap();
    }

    public void create() {
        this.map = this.createMap();
        this.lruList = this.createList();
        this.lruList.maxCapacity = this.maxCapacity;
        this.lruList.minCapacity = this.minCapacity;
        this.lruList.capacity = this.maxCapacity;
    }

    public void start() {
    }

    public void stop() {
        if (this.lruList != null) {
            this.flush();
        }
    }

    public void destroy() {
        if (this.map != null) {
            this.map.clear();
        }
        if (this.lruList != null) {
            this.lruList.clear();
        }
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        LRUCacheEntry value = (LRUCacheEntry)this.map.get(key);
        if (value != null) {
            this.lruList.promote(value);
            return value.object;
        }
        this.cacheMiss();
        return null;
    }

    public Object peek(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        LRUCacheEntry value = (LRUCacheEntry)this.map.get(key);
        if (value == null) {
            return null;
        }
        return value.object;
    }

    public void insert(Object key, Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot insert a null object in the cache");
        }
        if (key == null) {
            throw new IllegalArgumentException("Cannot insert an object in the cache with null key");
        }
        if (this.map.containsKey(key)) {
            throw new IllegalStateException("Attempt to put in the cache an object that is already there");
        }
        this.lruList.demote();
        LRUCacheEntry entry = this.createCacheEntry(key, o);
        this.map.put(key, entry);
        this.lruList.promote(entry);
    }

    public void remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Removing an object using a null key");
        }
        Object value = this.map.remove(key);
        if (value != null) {
            this.lruList.remove((LRUCacheEntry)value);
        }
    }

    public void flush() {
        LRUCacheEntry entry = null;
        while ((entry = this.lruList.tail) != null) {
            this.ageOut(entry);
        }
    }

    public int size() {
        return this.lruList.count;
    }

    protected LRUList createList() {
        return new LRUList();
    }

    protected void ageOut(LRUCacheEntry entry) {
        this.remove(entry.key);
    }

    protected void cacheMiss() {
    }

    protected LRUCacheEntry createCacheEntry(Object key, Object value) {
        return new LRUCacheEntry(key, value);
    }

    public class LRUCacheEntry {
        private LRUCacheEntry next;
        private LRUCacheEntry prev;
        private Object key;
        private Object object;
        private long time;

        protected LRUCacheEntry(Object key, Object object) {
            this.key = key;
            this.object = object;
            this.next = null;
            this.prev = null;
            this.time = 0L;
        }

        public String toString() {
            return "key: " + this.key + ", object: " + (this.object == null ? "null" : Integer.toHexString(this.object.hashCode())) + ", entry: " + Integer.toHexString(super.hashCode());
        }

        public final LRUCacheEntry getNext() {
            return this.next;
        }

        public final void setNext(LRUCacheEntry next) {
            this.next = next;
        }

        public final LRUCacheEntry getPrev() {
            return this.prev;
        }

        public final void setPrev(LRUCacheEntry prev) {
            this.prev = prev;
        }

        public final Object getKey() {
            return this.key;
        }

        public final void setKey(Object key) {
            this.key = key;
        }

        public final Object getObject() {
            return this.object;
        }

        public final void setObject(Object object) {
            this.object = object;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long time) {
            this.time = time;
        }
    }

    public class LRUList {
        private int maxCapacity;
        private int minCapacity;
        private int capacity;
        private int count = 0;
        private LRUCacheEntry head = null;
        private LRUCacheEntry tail = null;
        private int cacheMiss;

        protected LRUList() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void promote(LRUCacheEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException("Trying to promote a null object");
            }
            if (this.capacity < 1) {
                throw new IllegalStateException("Can't work with capacity < 1");
            }
            this.entryPromotion(entry);
            entry.time = System.currentTimeMillis();
            if (entry.prev == null) {
                if (entry.next != null) return;
                if (this.count == 0) {
                    this.head = entry;
                    this.tail = entry;
                    ++this.count;
                    this.entryAdded(entry);
                    return;
                } else {
                    if (this.count == 1 && this.head == entry) return;
                    if (this.count < this.capacity) {
                        entry.prev = null;
                        entry.next = this.head;
                        this.head.prev = entry;
                        this.head = entry;
                        ++this.count;
                        this.entryAdded(entry);
                        return;
                    } else {
                        if (this.count >= this.maxCapacity) throw new IllegalStateException("Attempt to put a new cache entry on a full cache");
                        entry.prev = null;
                        entry.next = this.head;
                        this.head.prev = entry;
                        this.head = entry;
                        ++this.count;
                        int oldCapacity = this.capacity++;
                        this.entryAdded(entry);
                        this.capacityChanged(oldCapacity);
                    }
                }
                return;
            } else if (entry.next == null) {
                LRUCacheEntry beforeLast = entry.prev;
                beforeLast.next = null;
                entry.prev = null;
                entry.next = this.head;
                this.head.prev = entry;
                this.head = entry;
                this.tail = beforeLast;
                return;
            } else {
                LRUCacheEntry previous = entry.prev;
                previous.next = entry.next;
                entry.next.prev = previous;
                entry.prev = null;
                entry.next = this.head;
                this.head.prev = entry;
                this.head = entry;
            }
        }

        protected void demote() {
            if (this.capacity < 1) {
                throw new IllegalStateException("Can't work with capacity < 1");
            }
            if (this.count > this.maxCapacity) {
                throw new IllegalStateException("Cache list entries number (" + this.count + ") > than the maximum allowed (" + this.maxCapacity + ")");
            }
            if (this.count == this.maxCapacity) {
                LRUCacheEntry entry = this.tail;
                LRUCachePolicy.this.ageOut(entry);
            }
        }

        protected void remove(LRUCacheEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException("Cannot remove a null entry from the cache");
            }
            if (this.count < 1) {
                throw new IllegalStateException("Trying to remove an entry from an empty cache");
            }
            entry.key = null;
            entry.object = null;
            if (this.count == 1) {
                this.head = null;
                this.tail = null;
            } else if (entry.prev == null) {
                this.head = entry.next;
                this.head.prev = null;
                entry.next = null;
            } else if (entry.next == null) {
                this.tail = entry.prev;
                this.tail.next = null;
                entry.prev = null;
            } else {
                entry.next.prev = entry.prev;
                entry.prev.next = entry.next;
                entry.prev = null;
                entry.next = null;
            }
            --this.count;
            this.entryRemoved(entry);
        }

        protected void entryPromotion(LRUCacheEntry entry) {
        }

        protected void entryAdded(LRUCacheEntry entry) {
        }

        protected void entryRemoved(LRUCacheEntry entry) {
        }

        protected void capacityChanged(int oldCapacity) {
        }

        protected void clear() {
            LRUCacheEntry entry = this.head;
            this.head = null;
            this.tail = null;
            this.count = 0;
            while (entry != null) {
                this.entryRemoved(entry);
                entry = entry.next;
            }
        }

        public String toString() {
            String s = Integer.toHexString(super.hashCode());
            s = s + " size: " + this.count;
            LRUCacheEntry entry = this.head;
            while (entry != null) {
                s = s + "\n" + entry;
                entry = entry.next;
            }
            return s;
        }

        public final int getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(int maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final int getMinCapacity() {
            return this.minCapacity;
        }

        public final void setMinCapacity(int minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final int getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int count) {
            this.count = count;
        }

        public final LRUCacheEntry getHead() {
            return this.head;
        }

        public final void setHead(LRUCacheEntry head) {
            this.head = head;
        }

        public final LRUCacheEntry getTail() {
            return this.tail;
        }

        public final void setTail(LRUCacheEntry tail) {
            this.tail = tail;
        }

        public final int getCacheMiss() {
            return this.cacheMiss;
        }

        public final void setCacheMiss(int cacheMiss) {
            this.cacheMiss = cacheMiss;
        }
    }
}

