/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.subsystems.resourceadapters.Namespace;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ResourceAdaptersSubsystemProviders {
    static final String[] RESOURCEADAPTER_ATTRIBUTE = new String[]{"archive", "transaction-support", "bootstrapcontext", "beanvalidationgroups", "connection-definitions", "admin-objects"};
    static final NodeAttribute[] CONNECTIONDEFINITIONS_NODEATTRIBUTE = new NodeAttribute[]{new NodeAttribute("class-name", ModelType.STRING, true), new NodeAttribute("jndi-name", ModelType.STRING, true), new NodeAttribute("pool-name", ModelType.STRING, false), new NodeAttribute("use-java-context", ModelType.BOOLEAN, false), new NodeAttribute("enabled", ModelType.BOOLEAN, false), new NodeAttribute("max-pool-size", ModelType.INT, false), new NodeAttribute("min-pool-size", ModelType.INT, false), new NodeAttribute("pool-use-strict-min", ModelType.BOOLEAN, false), new NodeAttribute("security-domain-and-application", ModelType.STRING, false), new NodeAttribute("security-application", ModelType.STRING, false), new NodeAttribute("security-domain", ModelType.STRING, false), new NodeAttribute("allocation-retry", ModelType.BOOLEAN, false), new NodeAttribute("allocation-retry-wait-millis", ModelType.LONG, false), new NodeAttribute("blocking-timeout-wait-millis", ModelType.LONG, false), new NodeAttribute("idle-timeout-minutes", ModelType.INT, false), new NodeAttribute("xa-resource-timeout", ModelType.LONG, false), new NodeAttribute("use-try-lock", ModelType.BOOLEAN, false), new NodeAttribute("background-validation-minutes", ModelType.INT, false), new NodeAttribute("background-validation", ModelType.BOOLEAN, false), new NodeAttribute("use-fast-fail", ModelType.BOOLEAN, false)};
    static final NodeAttribute[] ADMIN_OBJECTS_NODEATTRIBUTE = new NodeAttribute[]{new NodeAttribute("class-name", ModelType.STRING, true), new NodeAttribute("jndi-name", ModelType.STRING, true), new NodeAttribute("pool-name", ModelType.STRING, false), new NodeAttribute("use-java-context", ModelType.BOOLEAN, false), new NodeAttribute("enabled", ModelType.BOOLEAN, false)};
    static final String RESOURCE_NAME = ResourceAdaptersSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("resource-adapters-subsystem"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.RESOURCEADAPTERS_1_0.getUriString());
            ModelNode resourceAdaptersNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("resource-adapters");
            ModelNode connectionDefinitionsNode = new ModelNode();
            connectionDefinitionsNode.get("head-comment-allowed").set(true);
            connectionDefinitionsNode.get("tail-comment-allowed").set(true);
            connectionDefinitionsNode.get("description").set("connection-definitions");
            for (NodeAttribute attribute : CONNECTIONDEFINITIONS_NODEATTRIBUTE) {
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "type"}).set(attribute.getModelType());
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            resourceAdaptersNode.get("connection-definitions").set(connectionDefinitionsNode);
            subsystem.get("resource-adapter").set(resourceAdaptersNode);
            ModelNode adminObjectNode = new ModelNode();
            adminObjectNode.get("head-comment-allowed").set(true);
            adminObjectNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("admin-objects");
            for (NodeAttribute attribute : ADMIN_OBJECTS_NODEATTRIBUTE) {
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "type"}).set(attribute.getModelType());
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            resourceAdaptersNode.get("admin-objects").set(adminObjectNode);
            resourceAdaptersNode.get(new String[]{"attributes", "archive", "description"}).set(bundle.getString("archive"));
            resourceAdaptersNode.get(new String[]{"attributes", "archive", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "archive", "required"}).set(true);
            resourceAdaptersNode.get(new String[]{"attributes", "transaction-support", "description"}).set(bundle.getString("transaction-support"));
            resourceAdaptersNode.get(new String[]{"attributes", "transaction-support", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "transaction-support", "required"}).set(false);
            resourceAdaptersNode.get(new String[]{"attributes", "config-properties", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "config-properties", "required"}).set(false);
            resourceAdaptersNode.get(new String[]{"attributes", "beanvalidationgroups", "description"}).set(bundle.getString("beanvalidationgroups"));
            resourceAdaptersNode.get(new String[]{"attributes", "beanvalidationgroups", "type"}).set(ModelType.STRING);
            resourceAdaptersNode.get(new String[]{"attributes", "beanvalidationgroups", "required"}).set(false);
            subsystem.get("resource-adapter").set(resourceAdaptersNode);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ResourceAdaptersSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("resource-adapters-subsystem"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.RESOURCEADAPTERS_1_0.getUriString());
            ModelNode resourceAdaptersNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("resource-adapters");
            ModelNode connectionDefinitionsNode = new ModelNode();
            connectionDefinitionsNode.get("head-comment-allowed").set(true);
            connectionDefinitionsNode.get("tail-comment-allowed").set(true);
            connectionDefinitionsNode.get("description").set("connection-definitions");
            for (NodeAttribute attribute : CONNECTIONDEFINITIONS_NODEATTRIBUTE) {
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "type"}).set(attribute.getModelType());
                connectionDefinitionsNode.get(new String[]{"attributes", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            resourceAdaptersNode.get("connection-definitions").set(connectionDefinitionsNode);
            subsystem.get("resource-adapter").set(resourceAdaptersNode);
            ModelNode adminObjectNode = new ModelNode();
            adminObjectNode.get("head-comment-allowed").set(true);
            adminObjectNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("admin-objects");
            for (NodeAttribute attribute : ADMIN_OBJECTS_NODEATTRIBUTE) {
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "description"}).set(bundle.getString(attribute.getName()));
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "type"}).set(attribute.getModelType());
                adminObjectNode.get(new String[]{"attributes", attribute.getName(), "required"}).set(attribute.isRequired());
            }
            resourceAdaptersNode.get("admin-objects").set(adminObjectNode);
            ModelNode archiveNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("archive");
            ModelNode transactionSupportNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("transaction-support");
            ModelNode bootstrapSupportNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("bootstrapcontext");
            ModelNode configPropertiesNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("config-properties");
            ModelNode beanValidationNode = new ModelNode();
            resourceAdaptersNode.get("head-comment-allowed").set(true);
            resourceAdaptersNode.get("tail-comment-allowed").set(true);
            resourceAdaptersNode.get("description").set("beanvalidationgroups");
            resourceAdaptersNode.get("archive").set(archiveNode);
            resourceAdaptersNode.get("transaction-support").set(transactionSupportNode);
            resourceAdaptersNode.get("bootstrapcontext").set(bootstrapSupportNode);
            resourceAdaptersNode.get("config-properties").set(configPropertiesNode);
            resourceAdaptersNode.get("beanvalidationgroups").set(beanValidationNode);
            subsystem.get("resource-adapter").set(resourceAdaptersNode);
            return subsystem;
        }
    };

    ResourceAdaptersSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    static class NodeAttribute {
        private final String name;
        private final ModelType modelType;
        private final boolean required;

        public NodeAttribute(String name, ModelType modelType, boolean required) {
            this.name = name;
            this.modelType = modelType;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public ModelType getModelType() {
            return this.modelType;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "NodeAttribute [name=" + this.name + ", modelType=" + this.modelType + ", required=" + this.required + "]";
        }
    }
}

