/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.connector.subsystems.jca.ArchiveValidationAdd;
import org.jboss.as.connector.subsystems.jca.BeanValidationAdd;
import org.jboss.as.connector.subsystems.jca.BootstrapContextAdd;
import org.jboss.as.connector.subsystems.jca.CachedConnectionManagerAdd;
import org.jboss.as.connector.subsystems.jca.Namespace;
import org.jboss.as.connector.subsystems.jca.WorkManagerAdd;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.dmr.ModelNode;

class JcaSubsystemProviders {
    static final String RESOURCE_NAME = JcaSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("jca"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.JCA_1_1.getUriString());
            subsystem.get(new String[]{"children", "archive-validation", "description"}).set(bundle2.getString("jca.archive-validation"));
            subsystem.get(new String[]{"children", "bean-validation", "description"}).set(bundle2.getString("jca.bean-validation"));
            subsystem.get(new String[]{"children", "bootstrap-context", "description"}).set(bundle2.getString("jca.bootstrap-context"));
            subsystem.get(new String[]{"children", "workmanager", "description"}).set(bundle2.getString("jca.workmanager"));
            subsystem.get(new String[]{"children", "cached-connection-manager", "description"}).set(bundle2.getString("jca.cached-connection-manager"));
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle2.getString("jca.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider SUBSYSTEM_REMOVE_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("jca.archive-validation.remove"));
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider ARCHIVE_VALIDATION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode configPropertiesNode = new ModelNode();
            configPropertiesNode.get("head-comment-allowed").set(true);
            configPropertiesNode.get("tail-comment-allowed").set(true);
            configPropertiesNode.get("description").set("jca.archive-validation");
            for (ArchiveValidationAdd.ArchiveValidationParameters parameter : ArchiveValidationAdd.ArchiveValidationParameters.values()) {
                parameter.getAttribute().addResourceAttributeDescription(bundle2, "jca.archive-validation", configPropertiesNode);
            }
            return configPropertiesNode;
        }
    };
    static DescriptionProvider ADD_ARCHIVE_VALIDATION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle2.getString("jca.archive-validation.add"));
            op.get("operation-name").set("add");
            for (ArchiveValidationAdd.ArchiveValidationParameters parameter : ArchiveValidationAdd.ArchiveValidationParameters.values()) {
                parameter.getAttribute().addOperationParameterDescription(bundle2, "jca.archive-validation", op);
            }
            return op;
        }
    };
    static DescriptionProvider REMOVE_ARCHIVE_VALIDATION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("jca.archive-validation.remove"));
            return operation;
        }
    };
    static DescriptionProvider BEAN_VALIDATION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode configPropertiesNode = new ModelNode();
            configPropertiesNode.get("head-comment-allowed").set(true);
            configPropertiesNode.get("tail-comment-allowed").set(true);
            configPropertiesNode.get("description").set("jca.bean-validation");
            for (BeanValidationAdd.BeanValidationParameters parameter : BeanValidationAdd.BeanValidationParameters.values()) {
                parameter.getAttribute().addResourceAttributeDescription(bundle2, "jca.bean-validation", configPropertiesNode);
            }
            return configPropertiesNode;
        }
    };
    static DescriptionProvider ADD_BEAN_VALIDATION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle2.getString("jca.bean-validation.add"));
            op.get("operation-name").set("add");
            for (BeanValidationAdd.BeanValidationParameters parameter : BeanValidationAdd.BeanValidationParameters.values()) {
                parameter.getAttribute().addOperationParameterDescription(bundle2, "jca.bean-validation", op);
            }
            return op;
        }
    };
    static DescriptionProvider REMOVE_BEAN_VALIDATION_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("jca.bean-validation.remove"));
            return operation;
        }
    };
    static DescriptionProvider CACHED_CONNECTION_MANAGER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode configPropertiesNode = new ModelNode();
            configPropertiesNode.get("head-comment-allowed").set(true);
            configPropertiesNode.get("tail-comment-allowed").set(true);
            configPropertiesNode.get("description").set("jca.cached-connection-manager");
            for (CachedConnectionManagerAdd.CcmParameters parameter : CachedConnectionManagerAdd.CcmParameters.values()) {
                parameter.getAttribute().addResourceAttributeDescription(bundle2, "jca.cached-connection-manager", configPropertiesNode);
            }
            return configPropertiesNode;
        }
    };
    static DescriptionProvider ADD_CACHED_CONNECTION_MANAGER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle2.getString("jca.cached-connection-manager.add"));
            op.get("operation-name").set("add");
            for (CachedConnectionManagerAdd.CcmParameters parameter : CachedConnectionManagerAdd.CcmParameters.values()) {
                parameter.getAttribute().addOperationParameterDescription(bundle2, "jca.cached-connection-manager", op);
            }
            return op;
        }
    };
    static DescriptionProvider REMOVE_CACHED_CONNECTION_MANAGER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("jca.cached-connection-manager.remove"));
            return operation;
        }
    };
    static DescriptionProvider WORKMANAGER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode configPropertiesNode = new ModelNode();
            configPropertiesNode.get("head-comment-allowed").set(true);
            configPropertiesNode.get("tail-comment-allowed").set(true);
            configPropertiesNode.get("description").set("jca.workmanager");
            for (WorkManagerAdd.WmParameters parameter : WorkManagerAdd.WmParameters.values()) {
                parameter.getAttribute().addResourceAttributeDescription(bundle2, "jca.workmanager", configPropertiesNode);
            }
            configPropertiesNode.get(new String[]{"children", "long-running-threads", "description"}).set(bundle2.getString("long-running-threads"));
            configPropertiesNode.get(new String[]{"children", "short-running-threads", "description"}).set(bundle2.getString("short-running-threads"));
            return configPropertiesNode;
        }
    };
    static DescriptionProvider ADD_WORKMANAGER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle2.getString("jca.workmanager.add"));
            op.get("operation-name").set("add");
            for (WorkManagerAdd.WmParameters parameter : WorkManagerAdd.WmParameters.values()) {
                parameter.getAttribute().addOperationParameterDescription(bundle2, "jca.workmanager", op);
            }
            return op;
        }
    };
    static DescriptionProvider REMOVE_WORKMANAGER_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("jca.workmanager.remove"));
            return operation;
        }
    };
    static DescriptionProvider BOOTSTRAP_CONTEXT_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode configPropertiesNode = new ModelNode();
            configPropertiesNode.get("head-comment-allowed").set(true);
            configPropertiesNode.get("tail-comment-allowed").set(true);
            configPropertiesNode.get("description").set("jca.bootstrap-context");
            for (BootstrapContextAdd.BootstrapCtxParameters parameter : BootstrapContextAdd.BootstrapCtxParameters.values()) {
                parameter.getAttribute().addResourceAttributeDescription(bundle2, "jca.bootstrap-context", configPropertiesNode);
            }
            return configPropertiesNode;
        }
    };
    static DescriptionProvider ADD_BOOTSTRAP_CONTEXT_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("description").set(bundle2.getString("jca.bootstrap-context.add"));
            op.get("operation-name").set("add");
            for (BootstrapContextAdd.BootstrapCtxParameters parameter : BootstrapContextAdd.BootstrapCtxParameters.values()) {
                parameter.getAttribute().addOperationParameterDescription(bundle2, "jca.bootstrap-context", op);
            }
            return op;
        }
    };
    static DescriptionProvider REMOVE_BOOTSTRAP_CONTEXT_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JcaSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle2.getString("jca.bootstrap-context.remove"));
            return operation;
        }
    };

    JcaSubsystemProviders() {
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

