/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.StatisticsDescriptionProvider;
import org.jboss.as.connector.annotations.repository.jandex.JandexAnnotationRepositoryImpl;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.metadata.xmldescriptors.IronJacamarXmlDescriptor;
import org.jboss.as.connector.pool.PoolMetrics;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.ClearStatisticsHandler;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.subsystems.resourceadapters.ResourceAdaptersSubsystemProviders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.Index;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class ParsedRaDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)phaseContext.getDeploymentUnit().getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        final ManagementResourceRegistration registration = (ManagementResourceRegistration)phaseContext.getDeploymentUnit().getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
        if (connectorXmlDescriptor == null) {
            return;
        }
        final DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        IronJacamarXmlDescriptor ironJacamarXmlDescriptor = (IronJacamarXmlDescriptor)deploymentUnit.getAttachment(IronJacamarXmlDescriptor.ATTACHMENT_KEY);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw ConnectorMessages.MESSAGES.failedToGetModuleAttachment(phaseContext.getDeploymentUnit());
        }
        ModuleClassLoader classLoader = module.getClassLoader();
        Connector cmd = connectorXmlDescriptor != null ? connectorXmlDescriptor.getConnector() : null;
        IronJacamar ijmd = ironJacamarXmlDescriptor != null ? ironJacamarXmlDescriptor.getIronJacamar() : null;
        try {
            Annotations annotator = new Annotations();
            Map indexes = AnnotationIndexUtils.getAnnotationIndexes((DeploymentUnit)deploymentUnit);
            for (Map.Entry entry : indexes.entrySet()) {
                JandexAnnotationRepositoryImpl repository = new JandexAnnotationRepositoryImpl((Index)entry.getValue(), (ClassLoader)classLoader);
                cmd = annotator.merge(cmd, (AnnotationRepository)repository, (ClassLoader)classLoader);
            }
            if (cmd != null) {
                cmd.validate();
                cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)ijmd, cmd);
            }
            ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()});
            ResourceAdapterDeploymentService raDeployementService = new ResourceAdapterDeploymentService(connectorXmlDescriptor, cmd, ijmd, module, null);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(deployerServiceName, (Service)raDeployementService).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, raDeployementService.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, raDeployementService.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, raDeployementService.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, raDeployementService.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, raDeployementService.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, raDeployementService.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, raDeployementService.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, raDeployementService.getCcmInjector()).addDependency(ConnectorServices.IDLE_REMOVER_SERVICE).addDependency(ConnectorServices.CONNECTION_VALIDATOR_SERVICE).addDependency(NamingService.SERVICE_NAME);
            builder.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                    switch (transition) {
                        case STARTING_to_UP: {
                            PoolStatistics poolStats;
                            CommonDeployment deploymentMD = ((ResourceAdapterDeploymentService)controller.getService()).getRaDeployment();
                            if (deploymentMD.getConnectionManagers() == null || deploymentMD.getConnectionManagers()[0].getPool() == null || (poolStats = deploymentMD.getConnectionManagers()[0].getPool().getStatistics()).getNames().size() == 0) break;
                            StatisticsDescriptionProvider statsResourceDescriptionProvider = new StatisticsDescriptionProvider(ResourceAdaptersSubsystemProviders.RESOURCE_NAME, "statistics", new StatisticsPlugin[]{poolStats});
                            PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                            ManagementResourceRegistration overrideRegistration = registration;
                            if (registration.isAllowsOverride()) {
                                overrideRegistration = registration.registerOverrideModel(deploymentUnit.getName(), new OverrideDescriptionProvider(){

                                    public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                                        return Collections.emptyMap();
                                    }

                                    public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                                        return Collections.emptyMap();
                                    }
                                });
                            }
                            if (overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe})) != null) break;
                            ManagementResourceRegistration subRegistration = overrideRegistration.registerSubModel(pe, (DescriptionProvider)statsResourceDescriptionProvider);
                            for (String statName : poolStats.getNames()) {
                                subRegistration.registerMetric(statName, (OperationStepHandler)new PoolMetrics.ParametrizedPoolMetricsHandler((StatisticsPlugin)poolStats));
                            }
                            subRegistration.registerOperationHandler("clear-statistics", (OperationStepHandler)new ClearStatisticsHandler(new StatisticsPlugin[]{poolStats}), ResourceAdaptersSubsystemProviders.CLEAR_STATISTICS_DESC, false);
                            break;
                        }
                        case UP_to_STOP_REQUESTED: {
                            PathElement pe = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
                            ManagementResourceRegistration overrideRegistration = registration.getOverrideModel(deploymentUnit.getName());
                            if (overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{pe})) == null) break;
                            overrideRegistration.unregisterSubModel(pe);
                            break;
                        }
                    }
                }
            });
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

