/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.File;
import java.net.URL;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.SecurityActions;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.jca.common.api.metadata.common.CommonIronJacamar;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class ResourceAdapterXmlDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)"org.jboss.as.connector.deployers.RaXmlDeployer");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final ResourceAdapter raxml;
    private final String deployment;
    private String raName;
    private ServiceName deploymentServiceName;
    private CommonDeployment raxmlDeployment = null;

    public ResourceAdapterXmlDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, ResourceAdapter raxml, Module module, String deployment, ServiceName deploymentServiceName) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.raxml = raxml;
        this.module = module;
        this.deployment = deployment;
        this.raName = raxml.getArchive().substring(0, raxml.getArchive().indexOf(".rar"));
        this.deploymentServiceName = deploymentServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            Connector cmd = ((AS7MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.deployment);
            IronJacamar ijmd = ((AS7MetadataRepository)this.mdr.getValue()).getIronJacamar(this.deployment);
            File root = ((AS7MetadataRepository)this.mdr.getValue()).getRoot(this.deployment);
            cmd = new Merger().mergeConnectorWithCommonIronJacamar((CommonIronJacamar)this.raxml, cmd);
            ServiceContainer container = context.getController().getServiceContainer();
            AS7RaXmlDeployer raDeployer = new AS7RaXmlDeployer(context.getChildTarget(), this.connectorXmlDescriptor.getUrl(), this.raName, root, (ClassLoader)this.module.getClassLoader(), cmd, this.raxml, null, this.deploymentServiceName);
            raDeployer.setConfiguration((Configuration)this.config.getValue());
            try {
                WritableServiceBasedNamingStore.pushOwner((ServiceTarget)container.subTarget(), (ServiceName[])new ServiceName[0]);
                ClassLoader old = SecurityActions.getThreadContextClassLoader();
                try {
                    SecurityActions.setThreadContextClassLoader((ClassLoader)this.module.getClassLoader());
                    this.raxmlDeployment = raDeployer.doDeploy();
                }
                finally {
                    SecurityActions.setThreadContextClassLoader(old);
                    WritableServiceBasedNamingStore.popOwner();
                }
            }
            catch (Throwable t) {
                this.unregisterAll(this.raName);
                throw ConnectorMessages.MESSAGES.failedToStartRaDeployment(t, this.raName);
            }
            this.value = new ResourceAdapterDeployment(this.raxmlDeployment);
            ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
            ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
            ServiceName raServiceName = ConnectorServices.registerResourceAdapter(this.raName);
            context.getChildTarget().addService(raServiceName, (Service)new ResourceAdapterService(this.raName, raServiceName, this.value.getDeployment().getResourceAdapter())).addDependency(this.deploymentServiceName).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Stopping service %s", ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{this.value.getDeployment().getDeploymentName()}));
        this.unregisterAll(this.raName);
    }

    @Override
    public void unregisterAll(String deploymentName) {
        if (this.raName != null && this.deploymentServiceName != null) {
            ConnectorServices.unregisterDeployment(this.raName, this.deploymentServiceName);
        }
        if (this.raName != null) {
            ConnectorServices.unregisterResourceAdapterIdentifier(this.raName);
        }
        super.unregisterAll(deploymentName);
    }

    public CommonDeployment getRaxmlDeployment() {
        return this.raxmlDeployment;
    }

    private class AS7RaXmlDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final ResourceAdapter ra;
        private final IronJacamar ijmd;

        public AS7RaXmlDeployer(ServiceTarget serviceTarget, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, ResourceAdapter ra, IronJacamar ijmd, ServiceName deploymentServiceName) {
            super(serviceTarget, url, deploymentName, root, cl, cmd, deploymentServiceName);
            this.ra = ra;
            this.ijmd = ijmd;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterXmlDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.ijmd, this.ra);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, IronJacamar ijmd) {
            return true;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }
    }
}

