/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.metadata.ds.v10.DataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ParserException;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.ds.DsSecurityImpl;
import org.jboss.jca.common.metadata.ds.v11.DsParser;
import org.jboss.metadata.property.PropertyResolver;

public class DsXmlParser
extends DsParser {
    private final PropertyResolver propertyResolver;

    public DsXmlParser(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    protected DsSecurity parseDsSecurity(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        Extension reauthPlugin = null;
        block10: while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return new DsSecurityImpl(userName, password, securityDomain, reauthPlugin);
                    }
                    if (DsSecurity.Tag.forName((String)reader.getLocalName()) != DsSecurity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    DsSecurity.Tag tag = DsSecurity.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            if (this.propertyResolver == null || password == null) break block0;
                            String resolvedPassword = this.propertyResolver.resolve(password);
                            if (resolvedPassword == null) continue block10;
                            password = resolvedPassword;
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        case REAUTH_PLUGIN: {
                            reauthPlugin = this.parseExtension(reader, tag.getLocalName());
                            break block0;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected Credential parseCredential(XMLStreamReader reader) throws XMLStreamException, ParserException, ValidateException {
        String userName = null;
        String password = null;
        String securityDomain = null;
        block9: while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return new CredentialImpl(userName, password, securityDomain);
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            password = this.elementAsString(reader);
                            if (this.propertyResolver == null || password == null) break block0;
                            String resolvedPassword = this.propertyResolver.resolve(password);
                            if (resolvedPassword == null) continue block9;
                            password = resolvedPassword;
                            break block0;
                        }
                        case USER_NAME: {
                            userName = this.elementAsString(reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            securityDomain = this.elementAsString(reader);
                            break block0;
                        }
                        default: {
                            throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                        }
                    }
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }
}

