/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.common.pool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.subsystems.common.pool.Constants;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.api.management.Connector;
import org.jboss.jca.core.api.management.DataSource;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.msc.service.ServiceController;

public class PoolConfigurationRWHandler {
    static final String[] NO_LOCATION = new String[0];
    public static final List<String> ATTRIBUTES = Arrays.asList(Constants.MAX_POOL_SIZE.getName(), Constants.MIN_POOL_SIZE.getName(), Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName(), Constants.IDLETIMEOUTMINUTES.getName(), Constants.BACKGROUNDVALIDATION.getName(), Constants.BACKGROUNDVALIDATIONMILLIS.getName(), Constants.POOL_PREFILL.getName(), Constants.POOL_USE_STRICT_MIN.getName(), Constants.POOL_FLUSH_STRATEGY.getName());

    public static class RaPoolConfigurationWriteHandler
    extends PoolConfigurationWriteHandler {
        public static RaPoolConfigurationWriteHandler INSTANCE = new RaPoolConfigurationWriteHandler();

        protected RaPoolConfigurationWriteHandler() {
        }

        @Override
        protected List<PoolConfiguration> getMatchingPoolConfigs(String jndiName, ManagementRepository repository) {
            ArrayList<PoolConfiguration> result = new ArrayList<PoolConfiguration>(repository.getConnectors().size());
            if (repository.getConnectors() != null) {
                for (Connector conn : repository.getConnectors()) {
                    if (!jndiName.equalsIgnoreCase(conn.getUniqueId()) || conn.getConnectionFactories() == null || conn.getConnectionFactories().get(0) == null) continue;
                    PoolConfiguration pc = ((ConnectionFactory)conn.getConnectionFactories().get(0)).getPoolConfiguration();
                    result.add(pc);
                }
            }
            result.trimToSize();
            return result;
        }
    }

    public static class LocalAndXaDataSourcePoolConfigurationWriteHandler
    extends PoolConfigurationWriteHandler {
        public static LocalAndXaDataSourcePoolConfigurationWriteHandler INSTANCE = new LocalAndXaDataSourcePoolConfigurationWriteHandler();

        protected LocalAndXaDataSourcePoolConfigurationWriteHandler() {
        }

        @Override
        protected List<PoolConfiguration> getMatchingPoolConfigs(String jndiName, ManagementRepository repository) {
            ArrayList<PoolConfiguration> result = new ArrayList<PoolConfiguration>(repository.getDataSources().size());
            if (repository.getDataSources() != null) {
                for (DataSource ds : repository.getDataSources()) {
                    if (!jndiName.equalsIgnoreCase(ds.getJndiName())) continue;
                    result.add(ds.getPoolConfiguration());
                }
            }
            result.trimToSize();
            return result;
        }
    }

    public static abstract class PoolConfigurationWriteHandler
    extends AbstractWriteAttributeHandler<List<PoolConfiguration>> {
        protected PoolConfigurationWriteHandler() {
            super((AttributeDefinition[])Constants.POOL_ATTRIBUTES);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String parameterName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<List<PoolConfiguration>> handbackHolder) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String jndiName = address.getLastElement().getValue();
            ServiceController managementRepoService = context.getServiceRegistry(false).getService(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE);
            List<PoolConfiguration> poolConfigs = null;
            if (managementRepoService != null) {
                try {
                    ManagementRepository repository = (ManagementRepository)managementRepoService.getValue();
                    poolConfigs = this.getMatchingPoolConfigs(jndiName, repository);
                    this.updatePoolConfigs(poolConfigs, parameterName, newValue);
                    handbackHolder.setHandback(poolConfigs);
                }
                catch (Exception e) {
                    throw new OperationFailedException(new ModelNode().set(ConnectorMessages.MESSAGES.failedToSetAttribute(e.getLocalizedMessage())));
                }
            }
            return Constants.IDLETIMEOUTMINUTES.getName().equals(parameterName) || Constants.BACKGROUNDVALIDATION.getName().equals(parameterName) || Constants.BACKGROUNDVALIDATIONMILLIS.getName().equals(parameterName) || Constants.POOL_PREFILL.getName().equals(parameterName) || Constants.POOL_FLUSH_STRATEGY.getName().equals(parameterName);
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String parameterName, ModelNode valueToRestore, ModelNode valueToRevert, List<PoolConfiguration> handback) throws OperationFailedException {
            if (handback != null) {
                this.updatePoolConfigs(handback, parameterName, valueToRestore.resolve());
            }
        }

        private void updatePoolConfigs(List<PoolConfiguration> poolConfigs, String parameterName, ModelNode newValue) {
            for (PoolConfiguration pc : poolConfigs) {
                if (Constants.MAX_POOL_SIZE.getName().equals(parameterName)) {
                    pc.setMaxSize(newValue.asInt());
                }
                if (Constants.MIN_POOL_SIZE.getName().equals(parameterName)) {
                    pc.setMinSize(newValue.asInt());
                }
                if (Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.getName().equals(parameterName)) {
                    pc.setBlockingTimeout(newValue.asLong());
                }
                if (Constants.POOL_USE_STRICT_MIN.getName().equals(parameterName)) {
                    pc.setStrictMin(newValue.asBoolean());
                }
                if (!Constants.USE_FAST_FAIL.getName().equals(parameterName)) continue;
                pc.setUseFastFail(newValue.asBoolean());
            }
        }

        protected abstract List<PoolConfiguration> getMatchingPoolConfigs(String var1, ManagementRepository var2);
    }

    public static class PoolConfigurationReadHandler
    implements OperationStepHandler {
        public static PoolConfigurationReadHandler INSTANCE = new PoolConfigurationReadHandler();

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String parameterName = operation.require("name").asString();
            ModelNode submodel = context.readModel(PathAddress.EMPTY_ADDRESS);
            ModelNode currentValue = submodel.hasDefined(parameterName) ? submodel.get(parameterName).clone() : new ModelNode();
            context.getResult().set(currentValue);
            context.stepCompleted();
        }
    }
}

