/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.List;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.subsystems.resourceadapters.AdminObjectService;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableAdminObject;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class AdminObjectAdd
extends AbstractAddStepHandler {
    static final AdminObjectAdd INSTANCE = new AdminObjectAdd();

    private AdminObjectAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode modelNode) throws OperationFailedException {
        for (AttributeDefinition attribute : CommonAttributes.ADMIN_OBJECTS_NODE_ATTRIBUTE) {
            attribute.validateAndSet(operation, modelNode);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode recoveryEnvModel, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        ModifiableAdminObject adminObjectValue;
        ModelNode address = operation.require("address");
        PathAddress path = PathAddress.pathAddress((ModelNode)address);
        String archiveName = path.getElement(path.size() - 2).getValue();
        String poolName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        try {
            adminObjectValue = RaOperationUtil.buildAdminObjects(context, operation, poolName);
        }
        catch (ValidateException e) {
            throw new OperationFailedException((Throwable)e, new ModelNode().set(ConnectorMessages.MESSAGES.failedToCreate("AdminObject", operation, e.getLocalizedMessage())));
        }
        ServiceName serviceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName, poolName});
        ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{archiveName});
        ServiceTarget serviceTarget = context.getServiceTarget();
        AdminObjectService service = new AdminObjectService(adminObjectValue);
        ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(raServiceName, ModifiableResourceAdapter.class, service.getRaInjector()).addListener((ServiceListener)verificationHandler).install();
    }
}

