/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Stack;
import org.jboss.dmr.client.ModelNode;
import org.jboss.dmr.client.dispatch.Action;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.jboss.dmr.client.dispatch.DispatchRequest;
import org.jboss.dmr.client.dispatch.Result;
import org.jboss.dmr.client.dispatch.impl.DMRAction;

public class StaticDispatcher
implements DispatchAsync {
    private final Stack<Object> results = new Stack();
    private Throwable failure = null;
    private Action action;

    public <A extends Action<R>, R extends Result> DispatchRequest execute(A action, AsyncCallback<R> callback) {
        this.action = action;
        if (this.failure != null) {
            callback.onFailure(this.failure);
        } else {
            if (this.results.isEmpty()) {
                throw new IllegalStateException("Results stack is empty. Please call " + StaticDispatcher.class.getSimpleName() + ".push(result) to push expected results!");
            }
            callback.onSuccess((Object)((Result)this.results.pop()));
        }
        return null;
    }

    public <A extends Action<R>, R extends Result> DispatchRequest undo(A action, R result, AsyncCallback<Void> callback) {
        throw new UnsupportedOperationException();
    }

    public <R extends Result> void push(R result) {
        this.results.push(result);
    }

    public ModelNode getLastOperation() {
        if (this.action instanceof DMRAction) {
            return ((DMRAction)this.action).getOperation();
        }
        return null;
    }

    public void setFailure(Throwable failure) {
        this.failure = failure;
    }

    public void clearFailure() {
        this.failure = null;
    }

    public void setProperty(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public void clearProperty(String key) {
        throw new UnsupportedOperationException();
    }
}

