/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */

package org.jboss.as.console.client.shared.subsys.web;

import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import org.jboss.as.console.client.core.DisposableViewImpl;
import org.jboss.ballroom.client.layout.RHSContentPanel;
import org.jboss.as.console.client.shared.help.StaticHelpPanel;
import org.jboss.as.console.client.shared.subsys.web.model.HttpConnector;
import org.jboss.as.console.client.shared.subsys.web.model.JSPContainerConfiguration;
import org.jboss.as.console.client.shared.subsys.web.model.VirtualServer;
import org.jboss.ballroom.client.widgets.ContentGroupLabel;
import org.jboss.ballroom.client.widgets.ContentHeaderLabel;
import org.jboss.ballroom.client.widgets.forms.DisclosureGroupRenderer;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.NumberBoxItem;
import org.jboss.ballroom.client.widgets.forms.StatusItem;
import org.jboss.ballroom.client.widgets.tools.ToolButton;

import java.util.List;

/**
 * @author Heiko Braun
 * @date 5/11/11
 */
public class WebSubsystemView extends DisposableViewImpl implements WebPresenter.MyView{

    private WebPresenter presenter;
    private Form<JSPContainerConfiguration> form;
    private ConnectorList connectorList;
    private VirtualServerList serverList;
    private ToolButton edit;

    @Override
    public Widget createWidget() {

        LayoutPanel layout = new RHSContentPanel("Servlet");

        layout.add(new ContentHeaderLabel("Servlet Subsystem Configuration"));

        // ----

        ContentGroupLabel label = new ContentGroupLabel("JSP Container");
        label.getElement().setAttribute("style", "margin-bottom:0px;");
        layout.add(label);

        /*ToolStrip toolStrip = new ToolStrip();
        edit = new ToolButton("Edit", new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                Console.error("Not implemented yet!");

                if(edit.getText().equals("Edit"))
                    presenter.onEditJSPConfig();
                else
                    presenter.onSaveJSPConfig();
            }
        });
        toolStrip.addToolButton(edit);

        layout.add(toolStrip);*/

        // ----


        form = new Form(JSPContainerConfiguration.class);
        form.setNumColumns(2);

        StatusItem listing = new StatusItem("listings", "Listings?");

        StatusItem disabled= new StatusItem("disabled", "Disabled?");

        StatusItem development= new StatusItem("development", "Development?");

        StatusItem keepGenerated= new StatusItem("keepGenerated", "Keep Generated?");

        NumberBoxItem checkInterval = new NumberBoxItem("checkInterval", "Check Interval");

        StatusItem sourceFragment= new StatusItem("displaySource", "Display Source?");


        form.setFields(disabled, development);
        form.setFieldsInGroup("Advanced", new DisclosureGroupRenderer(), listing, keepGenerated, checkInterval, sourceFragment);


        StaticHelpPanel helpPanel = new StaticHelpPanel(WebDescriptions.getJSPConfigDescription());
        layout.add(helpPanel.asWidget());

        layout.add(form.asWidget());
        form.setEnabled(false); // TODO:

        // ----

        TabPanel bottomLayout = new TabPanel();
        bottomLayout.addStyleName("default-tabpanel");
        bottomLayout.getElement().setAttribute("style", "padding-top:20px;");


        connectorList = new ConnectorList(presenter);
        bottomLayout.add(connectorList.asWidget(),"Connectors");

        serverList = new VirtualServerList(presenter);
        bottomLayout.add(serverList.asWidget(),"Virtual Servers");

        bottomLayout.selectTab(0);

        layout.add(bottomLayout);

        return layout;
    }

    @Override
    public void setPresenter(WebPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setConnectors(List<HttpConnector> connectors) {
        connectorList.setConnectors(connectors);
    }

    @Override
    public void enableEditConnector(boolean b) {
        connectorList.setEnabled(b);
    }

    @Override
    public void setVirtualServers(List<VirtualServer> servers) {
        serverList.setVirtualServers(servers);
    }

    @Override
    public void enableEditVirtualServer(boolean b) {
        serverList.setEnabled(b);
    }

    @Override
    public void enableJSPConfig(boolean b) {
        if(b)
            edit.setText("Save");
        else
            edit.setText("Edit");
    }

    @Override
    public void setJSPConfig(JSPContainerConfiguration jspConfig) {
        form.edit(jspConfig);
    }
}
