/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.as.console.client.shared.subsys.ejb3.model;

import org.jboss.as.console.client.widgets.forms.Address;
import org.jboss.as.console.client.widgets.forms.Binding;
import org.jboss.as.console.client.widgets.forms.FormItem;

/**
 * @author David Bosschaert
 */
@Address("/subsystem=ejb3/service=timer-service")
public interface TimerService {
    @Binding(detypedName="core-threads")
    @FormItem(defaultValue="0",
              label="Core Threads",
              required=true,
              formItemTypeForEdit="NUMBER_BOX",
              order=10)
    int getCoreThreads();
    void setCoreThreads(int threads);

    @Binding(detypedName="max-threads")
    @FormItem(defaultValue="4",
              label="Max Threads",
              required=true,
              formItemTypeForEdit="NUMBER_BOX",
              order=15)
    int getMaxThreads();
    void setMaxThreads(int threads);

    @FormItem(label="Path",
              required=true,
              order=20)
    String getPath();
    void setPath(String path);

    @Binding(detypedName="relative-to")
    @FormItem(label="Relative To",
              required=true,
              order=25)
    String getRelativeTo();
    void setRelativeTo(String location);
}
