
package org.jboss.as.console.client.plugins;

import java.util.*;

public class AccessControlRegistryImpl implements AccessControlRegistry{

private Set<AccessControlMetaData> accessMetaData;
    private ResourceMapping resourceMapping;

    public AccessControlRegistryImpl() {

    this.accessMetaData = new HashSet<AccessControlMetaData>();
        this.resourceMapping = new ResourceMapping();

        
            resourceMapping.put("domain-deployments", "/{selected.host}", "runtime");


            resourceMapping.put("domain-deployments", "/{selected.host}/server-config=*", "runtime");


            resourceMapping.put("domain-deployments", "/{selected.host}/{selected.server}", "runtime");


            resourceMapping.put("domain-deployments", "/{selected.host}/{selected.server}/interface=*", "runtime");


            resourceMapping.put("domain-deployments", "/{selected.host}/{selected.server}/socket-binding-group=*", "runtime");


            resourceMapping.put("domain-deployments", "/deployment=*", "runtime");


            resourceMapping.put("domain-deployments", "/server-group=*", "runtime");


            resourceMapping.put("domain-deployments", "/server-group=*/deployment=*", "runtime");


            resourceMapping.put("server-groups", "/socket-binding-group=*", "runtime");


            resourceMapping.put("server-groups", "/server-group=*", "runtime");


            resourceMapping.put("server-groups", "/server-group=*/jvm=*", "runtime");


            resourceMapping.put("server-groups", "/server-group=*/system-property=*", "runtime");


            resourceMapping.put("host-interfaces", "/{selected.host}/interface=*", "runtime");


            resourceMapping.put("host-jvms", "/{selected.host}/jvm=*", "runtime");


            resourceMapping.put("host-properties", "/{selected.host}/system-property=*", "runtime");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "runtime");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading", "runtime");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory", "runtime");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "runtime");


            resourceMapping.put("server-config", "/socket-binding-group=*", "runtime");


            resourceMapping.put("server-config", "/server-group=*", "runtime");


            resourceMapping.put("server-config", "/{selected.host}/server-config=*", "runtime");


            resourceMapping.put("server-config", "/{selected.host}/server-config=*/jvm=*", "runtime");


            resourceMapping.put("server-config", "/{selected.host}/server-config=*/system-property", "runtime");


            resourceMapping.put("topology", "/server-group=*", "runtime");


            resourceMapping.put("topology", "/extension=*", "runtime");


            resourceMapping.put("interfaces", "interface=*", "configuration");


            resourceMapping.put("path", "path=*", "configuration");


            resourceMapping.put("properties", "system-property=*", "configuration");


            resourceMapping.put("socket-bindings", "socket-binding-group=*", "configuration");


            resourceMapping.put("web-metrics", "/{selected.host}/{selected.server}/subsystem=web", "runtime");


            resourceMapping.put("webservice-runtime", "/{selected.host}/{selected.server}/subsystem=webservices", "runtime");


            resourceMapping.put("configadmin", "/{selected.profile}/subsystem=osgi", "configuration");


            resourceMapping.put("deployment-scanner", "{selected.profile}/subsystem=deployment-scanner", "configuration");


            resourceMapping.put("ee", "{selected.profile}/subsystem=ee", "configuration");


            resourceMapping.put("ejb3", "{selected.profile}/subsystem=ejb3", "configuration");


            resourceMapping.put("ejb3", "{selected.profile}/subsystem=threads/thread-factory=*", "configuration");


            resourceMapping.put("infinispan", "{selected.profile}/subsystem=infinispan", "configuration");


            resourceMapping.put("distributed-cache", "{selected.profile}/subsystem=infinispan", "configuration");


            resourceMapping.put("invalidation-cache", "{selected.profile}/subsystem=infinispan", "configuration");


            resourceMapping.put("local-cache", "{selected.profile}/subsystem=infinispan", "configuration");


            resourceMapping.put("replicated-cache", "{selected.profile}/subsystem=infinispan", "configuration");


            resourceMapping.put("jacorb", "{selected.profile}/subsystem=jacorb", "configuration");


            resourceMapping.put("datasources", "/{selected.profile}/subsystem=datasources/data-source=*", "configuration");


            resourceMapping.put("datasources", "/{selected.profile}/subsystem=datasources/xa-data-source=*", "configuration");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca", "configuration");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/bean-validation=bean-validation", "configuration");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/archive-validation=archive-validation", "configuration");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/cached-connection-manager=cached-connection-manager", "configuration");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/bootstrap-context=*", "configuration");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/workmanager=*", "configuration");


            resourceMapping.put("resource-adapters", "/{selected.profile}/subsystem=resource-adapters/resource-adapter=*", "configuration");


            resourceMapping.put("jgroups", "{selected.profile}/subsystem=jgroups", "configuration");


            resourceMapping.put("jmx", "{selected.profile}/subsystem=jmx", "configuration");


            resourceMapping.put("jpa", "{selected.profile}/subsystem=jpa", "configuration");


            resourceMapping.put("logging", "{selected.profile}/subsystem=logging", "configuration");


            resourceMapping.put("mail", "{selected.profile}/subsystem=mail", "configuration");


            resourceMapping.put("messaging-cluster", "{selected.profile}/subsystem=messaging", "configuration");


            resourceMapping.put("messaging-connections", "{selected.profile}/subsystem=messaging", "configuration");


            resourceMapping.put("messaging", "{selected.profile}/subsystem=messaging", "configuration");


            resourceMapping.put("modcluster", "{selected.profile}/subsystem=modcluster", "configuration");


            resourceMapping.put("osgi-runtime", "/{selected.host}/{selected.server}/subsystem=osgi", "runtime");


            resourceMapping.put("security-domains", "/{selected.profile}/subsystem=security/security-domain=*", "configuration");


            resourceMapping.put("security", "/{selected.profile}/subsystem=security", "configuration");


            resourceMapping.put("threads", "{selected.profile}/subsystem=threads", "configuration");


            resourceMapping.put("transactions", "{selected.profile}/subsystem=transactions", "configuration");


            resourceMapping.put("undertow-core", "{selected.profile}/subsystem=undertow", "configuration");


            resourceMapping.put("undertow-http", "{selected.profile}/subsystem=undertow/server=*", "configuration");


            resourceMapping.put("undertow-servlet", "{selected.profile}/subsystem=undertow/servlet-container=*", "configuration");


            resourceMapping.put("web", "/{selected.profile}/subsystem=web", "configuration");


            resourceMapping.put("webservices", "{selected.profile}/subsystem=webservices", "configuration");


            resourceMapping.put("deployments", "/deployment=*", "configuration");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "runtime");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading", "runtime");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory", "runtime");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "runtime");


     }

     public Set<String> getResources(String token) {
         return resourceMapping.getResources(token);
     }


    public String getFacet(String token) {
         return resourceMapping.getFacet(token);
    }
}