
package org.jboss.as.console.client.plugins;

import java.util.*;

public class AccessControlRegistryImpl implements AccessControlRegistry{

    private Set<AccessControlMetaData> accessMetaData;
    private ResourceMapping resourceMapping;

    public AccessControlRegistryImpl() {

    this.accessMetaData = new HashSet<AccessControlMetaData>();
        this.resourceMapping = new ResourceMapping();

        
            resourceMapping.put("audit-log", "/core-service=management/access=audit", "configuration", "true");


            resourceMapping.put("role-assignement", "/core-service=management/access=authorization", "configuration", "true");


            resourceMapping.put("domain-deployments", "/{selected.host}", "runtime", "false");


            resourceMapping.put("domain-deployments", "/{selected.host}/server-config=*", "runtime", "false");


            resourceMapping.put("domain-deployments", "/{selected.host}/{selected.server}", "runtime", "false");


            resourceMapping.put("domain-deployments", "/{selected.host}/{selected.server}/interface=*", "runtime", "false");


            resourceMapping.put("domain-deployments", "/{selected.host}/{selected.server}/socket-binding-group=*", "runtime", "false");


            resourceMapping.put("domain-deployments", "/deployment=*", "runtime", "false");


            resourceMapping.put("domain-deployments", "/server-group=*", "runtime", "false");


            resourceMapping.put("domain-deployments", "/server-group=*/deployment=*", "runtime", "false");


            resourceMapping.put("server-groups", "/socket-binding-group=*", "runtime", "false");


            resourceMapping.put("server-groups", "/server-group=*", "runtime", "false");


            resourceMapping.put("server-groups", "/server-group=*/jvm=*", "runtime", "false");


            resourceMapping.put("server-groups", "/server-group=*/system-property=*", "runtime", "false");


            resourceMapping.put("host-interfaces", "/{selected.host}/interface=*", "runtime", "true");


            resourceMapping.put("host-jvms", "/{selected.host}/jvm=*", "runtime", "true");


            resourceMapping.put("host-properties", "/{selected.host}/system-property=*", "runtime", "true");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "runtime", "true");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading", "runtime", "true");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory", "runtime", "true");


            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "runtime", "true");


            resourceMapping.put("server-config", "/socket-binding-group=*", "runtime", "false");


            resourceMapping.put("server-config", "/server-group=*", "runtime", "false");


            resourceMapping.put("server-config", "/{selected.host}/server-config=*", "runtime", "false");


            resourceMapping.put("server-config", "/{selected.host}/server-config=*/jvm=*", "runtime", "false");


            resourceMapping.put("server-config", "/{selected.host}/server-config=*/system-property=*", "runtime", "false");


            resourceMapping.put("topology", "/server-group=*", "runtime", "true");


            resourceMapping.put("topology", "/extension=*", "runtime", "true");


            resourceMapping.put("interfaces", "interface=*", "configuration", "true");


            resourceMapping.put("path", "path=*", "configuration", "true");


            resourceMapping.put("properties", "system-property=*", "configuration", "true");


            resourceMapping.put("socket-bindings", "socket-binding-group=*", "configuration", "true");


            resourceMapping.put("ds-metrics", "/{selected.host}/{selected.server}/subsystem=datasources/data-source=*", "runtime", "true");


            resourceMapping.put("ds-metrics", "/{selected.host}/{selected.server}/subsystem=datasources/xa-data-source=*", "runtime", "true");


            resourceMapping.put("environment", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "configuration", "true");


            resourceMapping.put("jms-metrics", "/{selected.host}/{selected.server}/subsystem=messaging/hornetq-server=*", "runtime", "true");


            resourceMapping.put("jpa-metrics", "/{selected.host}/{selected.server}/deployment=*/subsystem=jpa", "configuration", "true");


            resourceMapping.put("naming", "/{selected.host}/{selected.server}/subsystem=naming", "configuration", "true");


            resourceMapping.put("tx-logs", "/{selected.host}/{selected.server}/subsystem=transactions/log-store=log-store", "runtime", "true");


            resourceMapping.put("tx-metrics", "/{selected.host}/{selected.server}/subsystem=transactions", "runtime", "true");


            resourceMapping.put("web-metrics", "/{selected.host}/{selected.server}/subsystem=web", "runtime", "true");


            resourceMapping.put("webservice-runtime", "/{selected.host}/{selected.server}/deployment=*/subsystem=webservices", "runtime", "true");


            resourceMapping.put("configadmin", "/{selected.profile}/subsystem=osgi", "configuration", "true");


            resourceMapping.put("deployment-scanner", "{selected.profile}/subsystem=deployment-scanner", "configuration", "true");


            resourceMapping.put("ee", "{selected.profile}/subsystem=ee", "configuration", "true");


            resourceMapping.put("ejb3", "{selected.profile}/subsystem=ejb3", "configuration", "true");


            resourceMapping.put("ejb3", "{selected.profile}/subsystem=threads/thread-factory=*", "configuration", "true");


            resourceMapping.put("infinispan", "{selected.profile}/subsystem=infinispan", "configuration", "true");


            resourceMapping.put("distributed-cache", "{selected.profile}/subsystem=infinispan", "configuration", "true");


            resourceMapping.put("invalidation-cache", "{selected.profile}/subsystem=infinispan", "configuration", "true");


            resourceMapping.put("local-cache", "{selected.profile}/subsystem=infinispan", "configuration", "true");


            resourceMapping.put("replicated-cache", "{selected.profile}/subsystem=infinispan", "configuration", "true");


            resourceMapping.put("jacorb", "{selected.profile}/subsystem=jacorb", "configuration", "true");


            resourceMapping.put("datasources", "/{selected.profile}/subsystem=datasources/data-source=*", "configuration", "true");


            resourceMapping.put("datasources", "/{selected.profile}/subsystem=datasources/xa-data-source=*", "configuration", "true");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca", "configuration", "true");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/bean-validation=bean-validation", "configuration", "true");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/archive-validation=archive-validation", "configuration", "true");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/cached-connection-manager=cached-connection-manager", "configuration", "true");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/bootstrap-context=*", "configuration", "true");


            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/workmanager=*", "configuration", "true");


            resourceMapping.put("resource-adapters", "/{selected.profile}/subsystem=resource-adapters/resource-adapter=*", "configuration", "true");


            resourceMapping.put("jgroups", "{selected.profile}/subsystem=jgroups", "configuration", "true");


            resourceMapping.put("jmx", "{selected.profile}/subsystem=jmx", "configuration", "true");


            resourceMapping.put("jpa", "{selected.profile}/subsystem=jpa", "configuration", "true");


            resourceMapping.put("logging", "{selected.profile}/subsystem=logging", "configuration", "true");


            resourceMapping.put("mail", "{selected.profile}/subsystem=mail/mail-session=*", "configuration", "true");


            resourceMapping.put("messaging-cluster", "{selected.profile}/subsystem=messaging/hornetq-server=*", "configuration", "true");


            resourceMapping.put("messaging-connections", "{selected.profile}/subsystem=messaging/hornetq-server=*", "configuration", "true");


            resourceMapping.put("messaging-connections", "{selected.profile}/subsystem=messaging/jms-bridge=*", "configuration", "true");


            resourceMapping.put("messaging", "{selected.profile}/subsystem=messaging/hornetq-server=*", "configuration", "true");


            resourceMapping.put("modcluster", "{selected.profile}/subsystem=modcluster", "configuration", "true");


            resourceMapping.put("osgi-configuration", "/{selected.host}/{selected.server}/subsystem=osgi", "runtime", "true");


            resourceMapping.put("osgi-runtime", "/{selected.host}/{selected.server}/subsystem=osgi", "runtime", "true");


            resourceMapping.put("security-domains", "/{selected.profile}/subsystem=security/security-domain=*", "configuration", "true");


            resourceMapping.put("security", "/{selected.profile}/subsystem=security", "configuration", "true");


            resourceMapping.put("threads", "{selected.profile}/subsystem=threads", "configuration", "true");


            resourceMapping.put("transactions", "{selected.profile}/subsystem=transactions", "configuration", "true");


            resourceMapping.put("web", "/{selected.profile}/subsystem=web", "configuration", "true");


            resourceMapping.put("webservices", "{selected.profile}/subsystem=webservices", "configuration", "true");


            resourceMapping.put("deployments", "/deployment=*", "runtime", "false");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "runtime", "true");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading", "runtime", "true");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory", "runtime", "true");


            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "runtime", "true");


     }

     public Set<String> getResources(String token) {
         return resourceMapping.getResources(token);
     }


    public String getFacet(String token) {
         return resourceMapping.getFacet(token);
    }

    public boolean isRecursive(String token) {
        return resourceMapping.isRecursive(token);
    }
}