package org.jboss.as.console.client.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SearchIndexRegistryImpl implements SearchIndexRegistry {

    private final Map<String, SearchIndexMetaData> tokens;

    public SearchIndexRegistryImpl() {
        this.tokens = new HashMap<String, SearchIndexMetaData>();

        String[] resources;
        String[] keywords;

                    resources = new String[] {"/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading","/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime","/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory","/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system",};
            keywords = new String[] {};
            tokens.put("vm", new SearchIndexMetaData("vm", true, false, resources, keywords));
            resources = new String[] {"/deployment=*",};
            keywords = new String[] {"deployment",};
            tokens.put("deployments", new SearchIndexMetaData("deployments", true, false, resources, keywords));
            resources = new String[] {"path=*",};
            keywords = new String[] {"file-system",};
            tokens.put("path", new SearchIndexMetaData("path", true, true, resources, keywords));
            resources = new String[] {"system-property=*",};
            keywords = new String[] {"property","system-property",};
            tokens.put("properties", new SearchIndexMetaData("properties", true, true, resources, keywords));
            resources = new String[] {"socket-binding-group=*",};
            keywords = new String[] {"port","multi-cast","socket","interface","bind-address","network-interface",};
            tokens.put("socket-bindings", new SearchIndexMetaData("socket-bindings", true, true, resources, keywords));
            resources = new String[] {"interface=*",};
            keywords = new String[] {"ip-address","ifconfig","ip","network-interface",};
            tokens.put("interfaces", new SearchIndexMetaData("interfaces", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=jacorb",};
            keywords = new String[] {"corba","iiop",};
            tokens.put("jacorb", new SearchIndexMetaData("jacorb", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=deployment-scanner",};
            keywords = new String[] {};
            tokens.put("deployment-scanner", new SearchIndexMetaData("deployment-scanner", true, true, resources, keywords));
            resources = new String[] {"/{selected.profile}/subsystem=security/security-domain=*",};
            keywords = new String[] {"login-module","jaas","security-domain","authentication","vault","security","authorisation",};
            tokens.put("security-domains", new SearchIndexMetaData("security-domains", true, true, resources, keywords));
            resources = new String[] {"/{selected.profile}/subsystem=security",};
            keywords = new String[] {"login-config","jaas","login-module","login-context","authentication",};
            tokens.put("security", new SearchIndexMetaData("security", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=jgroups",};
            keywords = new String[] {"protocol","cluster","group-communication","channel",};
            tokens.put("jgroups", new SearchIndexMetaData("jgroups", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=mail/mail-session=*",};
            keywords = new String[] {"smtp","mail","imap","channel",};
            tokens.put("mail", new SearchIndexMetaData("mail", true, true, resources, keywords));
            resources = new String[] {"/{selected.profile}/subsystem=web",};
            keywords = new String[] {"jsp","http","virtual-host","ssl","filter","servlet",};
            tokens.put("web", new SearchIndexMetaData("web", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=jmx",};
            keywords = new String[] {"mbean","jmx","connector","management",};
            tokens.put("jmx", new SearchIndexMetaData("jmx", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=io",};
            keywords = new String[] {};
            tokens.put("io", new SearchIndexMetaData("io", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=jpa",};
            keywords = new String[] {"jpa","data-source",};
            tokens.put("jpa", new SearchIndexMetaData("jpa", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=undertow/servlet-container=*",};
            keywords = new String[] {};
            tokens.put("servlet", new SearchIndexMetaData("servlet", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=undertow/server=*",};
            keywords = new String[] {};
            tokens.put("http", new SearchIndexMetaData("http", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=transactions",};
            keywords = new String[] {"log-store","transaction",};
            tokens.put("transactions", new SearchIndexMetaData("transactions", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=threads",};
            keywords = new String[] {"thread","thread-pool",};
            tokens.put("threads", new SearchIndexMetaData("threads", true, true, resources, keywords));
            resources = new String[] {"/{selected.profile}/subsystem=datasources/data-source=*","/{selected.profile}/subsystem=datasources/xa-data-source=*",};
            keywords = new String[] {"xa-data-source","pool","jpa","data-source","connection-properties","jdbc",};
            tokens.put("datasources", new SearchIndexMetaData("datasources", true, true, resources, keywords));
            resources = new String[] {"/{selected.profile}/subsystem=resource-adapters/resource-adapter=*",};
            keywords = new String[] {"jca","resource-adapter","workmanager","connector","bootstrap-context",};
            tokens.put("resource-adapters", new SearchIndexMetaData("resource-adapters", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=jca/workmanager=*","{selected.profile}/subsystem=jca","{selected.profile}/subsystem=jca/archive-validation=archive-validation","{selected.profile}/subsystem=jca/bootstrap-context=*","{selected.profile}/subsystem=jca/cached-connection-manager=cached-connection-manager","{selected.profile}/subsystem=jca/bean-validation=bean-validation",};
            keywords = new String[] {"pool","resource-management",};
            tokens.put("jca", new SearchIndexMetaData("jca", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=batch",};
            keywords = new String[] {};
            tokens.put("batch", new SearchIndexMetaData("batch", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=modcluster",};
            keywords = new String[] {"load-balancing","reverse-proxy","web-frontend","cluster",};
            tokens.put("modcluster", new SearchIndexMetaData("modcluster", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=infinispan",};
            keywords = new String[] {"cache","cluster",};
            tokens.put("distributed-cache", new SearchIndexMetaData("distributed-cache", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=infinispan",};
            keywords = new String[] {"cache","cluster",};
            tokens.put("replicated-cache", new SearchIndexMetaData("replicated-cache", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=infinispan",};
            keywords = new String[] {"cache","local",};
            tokens.put("local-cache", new SearchIndexMetaData("local-cache", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=infinispan",};
            keywords = new String[] {"cache","cluster",};
            tokens.put("invalidation-cache", new SearchIndexMetaData("invalidation-cache", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=infinispan",};
            keywords = new String[] {"hibernate","ejb","cache","transport","web",};
            tokens.put("infinispan", new SearchIndexMetaData("infinispan", true, true, resources, keywords));
            resources = new String[] {"/{selected.profile}/subsystem=osgi",};
            keywords = new String[] {};
            tokens.put("configadmin", new SearchIndexMetaData("configadmin", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=messaging/hornetq-server=*",};
            keywords = new String[] {"jms","broadcast","cluster","messaging","discovery",};
            tokens.put("messaging-cluster", new SearchIndexMetaData("messaging-cluster", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=messaging/hornetq-server=*",};
            keywords = new String[] {"topic","queue","subscribe","jms","messaging","publish",};
            tokens.put("messaging", new SearchIndexMetaData("messaging", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=messaging/hornetq-server=*","{selected.profile}/subsystem=messaging/jms-bridge=*",};
            keywords = new String[] {"acceptor","jms","connector","bridge",};
            tokens.put("messaging-connections", new SearchIndexMetaData("messaging-connections", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=logging",};
            keywords = new String[] {"log-file","category","pattern","log-level","log","log4j","handler",};
            tokens.put("logging", new SearchIndexMetaData("logging", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=webservices",};
            keywords = new String[] {"client-config","wsdl","endpoint-config","web","soap",};
            tokens.put("webservices", new SearchIndexMetaData("webservices", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=ejb3",};
            keywords = new String[] {"mdb","timer-service","passivation","invocation","thread-pool","remote","interface","remote-service","ejb","iiop","bean-pool","ejb3","cluster","local",};
            tokens.put("ejb3", new SearchIndexMetaData("ejb3", true, true, resources, keywords));
            resources = new String[] {"{selected.profile}/subsystem=ee",};
            keywords = new String[] {"thread-factory","ee","context-service","scheduler","executor","managed-bean",};
            tokens.put("ee", new SearchIndexMetaData("ee", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=datasources/xa-data-source=*","/{selected.host}/{selected.server}/subsystem=datasources/data-source=*",};
            keywords = new String[] {"pool","data-source","pool-usage",};
            tokens.put("ds-metrics", new SearchIndexMetaData("ds-metrics", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=web",};
            keywords = new String[] {"http","web","connections",};
            tokens.put("web-metrics", new SearchIndexMetaData("web-metrics", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/deployment=*/subsystem=jpa",};
            keywords = new String[] {"hibernate","jpa",};
            tokens.put("jpa-metrics", new SearchIndexMetaData("jpa-metrics", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=transactions/log-store=log-store",};
            keywords = new String[] {"transaction","durability","transaction-log","recovery",};
            tokens.put("tx-logs", new SearchIndexMetaData("tx-logs", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=transactions",};
            keywords = new String[] {"failure","commit","transaction","transaction-log",};
            tokens.put("tx-metrics", new SearchIndexMetaData("tx-metrics", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime",};
            keywords = new String[] {"environment","runtime","jvm",};
            tokens.put("environment", new SearchIndexMetaData("environment", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=naming",};
            keywords = new String[] {"jndi-tree","lookup","jndi",};
            tokens.put("naming", new SearchIndexMetaData("naming", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=messaging/hornetq-server=*",};
            keywords = new String[] {"topic","queue","jms","size",};
            tokens.put("jms-metrics", new SearchIndexMetaData("jms-metrics", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/subsystem=logging",};
            keywords = new String[] {"log-file","log-view","download","server-log",};
            tokens.put("logfiles", new SearchIndexMetaData("logfiles", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/deployment=*/subsystem=webservices",};
            keywords = new String[] {"jaxws","webservices","jbossws","endpoint",};
            tokens.put("webservice-runtime", new SearchIndexMetaData("webservice-runtime", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/core-service=patching","/{selected.host}",};
            keywords = new String[] {"upgrade","update","patching",};
            tokens.put("patching", new SearchIndexMetaData("patching", true, true, resources, keywords));
            resources = new String[] {"/core-service=management/access=authorization",};
            keywords = new String[] {"authorization","security","rbac","access-control",};
            tokens.put("role-assignment", new SearchIndexMetaData("role-assignment", true, true, resources, keywords));
            resources = new String[] {"/{selected.host}/core-service=management/access=audit",};
            keywords = new String[] {"audit","management","log",};
            tokens.put("audit-log", new SearchIndexMetaData("audit-log", true, true, resources, keywords));
            resources = new String[] {"/server-group=*","/{selected.host}/server-config=*",};
            keywords = new String[] {"stop","status","start","domain-overview","server-group","domain","server",};
            tokens.put("topology", new SearchIndexMetaData("topology", false, true, resources, keywords));
            resources = new String[] {"/server-group={addressable.group}/deployment-overlay=*","/deployment=*","/server-group={addressable.group}/deployment=*",};
            keywords = new String[] {"application","ear","deployment","war",};
            tokens.put("domain-deployments", new SearchIndexMetaData("domain-deployments", false, true, resources, keywords));
            resources = new String[] {"opt://server-group={selected.entity}/system-property=*","/server-group=*",};
            keywords = new String[] {"server-group","jvm","group","socket-binding","profile",};
            tokens.put("server-groups", new SearchIndexMetaData("server-groups", false, true, resources, keywords));
            resources = new String[] {"/{selected.host}/jvm=*",};
            keywords = new String[] {"heap","xms","xss","jvm","xmx",};
            tokens.put("host-jvms", new SearchIndexMetaData("host-jvms", false, true, resources, keywords));
            resources = new String[] {"/{selected.host}/system-property=*",};
            keywords = new String[] {"property","system-property",};
            tokens.put("host-properties", new SearchIndexMetaData("host-properties", false, true, resources, keywords));
            resources = new String[] {"/{selected.host}/interface=*",};
            keywords = new String[] {"interface","bind-address","network-interface",};
            tokens.put("host-interfaces", new SearchIndexMetaData("host-interfaces", false, true, resources, keywords));
            resources = new String[] {"/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading","/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime","/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory","/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system",};
            keywords = new String[] {"threads","memory-usage","jvm",};
            tokens.put("host-vm", new SearchIndexMetaData("host-vm", false, true, resources, keywords));
            resources = new String[] {"opt://{selected.host}/server-config=*/system-property=*","/{selected.host}/server-config=*",};
            keywords = new String[] {"server-config","jvm","server","socket-binding",};
            tokens.put("server-config", new SearchIndexMetaData("server-config", false, true, resources, keywords));
     }

    @Override
    public Set<String> getTokens(boolean standalone) {
        Set<String> matchingTokens = new HashSet<String>();
        for (SearchIndexMetaData metaData : tokens.values()) {
            if ((standalone && metaData.isStandalone()) || (!standalone && metaData.isDomain())) {
                matchingTokens.add(metaData.getToken());
            }
        }
        return matchingTokens;
    }

    @Override
    public Set<String> getResources(String token) {
        SearchIndexMetaData metaData = tokens.get(token);
        if (metaData != null) {
            return metaData.getResources();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getKeywords(String token) {
        SearchIndexMetaData metaData = tokens.get(token);
        if (metaData != null) {
            return metaData.getKeywords();
        }
        return Collections.emptySet();
    }
}