
package org.jboss.as.console.client.plugins;

import java.util.*;

public class RequiredResourcesRegistryImpl implements RequiredResourcesRegistry {

    private Set<RequiredResourcesMetaData> metaData;
    private ResourceMapping resourceMapping;

    public RequiredResourcesRegistryImpl() {

        this.metaData = new HashSet<RequiredResourcesMetaData>();
        this.resourceMapping = new ResourceMapping();

                    resourceMapping.put("audit-log", "/{selected.host}/core-service=management/access=audit", "true");
            resourceMapping.put("role-assignment", "/core-service=management/access=authorization", "false");
            resourceMapping.put("domain-deployments", "/server-group={addressable.group}/deployment=*", "false");
            resourceMapping.put("domain-deployments", "/server-group={addressable.group}/deployment-overlay=*", "false");
            resourceMapping.put("domain-deployments", "/deployment=*", "false");
            resourceMapping.put("server-groups", "/server-group=*", "false");
            resourceMapping.put("server-groups", "opt://server-group={selected.entity}/system-property=*", "false");
            resourceMapping.put("host-interfaces", "/{selected.host}/interface=*", "true");
            resourceMapping.put("host-jvms", "/{selected.host}/jvm=*", "true");
            resourceMapping.put("host-properties", "/{selected.host}/system-property=*", "true");
            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "true");
            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading", "true");
            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory", "true");
            resourceMapping.put("host-vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "true");
            resourceMapping.put("server-config", "/{selected.host}/server-config=*", "false");
            resourceMapping.put("server-config", "opt://{selected.host}/server-config=*/system-property=*", "false");
            resourceMapping.put("topology", "/server-group=*", "false");
            resourceMapping.put("topology", "/{selected.host}/server-config=*", "false");
            resourceMapping.put("interfaces", "interface=*", "true");
            resourceMapping.put("path", "path=*", "true");
            resourceMapping.put("properties", "system-property=*", "true");
            resourceMapping.put("socket-bindings", "socket-binding-group=*", "true");
            resourceMapping.put("patching", "/{selected.host}", "false");
            resourceMapping.put("patching", "/{selected.host}/core-service=patching", "false");
            resourceMapping.put("ds-metrics", "/{selected.host}/{selected.server}/subsystem=datasources/data-source=*", "true");
            resourceMapping.put("ds-metrics", "/{selected.host}/{selected.server}/subsystem=datasources/xa-data-source=*", "true");
            resourceMapping.put("environment", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "true");
            resourceMapping.put("jms-metrics", "/{selected.host}/{selected.server}/subsystem=messaging/hornetq-server=*", "true");
            resourceMapping.put("jpa-metrics", "/{selected.host}/{selected.server}/deployment=*/subsystem=jpa", "true");
            resourceMapping.put("logfiles", "/{selected.host}/{selected.server}/subsystem=logging", "true");
            resourceMapping.put("logviewer", "/{selected.host}/{selected.server}/subsystem=logging", "false");
            resourceMapping.put("naming", "/{selected.host}/{selected.server}/subsystem=naming", "false");
            resourceMapping.put("tx-logs", "/{selected.host}/{selected.server}/subsystem=transactions/log-store=log-store", "true");
            resourceMapping.put("tx-metrics", "/{selected.host}/{selected.server}/subsystem=transactions", "true");
            resourceMapping.put("web-metrics", "/{selected.host}/{selected.server}/subsystem=web", "false");
            resourceMapping.put("webservice-runtime", "/{selected.host}/{selected.server}/deployment=*/subsystem=webservices", "true");
            resourceMapping.put("batch", "{selected.profile}/subsystem=batch", "true");
            resourceMapping.put("configadmin", "/{selected.profile}/subsystem=osgi", "true");
            resourceMapping.put("deployment-scanner", "{selected.profile}/subsystem=deployment-scanner", "true");
            resourceMapping.put("ee", "{selected.profile}/subsystem=ee", "true");
            resourceMapping.put("ejb3", "{selected.profile}/subsystem=ejb3", "true");
            resourceMapping.put("infinispan", "{selected.profile}/subsystem=infinispan", "true");
            resourceMapping.put("distributed-cache", "{selected.profile}/subsystem=infinispan", "true");
            resourceMapping.put("invalidation-cache", "{selected.profile}/subsystem=infinispan", "true");
            resourceMapping.put("local-cache", "{selected.profile}/subsystem=infinispan", "true");
            resourceMapping.put("replicated-cache", "{selected.profile}/subsystem=infinispan", "true");
            resourceMapping.put("io", "{selected.profile}/subsystem=io", "true");
            resourceMapping.put("jacorb", "{selected.profile}/subsystem=jacorb", "true");
            resourceMapping.put("datasources", "/{selected.profile}/subsystem=datasources/data-source=*", "true");
            resourceMapping.put("datasources", "/{selected.profile}/subsystem=datasources/xa-data-source=*", "true");
            resourceMapping.put("jca", "{selected.profile}/subsystem=jca", "true");
            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/bean-validation=bean-validation", "true");
            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/archive-validation=archive-validation", "true");
            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/cached-connection-manager=cached-connection-manager", "true");
            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/bootstrap-context=*", "true");
            resourceMapping.put("jca", "{selected.profile}/subsystem=jca/workmanager=*", "true");
            resourceMapping.put("resource-adapters", "/{selected.profile}/subsystem=resource-adapters/resource-adapter=*", "true");
            resourceMapping.put("jgroups", "{selected.profile}/subsystem=jgroups", "true");
            resourceMapping.put("jmx", "{selected.profile}/subsystem=jmx", "false");
            resourceMapping.put("jpa", "{selected.profile}/subsystem=jpa", "true");
            resourceMapping.put("logging", "{selected.profile}/subsystem=logging", "true");
            resourceMapping.put("mail", "{selected.profile}/subsystem=mail/mail-session=*", "true");
            resourceMapping.put("messaging-cluster", "{selected.profile}/subsystem=messaging/hornetq-server=*", "true");
            resourceMapping.put("messaging-connections", "{selected.profile}/subsystem=messaging/hornetq-server=*", "true");
            resourceMapping.put("messaging-connections", "{selected.profile}/subsystem=messaging/jms-bridge=*", "true");
            resourceMapping.put("messaging", "{selected.profile}/subsystem=messaging/hornetq-server=*", "true");
            resourceMapping.put("modcluster", "{selected.profile}/subsystem=modcluster", "false");
            resourceMapping.put("remoting", "{selected.profile}/subsystem=remoting/configuration=endpoint", "true");
            resourceMapping.put("remoting", "{selected.profile}/subsystem=remoting/connector=*", "true");
            resourceMapping.put("remoting", "{selected.profile}/subsystem=remoting/http-connector=*", "true");
            resourceMapping.put("remoting", "{selected.profile}/subsystem=remoting/local-outbound-connection=*", "true");
            resourceMapping.put("remoting", "{selected.profile}/subsystem=remoting/outbound-connection=*", "true");
            resourceMapping.put("remoting", "{selected.profile}/subsystem=remoting/remote-outbound-connection=*", "true");
            resourceMapping.put("security-domains", "/{selected.profile}/subsystem=security/security-domain=*", "true");
            resourceMapping.put("security", "/{selected.profile}/subsystem=security", "false");
            resourceMapping.put("threads", "{selected.profile}/subsystem=threads", "true");
            resourceMapping.put("transactions", "{selected.profile}/subsystem=transactions", "true");
            resourceMapping.put("http-metrics", "/{selected.host}/{selected.server}/subsystem=undertow", "true");
            resourceMapping.put("http", "{selected.profile}/subsystem=undertow/server=*", "true");
            resourceMapping.put("servlet", "{selected.profile}/subsystem=undertow/servlet-container=*", "true");
            resourceMapping.put("web", "/{selected.profile}/subsystem=web", "false");
            resourceMapping.put("webservices", "{selected.profile}/subsystem=webservices", "true");
            resourceMapping.put("deployments", "/deployment=*", "false");
            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=runtime", "true");
            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=threading", "true");
            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=memory", "true");
            resourceMapping.put("vm", "/{selected.host}/{selected.server}/core-service=platform-mbean/type=operating-system", "true");

            resourceMapping.addOperation("naming", "/{selected.host}/{selected.server}/subsystem=naming#jndi-view");
            resourceMapping.addOperation("tx-logs", "/{selected.host}/{selected.server}/subsystem=transactions/log-store=log-store#probe");
    }

    public Set<String> getTokens() {
        return resourceMapping.getTokens();
    }

    public Set<String> getResources(String token) {
         return resourceMapping.getResources(token);
    }

    public Set<String> getOperations(String token) {
        return resourceMapping.getOperations(token);
    }

    public boolean isRecursive(String token) {
        return resourceMapping.isRecursive(token);
    }
}