/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;

class OperationImpl
implements OperationBuilder,
Operation {
    private final ModelNode operation;
    private volatile List<InputStream> inputStreams;

    OperationImpl(ModelNode operation) {
        this.operation = operation;
    }

    @Override
    public ModelNode getOperation() {
        return this.operation;
    }

    @Override
    public List<InputStream> getInputStreams() {
        if (this.inputStreams == null) {
            return Collections.emptyList();
        }
        return this.inputStreams;
    }

    @Override
    public OperationBuilder addInputStream(InputStream in) {
        if (this.inputStreams == null) {
            this.inputStreams = new ArrayList<InputStream>();
        }
        this.inputStreams.add(in);
        return this;
    }

    @Override
    public int getInputStreamCount() {
        List<InputStream> list = this.inputStreams;
        return list == null ? 0 : list.size();
    }

    @Override
    public Operation build() {
        return this;
    }

    @Override
    public Operation clone() {
        OperationImpl copy = new OperationImpl(this.operation.clone());
        if (this.inputStreams != null) {
            copy.inputStreams = new ArrayList<InputStream>(this.inputStreams);
        }
        return copy;
    }

    @Override
    public Operation clone(ModelNode operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Null operation");
        }
        OperationImpl copy = new OperationImpl(operation);
        if (this.inputStreams != null) {
            copy.inputStreams = new ArrayList<InputStream>(this.inputStreams);
        }
        return copy;
    }
}

