/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.threads.JBossThreadFactory;

public class ClientConfigurationImpl
implements ModelControllerClientConfiguration {
    private static final int DEFAULT_MAX_THREADS = ClientConfigurationImpl.getSystemProperty("org.jboss.as.controller.client.max-threads", 6);
    private final String address;
    private final int port;
    private final CallbackHandler handler;
    private final Map<String, String> saslOptions;
    private final SSLContext sslContext;
    private final ExecutorService executorService;

    static ExecutorService createDefaultExecutor() {
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("management-client-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
        return new ThreadPoolExecutor(2, DEFAULT_MAX_THREADS, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)threadFactory);
    }

    protected ClientConfigurationImpl(String address, int port, CallbackHandler handler, Map<String, String> saslOptions, SSLContext sslContext, ExecutorService executorService) {
        this.address = address;
        this.port = port;
        this.handler = handler;
        this.saslOptions = saslOptions;
        this.sslContext = sslContext;
        this.executorService = executorService;
    }

    @Override
    public String getHost() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.handler;
    }

    @Override
    public Map<String, String> getSaslOptions() {
        return this.saslOptions;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public int getConnectionTimeout() {
        return 5000;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executorService;
    }

    public static ModelControllerClientConfiguration create(InetAddress address, int port) {
        return new ClientConfigurationImpl(address.getHostName(), port, null, null, null, ClientConfigurationImpl.createDefaultExecutor());
    }

    public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler) {
        return new ClientConfigurationImpl(address.getHostName(), port, handler, null, null, ClientConfigurationImpl.createDefaultExecutor());
    }

    public static ModelControllerClientConfiguration create(InetAddress address, int port, CallbackHandler handler, Map<String, String> saslOptions) {
        return new ClientConfigurationImpl(address.getHostName(), port, handler, saslOptions, null, ClientConfigurationImpl.createDefaultExecutor());
    }

    public static ModelControllerClientConfiguration create(String hostName, int port) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, null, null, null, ClientConfigurationImpl.createDefaultExecutor());
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, null, ClientConfigurationImpl.createDefaultExecutor());
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, SSLContext sslContext) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, null, sslContext, ClientConfigurationImpl.createDefaultExecutor());
    }

    public static ModelControllerClientConfiguration create(String hostName, int port, CallbackHandler handler, Map<String, String> saslOptions) throws UnknownHostException {
        return new ClientConfigurationImpl(hostName, port, handler, saslOptions, null, ClientConfigurationImpl.createDefaultExecutor());
    }

    private static int getSystemProperty(final String name, final int defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Integer.getInteger(name, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return Integer.getInteger(name, defaultValue);
            }
        });
    }
}

