/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.BasicModelController;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ControllerResource;
import org.jboss.as.controller.ControllerTransaction;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.as.controller.ModelProvider;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.ModelUpdateOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextFactory;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.TransactionalModelController;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersisterProvider;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class BasicTransactionalModelController
extends BasicModelController
implements TransactionalModelController {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");

    protected BasicTransactionalModelController(ConfigurationPersister configurationPersister) {
        this(new ModelNode().setEmptyObject(), configurationPersister, (DescriptionProvider)null);
    }

    protected BasicTransactionalModelController(ConfigurationPersister configurationPersister, DescriptionProvider rootDescriptionProvider) {
        this(new ModelNode().setEmptyObject(), configurationPersister, rootDescriptionProvider);
    }

    protected BasicTransactionalModelController(ModelNode model, ConfigurationPersister configurationPersister, DescriptionProvider rootDescriptionProvider) {
        super(model, configurationPersister, rootDescriptionProvider);
    }

    protected BasicTransactionalModelController(ModelNode model, ConfigurationPersister configurationPersister, ModelNodeRegistration rootRegistry) {
        super(model, configurationPersister, rootRegistry);
    }

    @Override
    public ModelNode execute(Operation executionContext, ControllerTransactionContext transaction) {
        return super.execute(executionContext, transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult execute(Operation executionContext, ResultHandler handler) {
        ControllerTransaction transaction = null;
        try {
            Object address;
            if (executionContext.getOperation().hasDefined("address")) {
                address = PathAddress.pathAddress(executionContext.getOperation().get("address"));
                ProxyController proxyExecutor = this.getRegistry().getProxyController((PathAddress)address);
                if (proxyExecutor != null) {
                    Operation newContext = executionContext.clone();
                    newContext.getOperation().get("address").set(((PathAddress)address).subAddress(proxyExecutor.getProxyNodeAddress().size()).toModelNode());
                    OperationResult operationResult = proxyExecutor.execute(newContext, handler);
                    return operationResult;
                }
            }
            transaction = new ControllerTransaction();
            address = this.execute(executionContext, handler, transaction);
            return address;
        }
        catch (Throwable t) {
            log.errorf(t, "operation (%s) failed - address: (%s)", (Object)executionContext.getOperation().get("operation"), (Object)executionContext.getOperation().get("address"));
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
            handler.handleFailed(this.getFailureResult(t));
            BasicOperationResult basicOperationResult = new BasicOperationResult();
            return basicOperationResult;
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
    }

    @Override
    public OperationResult execute(Operation executionContext, ResultHandler handler, ControllerTransactionContext transaction) {
        return this.execute(executionContext, handler, this.getModelProvider(), this.getOperationContextFactory(), this.getConfigurationPersisterProvider(), transaction);
    }

    protected OperationResult execute(Operation executionContext, ResultHandler handler, ModelProvider modelSource, OperationContextFactory contextFactory, ConfigurationPersisterProvider configurationPersisterProvider, ControllerTransactionContext transaction) {
        try {
            PathAddress address = PathAddress.pathAddress(executionContext.getOperation().get("address"));
            ProxyController proxyExecutor = this.getRegistry().getProxyController(address);
            if (proxyExecutor != null) {
                Operation newContext = executionContext.clone();
                newContext.getOperation().get("address").set(address.subAddress(proxyExecutor.getProxyNodeAddress().size()).toModelNode());
                return proxyExecutor.execute(newContext, handler);
            }
            if (this.isMultiStepOperation(executionContext, address)) {
                BasicModelController.MultiStepOperationController multistepController = this.getMultiStepOperationController(executionContext, handler, modelSource, configurationPersisterProvider, transaction);
                return multistepController.execute(handler);
            }
            String operationName = executionContext.getOperation().require("operation").asString();
            OperationHandler operationHandler = this.getRegistry().getOperationHandler(address, operationName);
            if (operationHandler == null) {
                throw new IllegalStateException("No handler for " + operationName + " at address " + address);
            }
            OperationContext context = contextFactory.getOperationContext(modelSource, address, operationHandler, executionContext);
            try {
                OperationResult result = operationHandler.execute(context, executionContext.getOperation(), handler);
                ControllerResource txResource = this.getControllerResource(context, executionContext.getOperation(), operationHandler, handler, address, modelSource, configurationPersisterProvider);
                if (txResource != null) {
                    transaction.registerResource(txResource);
                }
                return result;
            }
            catch (OperationFailedException e) {
                transaction.setRollbackOnly();
                handler.handleFailed(e.getFailureDescription());
                return new BasicOperationResult();
            }
        }
        catch (Throwable t) {
            transaction.setRollbackOnly();
            log.errorf(t, "operation (%s) failed - address: (%s)", (Object)executionContext.getOperation().get("operation"), (Object)executionContext.getOperation().get("address"));
            handler.handleFailed(this.getFailureResult(t));
            return new BasicOperationResult();
        }
    }

    protected BasicModelController.MultiStepOperationController getMultiStepOperationController(Operation executionContext, ResultHandler handler, ModelProvider modelSource, ConfigurationPersisterProvider persisterProvider, ControllerTransactionContext transaction) throws OperationFailedException {
        return new TransactionalMultiStepOperationController(executionContext, handler, modelSource, persisterProvider, transaction);
    }

    protected ControllerResource getControllerResource(OperationContext context, ModelNode operation, OperationHandler operationHandler, ResultHandler resultHandler, PathAddress address, ModelProvider modelProvider, ConfigurationPersisterProvider persisterProvider) {
        UpdateModelControllerResource resource = null;
        if (operationHandler instanceof ModelUpdateOperationHandler) {
            resource = new UpdateModelControllerResource(operationHandler, address, context.getSubModel(), modelProvider, persisterProvider);
        }
        return resource;
    }

    protected class TransactionalMultiStepOperationController
    extends BasicModelController.MultiStepOperationController {
        protected final ControllerTransactionContext transaction;

        protected TransactionalMultiStepOperationController(Operation executionContext, ResultHandler resultHandler, ModelProvider modelSource, ConfigurationPersisterProvider persisterProvider, ControllerTransactionContext transaction) throws OperationFailedException {
            super(executionContext, resultHandler, modelSource, persisterProvider);
            this.transaction = transaction;
        }

        @Override
        protected void updateModelAndPersist() {
            ControllerResource resource = new ControllerResource(){

                @Override
                public void commit() {
                    TransactionalMultiStepOperationController.this.commit();
                }

                @Override
                public void rollback() {
                }
            };
            this.transaction.registerResource(resource);
        }

        private void commit() {
            super.updateModelAndPersist();
        }
    }

    protected class UpdateModelControllerResource
    implements ControllerResource {
        protected final PathAddress address;
        protected final ModelNode subModel;
        protected final boolean isRemove;
        protected final ModelProvider modelProvider;
        protected final ConfigurationPersisterProvider persisterProvider;

        public UpdateModelControllerResource(OperationHandler handler, PathAddress address, ModelNode subModel, ModelProvider modelProvider, ConfigurationPersisterProvider persisterProvider) {
            if (handler instanceof ModelUpdateOperationHandler) {
                this.address = address;
                this.subModel = subModel;
                this.isRemove = handler instanceof ModelRemoveOperationHandler;
                this.modelProvider = modelProvider;
                this.persisterProvider = persisterProvider;
            } else {
                this.address = null;
                this.subModel = null;
                this.isRemove = false;
                this.modelProvider = null;
                this.persisterProvider = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            if (this.address != null) {
                ModelNode model;
                ModelNode modelNode = model = this.modelProvider.getModel();
                synchronized (modelNode) {
                    if (this.isRemove) {
                        this.address.remove(model);
                    } else {
                        this.address.navigate(model, true).set(this.subModel);
                    }
                    BasicTransactionalModelController.this.persistConfiguration(model, this.persisterProvider);
                }
            }
        }

        @Override
        public void rollback() {
        }
    }
}

