/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.jboss.as.controller.ControllerResource;
import org.jboss.as.controller.ControllerTransactionContext;
import org.jboss.dmr.ModelNode;

public class ControllerTransaction
implements ControllerTransactionContext {
    private final Set<ControllerResource> resources = new HashSet<ControllerResource>();
    private volatile boolean rollbackOnly;
    private final ModelNode id;
    private final long creationTime = System.currentTimeMillis();

    public ControllerTransaction() {
        UUID uuid = UUID.randomUUID();
        this.id = new ModelNode();
        this.id.add(uuid.getMostSignificantBits());
        this.id.add(uuid.getLeastSignificantBits());
    }

    public ControllerTransaction(ModelNode id) {
        this.id = id;
    }

    public void commit() {
        for (ControllerResource resource : this.resources) {
            if (this.rollbackOnly) {
                resource.rollback();
                continue;
            }
            resource.commit();
        }
    }

    @Override
    public ModelNode getTransactionId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public void registerResource(ControllerResource resource) {
        this.resources.add(resource);
    }

    @Override
    public void deregisterResource(ControllerResource resource) {
        this.resources.remove(resource);
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }
}

