/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions.common;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentDescription {
    private static final String RESOURCE_NAME = DeploymentDescription.class.getPackage().getName() + ".LocalDescriptions";

    private DeploymentDescription() {
    }

    public static final ModelNode getDeploymentDescription(Locale locale, boolean includeEnabled) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle.getString("deployment"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(false);
        root.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("deployment.name"));
        root.get(new String[]{"attributes", "name", "required"}).set(true);
        root.get(new String[]{"attributes", "name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "name", "nillable"}).set(false);
        root.get(new String[]{"attributes", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "runtime-name", "description"}).set(bundle.getString("deployment.runtime-name"));
        root.get(new String[]{"attributes", "runtime-name", "required"}).set(true);
        root.get(new String[]{"attributes", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "runtime-name", "nillable"}).set(false);
        root.get(new String[]{"attributes", "hash", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"attributes", "hash", "description"}).set(bundle.getString("deployment.hash"));
        root.get(new String[]{"attributes", "hash", "required"}).set(true);
        root.get(new String[]{"attributes", "hash", "min-length"}).set(20);
        root.get(new String[]{"attributes", "hash", "max-length"}).set(20);
        root.get(new String[]{"attributes", "hash", "nillable"}).set(false);
        if (includeEnabled) {
            root.get(new String[]{"attributes", "enabled", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"attributes", "enabled", "description"}).set(bundle.getString("deployment.enabled"));
            root.get(new String[]{"attributes", "enabled", "required"}).set(true);
        }
        root.get("operations");
        root.get("children").setEmptyObject();
        return root;
    }

    public static final ModelNode getUploadDeploymentBytesOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("upload-deployment-bytes");
        root.get("description").set(bundle.getString("deployment.upload-bytes"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("deployment.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "bytes", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "bytes", "description"}).set(bundle.getString("deployment.bytes"));
        root.get(new String[]{"request-properties", "bytes", "required"}).set(true);
        root.get(new String[]{"request-properties", "bytes", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "bytes", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("deployment.hash"));
        root.get(new String[]{"reply-properties", "min-length"}).set(20);
        root.get(new String[]{"reply-properties", "max-length"}).set(20);
        root.get(new String[]{"reply-properties", "nillable"}).set(false);
        return root;
    }

    public static final ModelNode getUploadDeploymentURLOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("upload-deployment-url");
        root.get("description").set(bundle.getString("deployment.upload-url"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("deployment.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "url", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "url", "description"}).set(bundle.getString("deployment.url"));
        root.get(new String[]{"request-properties", "url", "required"}).set(true);
        root.get(new String[]{"request-properties", "url", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "url", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("deployment.hash"));
        root.get(new String[]{"reply-properties", "min-length"}).set(20);
        root.get(new String[]{"reply-properties", "max-length"}).set(20);
        root.get(new String[]{"reply-properties", "nillable"}).set(false);
        return root;
    }

    public static final ModelNode getUploadDeploymentStreamAttachmentOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("upload-deployment-stream");
        root.get("description").set(bundle.getString("deployment.upload-stream"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("deployment.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "input-stream-index", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "input-stream-index", "description"}).set(bundle.getString("deployment.inputstream"));
        root.get(new String[]{"request-properties", "input-stream-index", "required"}).set(true);
        root.get(new String[]{"request-properties", "input-stream-index", "min-value"}).set(0);
        root.get(new String[]{"request-properties", "input-stream-index", "nillable"}).set(false);
        root.get(new String[]{"reply-properties", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"reply-properties", "description"}).set(bundle.getString("deployment.hash"));
        root.get(new String[]{"reply-properties", "min-length"}).set(20);
        root.get(new String[]{"reply-properties", "max-length"}).set(20);
        root.get(new String[]{"reply-properties", "nillable"}).set(false);
        return root;
    }

    public static final ModelNode getAddDeploymentOperation(Locale locale, boolean includeEnabled) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("add");
        root.get("description").set(bundle.getString("deployment.add"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("deployment.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "input-stream-index", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "input-stream-index", "description"}).set(bundle.getString("deployment.inputstream"));
        root.get(new String[]{"request-properties", "input-stream-index", "required"}).set(false);
        root.get(new String[]{"request-properties", "input-stream-index", "min-value"}).set(0);
        root.get(new String[]{"request-properties", "input-stream-index", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "hash", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "hash", "description"}).set(bundle.getString("deployment.hash"));
        root.get(new String[]{"request-properties", "hash", "required"}).set(false);
        root.get(new String[]{"request-properties", "hash", "min-length"}).set(20);
        root.get(new String[]{"request-properties", "hash", "max-length"}).set(20);
        root.get(new String[]{"request-properties", "hash", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "bytes", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "bytes", "description"}).set(bundle.getString("deployment.bytes"));
        root.get(new String[]{"request-properties", "bytes", "required"}).set(false);
        root.get(new String[]{"request-properties", "bytes", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "bytes", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "url", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "url", "description"}).set(bundle.getString("deployment.url"));
        root.get(new String[]{"request-properties", "url", "required"}).set(false);
        root.get(new String[]{"request-properties", "url", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "url", "nillable"}).set(true);
        if (includeEnabled) {
            root.get(new String[]{"request-properties", "enabled", "type"}).set(ModelType.BOOLEAN);
            root.get(new String[]{"request-properties", "enabled", "description"}).set(bundle.getString("deployment.enabled"));
            root.get(new String[]{"request-properties", "enabled", "required"}).set(false);
        }
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getDeployDeploymentOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("deploy");
        root.get("description").set(bundle.getString("deployment.deploy"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getReplaceDeploymentOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("replace-deployment");
        root.get("description").set(bundle.getString("deployment.replace"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("deployment.replace.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "to-replace", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "to-replace", "description"}).set(bundle.getString("deployment.replace.to-replace"));
        root.get(new String[]{"request-properties", "to-replace", "required"}).set(true);
        root.get(new String[]{"request-properties", "to-replace", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "to-replace", "nillable"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "runtime-name", "description"}).set(bundle.getString("deployment.runtime-name"));
        root.get(new String[]{"request-properties", "runtime-name", "required"}).set(false);
        root.get(new String[]{"request-properties", "runtime-name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "runtime-name", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "input-stream-index", "type"}).set(ModelType.INT);
        root.get(new String[]{"request-properties", "input-stream-index", "description"}).set(bundle.getString("deployment.inputstream"));
        root.get(new String[]{"request-properties", "input-stream-index", "required"}).set(false);
        root.get(new String[]{"request-properties", "input-stream-index", "min-value"}).set(0);
        root.get(new String[]{"request-properties", "input-stream-index", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "hash", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "hash", "description"}).set(bundle.getString("deployment.hash"));
        root.get(new String[]{"request-properties", "hash", "required"}).set(false);
        root.get(new String[]{"request-properties", "hash", "min-length"}).set(20);
        root.get(new String[]{"request-properties", "hash", "max-length"}).set(20);
        root.get(new String[]{"request-properties", "hash", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "bytes", "type"}).set(ModelType.BYTES);
        root.get(new String[]{"request-properties", "bytes", "description"}).set(bundle.getString("deployment.bytes"));
        root.get(new String[]{"request-properties", "bytes", "required"}).set(false);
        root.get(new String[]{"request-properties", "bytes", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "bytes", "nillable"}).set(true);
        root.get(new String[]{"request-properties", "url", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "url", "description"}).set(bundle.getString("deployment.url"));
        root.get(new String[]{"request-properties", "url", "required"}).set(false);
        root.get(new String[]{"request-properties", "url", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "url", "nillable"}).set(true);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getFullReplaceDeploymentOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("full-replace-deployment");
        root.get("description").set(bundle.getString("deployment.full-replace"));
        root.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("deployment.name"));
        root.get(new String[]{"request-properties", "name", "required"}).set(true);
        root.get(new String[]{"request-properties", "name", "min-length"}).set(1);
        root.get(new String[]{"request-properties", "name", "nillable"}).set(false);
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getUndeployDeploymentOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("undeploy");
        root.get("description").set(bundle.getString("deployment.undeploy"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static final ModelNode getRedeployDeploymentOperation(Locale locale) {
        ResourceBundle bundle = DeploymentDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("redeploy");
        root.get("description").set(bundle.getString("deployment.redeploy"));
        root.get("request-properties").setEmptyObject();
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }

    public static void main(String[] args) {
        System.out.println(DeploymentDescription.getDeploymentDescription(null, true));
        System.out.println(DeploymentDescription.getAddDeploymentOperation(null, true));
        System.out.println(DeploymentDescription.getDeployDeploymentOperation(null));
        System.out.println(DeploymentDescription.getFullReplaceDeploymentOperation(null));
        System.out.println(DeploymentDescription.getRedeployDeploymentOperation(null));
        System.out.println(DeploymentDescription.getReplaceDeploymentOperation(null));
        System.out.println(DeploymentDescription.getUndeployDeploymentOperation(null));
        System.out.println(DeploymentDescription.getUploadDeploymentBytesOperation(null));
        System.out.println(DeploymentDescription.getUploadDeploymentURLOperation(null));
    }
}

