/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.PathDescription;
import org.jboss.as.controller.operations.common.PathAddHandler;
import org.jboss.dmr.ModelNode;

public class PathRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final PathRemoveHandler INSTANCE = new PathRemoveHandler();

    public static ModelNode getRemovePathOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        return op;
    }

    protected PathRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        ModelNode pathNode = model.get("path");
        String path = pathNode.isDefined() ? pathNode.asString() : null;
        ModelNode relNode = model.get("relative-to");
        String relativeTo = relNode.isDefined() ? pathNode.asString() : null;
        ModelNode compensating = PathAddHandler.getAddPathOperation(operation.get("address"), pathNode, relNode);
        return this.uninstallPath(name, path, relativeTo, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return PathDescription.getPathRemoveOperation(locale);
    }

    protected OperationResult uninstallPath(String name, String path, String relativeTo, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

