/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.CancellationException;
import org.jboss.as.controller.Cancellable;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.protocol.Connection;
import org.jboss.dmr.ModelNode;

public class ModelControllerClientToModelControllerAdapter
implements ModelController {
    final ModelControllerClient client;

    public ModelControllerClientToModelControllerAdapter(InetAddress address, int port) {
        this.client = ModelControllerClient.Factory.create((InetAddress)address, (int)port);
    }

    public ModelControllerClientToModelControllerAdapter(Connection connection) {
        this.client = ModelControllerClient.Factory.create((Connection)connection);
    }

    @Override
    public OperationResult execute(Operation operation, ResultHandler handler) {
        return new OperationHandlerResultAdapter(this.client.execute(operation, (org.jboss.as.controller.client.ResultHandler)new ResultHandlerAdapter(handler)));
    }

    @Override
    public ModelNode execute(Operation operation) throws CancellationException {
        try {
            return this.client.execute(operation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ResultHandlerAdapter
    implements org.jboss.as.controller.client.ResultHandler {
        private final ResultHandler delegate;

        public ResultHandlerAdapter(ResultHandler delegate) {
            this.delegate = delegate;
        }

        public void handleResultFragment(String[] location, ModelNode result) {
            this.delegate.handleResultFragment(location, result);
        }

        public void handleResultComplete() {
            this.delegate.handleResultComplete();
        }

        public void handleCancellation() {
            this.delegate.handleCancellation();
        }

        public void handleFailed(ModelNode failureDescription) {
            this.delegate.handleFailed(failureDescription);
        }
    }

    private static class OperationHandlerResultAdapter
    implements OperationResult,
    Cancellable {
        private final org.jboss.as.controller.client.OperationResult delegate;

        OperationHandlerResultAdapter(org.jboss.as.controller.client.OperationResult delegate) {
            this.delegate = delegate;
        }

        @Override
        public Cancellable getCancellable() {
            return this;
        }

        @Override
        public ModelNode getCompensatingOperation() {
            return this.delegate.getCompensatingOperation();
        }

        @Override
        public boolean cancel() {
            try {
                return this.delegate.getCancellable().cancel();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

